/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

public class TopicId {
    public static final String WILD = "*";
    public static final String WILDWILD = "**";
    private static final String[] ROOT = new String[0];
    private final String name;
    private final String[] segments;
    private final int wild;

    public TopicId(String name) {
        this.name = name;
        if (name == null || name.length() == 0 || name.charAt(0) != '/') {
            throw new IllegalArgumentException("Illegal topic name: " + name);
        }
        if ("/".equals(name)) {
            this.segments = ROOT;
        } else {
            if (name.charAt(name.length() - 1) == '/') {
                throw new IllegalArgumentException("Illegal topic name (should not end with '/'): " + name);
            }
            this.segments = name.substring(1).split("\\Q/\\E", -1);
        }
        this.wild = this.segments.length > 0 ? (WILD.equals(this.segments[this.segments.length - 1]) ? 1 : (WILDWILD.equals(this.segments[this.segments.length - 1]) ? 2 : 0)) : 0;
    }

    public boolean isWild() {
        return this.wild > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TopicId) {
            TopicId other = (TopicId)obj;
            if (this.isWild()) {
                if (other.isWild()) {
                    return this.name.equals(other.name);
                }
                return this.matches(other);
            }
            if (other.isWild()) {
                return other.matches(this);
            }
            return this.name.equals(other.name);
        }
        if (obj instanceof String) {
            if (this.isWild()) {
                return this.matches((String)obj);
            }
            return this.name.equals(obj);
        }
        return false;
    }

    public boolean matches(TopicId name) {
        if (name.isWild()) {
            return this.equals(name);
        }
        switch (this.wild) {
            case 0: {
                return this.equals(name);
            }
            case 1: {
                if (name.segments.length != this.segments.length) {
                    return false;
                }
                int i = this.segments.length - 1;
                while (i-- > 0) {
                    if (this.segments[i].equals(name.segments[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (name.segments.length < this.segments.length) {
                    return false;
                }
                int i = this.segments.length - 1;
                while (i-- > 0) {
                    if (this.segments[i].equals(name.segments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean matches(String name) {
        if (this.wild == 0) {
            return this.name.equals(name);
        }
        return this.matches(new TopicId(name));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public int depth() {
        return this.segments.length;
    }

    public boolean isParentOf(TopicId id) {
        if (this.isWild() || this.depth() >= id.depth()) {
            return false;
        }
        int i = this.segments.length - 1;
        while (i-- > 0) {
            if (this.segments[i].equals(id.segments[i])) continue;
            return false;
        }
        return true;
    }

    public String getSegment(int i) {
        if (i > this.segments.length) {
            return null;
        }
        return this.segments[i];
    }
}

