/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFTransport {
    private static final Logger log = Logger.getLogger(AMFTransport.class);
    private static final String CONTENT_TYPE = "application/x-amf";
    private OutputStream out;
    private HttpServletResponse response;
    private boolean polling;
    private List<Message> messages = new ArrayList<Message>();
    private Message requestMessage = null;

    public AMFTransport(HttpServletRequest request, HttpServletResponse response) {
        log.debug("New transport created for %s:%d", new Object[]{request.getRemoteHost(), request.getRemotePort()});
        this.response = response;
    }

    public void setRequestMessage(Message requestMessage) {
        this.requestMessage = requestMessage;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public boolean isPolling() {
        return this.polling;
    }

    public void setPolling(boolean polling) {
        this.polling = polling;
    }

    public void send(Queue<Message> replies, boolean polling) {
        polling = false;
        if (replies != null) {
            for (Message reply : replies) {
                this.send(reply, polling);
            }
        }
    }

    public void send(Message reply, boolean polling) {
        if (reply != null) {
            log.debug("Sending reply: %s", new Object[]{reply});
            if (reply instanceof AsyncMessage && this.requestMessage != null) {
                ((AsyncMessage)reply).setCorrelationId(this.requestMessage.getMessageId());
            }
            this.messages.add(reply);
        }
        this.setPolling(polling);
    }

    public void complete() throws IOException {
        log.debug("Transport response complete: %s", new Object[]{this.messages});
        HttpServletResponse response = this.getResponse();
        response.setStatus(200);
        if (this.messages.isEmpty()) {
            response.setContentLength(0);
        } else {
            response.setContentType(CONTENT_TYPE);
            this.out = response.getOutputStream();
            ((AMFContextImpl)GraniteContext.getCurrentInstance().getAMFContext()).setCurrentAmf3Message(this.requestMessage);
            AMF3Serializer serializer = new AMF3Serializer(this.out);
            serializer.writeObject((Object)this.messages.toArray());
        }
    }
}

