/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty;

import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.jetty.AMFTransport;
import org.granite.gravity.jetty.ContinuationChannel;
import org.granite.gravity.jetty.ContinuationChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class GravityJettyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityJettyServlet.class);
    private static final String CLIENT_ATTR = "org.granite.gravity.CLIENT_ATTR";
    private static final String TRANSPORT_ATTR = "org.granite.gravity.TRANSPORT_ATTR";
    private Gravity gravity;
    protected long timeout = 20000L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.gravity = GravityConfig.startGravity(config.getServletContext(), new ContinuationChannelFactory());
        this.timeout = this.gravity.getReconnectIntervalMs();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug("doPost: from %s:%d", new Object[]{req.getRemoteAddr(), req.getRemotePort()});
        HttpGraniteContext.createThreadIntance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), (ServletContext)this.getServletContext(), (HttpServletRequest)req, (HttpServletResponse)resp);
        Object channelObj = req.getAttribute(CLIENT_ATTR);
        ContinuationChannel channel = channelObj instanceof ContinuationChannel ? (ContinuationChannel)channelObj : null;
        AMFTransport transport = null;
        if (channel != null) {
            log.debug("doPost: resume continuation for channel: %s, response: %s", new Object[]{channel.getClientId(), resp});
            transport = (AMFTransport)req.getAttribute(TRANSPORT_ATTR);
            transport.setResponse(resp);
        } else {
            Message reply;
            Object[] messages = null;
            int messageIndex = 0;
            Message message = null;
            if ("application/x-amf".equals(req.getContentType())) {
                AMF3Deserializer amf3Deserializer = new AMF3Deserializer((InputStream)req.getInputStream());
                messages = (Object[])amf3Deserializer.readObject();
            }
            if (messages != null && messages.length > 0) {
                message = (Message)messages[messageIndex++];
            }
            if (message == null) {
                throw new ServletException("Empty request not allowed");
            }
            if (log.isDebugEnabled()) {
                log.debug("Message received " + message + " from " + req.getRemoteHost() + ":" + req.getRemotePort(), new Object[0]);
            }
            if ((channel = (ContinuationChannel)this.gravity.getChannel((String)message.getClientId())) == null) {
                log.debug("Client handshake from %s:%d", new Object[]{req.getRemoteHost(), req.getRemotePort()});
                transport = new AMFTransport(req, resp);
                transport.setRequestMessage(message);
                reply = this.gravity.handleMessage(message);
                if (reply != null) {
                    transport.send(reply, false);
                }
                message = null;
            } else {
                log.debug("Client restored %s for %s:%d", new Object[]{channel, req.getRemoteHost(), req.getRemotePort()});
                channel.access();
                transport = new AMFTransport(req, resp);
                transport.setRequestMessage(message);
                try {
                    channel.responsePending();
                    while (message != null) {
                        transport.send(reply, (reply = this.gravity.handleMessage(message)) == null);
                        message = null;
                        if (messages == null || messageIndex >= messages.length) continue;
                        message = (Message)messages[messageIndex++];
                    }
                }
                finally {
                    channel.responded();
                }
            }
        }
        if (channel != null) {
            while (transport.isPolling()) {
                log.debug("%s:%d doPost: transport %s is polling", new Object[]{req.getRemoteHost(), req.getRemotePort(), transport});
                Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)req, (Object)channel);
                if (!continuation.isPending()) {
                    channel.access();
                }
                Queue<Message> messages = null;
                ContinuationChannel continuationChannel = channel;
                synchronized (continuationChannel) {
                    messages = channel.takeMessages();
                    if (!(messages != null && messages.size() != 0 || continuation.isPending())) {
                        log.debug("%s:%d doPost: save state and suspend client ", new Object[]{req.getRemoteHost(), req.getRemotePort(), channel.getClientId()});
                        channel.setContinuation(continuation);
                        req.setAttribute(CLIENT_ATTR, (Object)channel);
                        req.setAttribute(TRANSPORT_ATTR, (Object)transport);
                        log.debug("%s:%d doPost: save transport for client %s: %s", new Object[]{req.getRemoteHost(), req.getRemotePort(), channel.getClientId(), transport});
                        continuation.suspend(this.timeout);
                        messages = channel.takeMessages();
                    }
                    continuation.reset();
                    channel.setContinuation(null);
                    if (messages == null) {
                        transport.setPolling(false);
                    }
                }
                if (messages != null) {
                    transport.send(messages, false);
                }
                transport.setPolling(false);
            }
            channel.resume();
        }
        transport.complete();
    }
}

