/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.granite.gravity.tomcat.RequestReader;
import org.granite.logging.Logger;

public abstract class AbstractCometProcessor
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AbstractCometProcessor.class);
    private static final String REQUEST_READER_KEY = String.valueOf(AbstractCometProcessor.class.getName()) + ".REQUEST_READER";
    private ServletConfig config = null;
    private int timeout = 0;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        String timeout = config.getInitParameter("timeout");
        if (timeout != null) {
            try {
                this.timeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                throw new ServletException("Illegal timeout value: " + timeout);
            }
            if (this.timeout < 0) {
                throw new ServletException("Illegal timeout value: " + timeout);
            }
            log.info("Using event timeout: %s", new Object[]{timeout});
        }
    }

    protected ServletConfig getConfig() {
        return this.config;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public void destroy() {
        this.config = null;
    }

    public abstract boolean handleRequest(CometEvent var1, InputStream var2) throws IOException, ServletException;

    public abstract boolean handleError(CometEvent var1) throws IOException, ServletException;

    public abstract RequestReader newRequestReader() throws ServletException;

    public void event(CometEvent event) throws IOException, ServletException {
        log.debug("%s/%s: %s.%s", new Object[]{event.getHttpServletRequest(), event.getHttpServletResponse(), event.getEventType(), event.getEventSubType()});
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            this.begin(event);
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.read(event);
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.end(event);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.error(event);
        } else {
            throw new ServletException("Unknown CometEvent type: " + event.getEventType());
        }
    }

    protected void begin(CometEvent event) throws IOException, ServletException {
        if (this.timeout > 0) {
            event.setTimeout(this.timeout);
        }
        HttpServletRequest request = event.getHttpServletRequest();
        RequestReader reader = this.newRequestReader();
        request.setAttribute(REQUEST_READER_KEY, (Object)reader);
        if (!reader.readAvailable((InputStream)request.getInputStream())) {
            this.end(event);
        }
    }

    protected void read(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        RequestReader reader = (RequestReader)request.getAttribute(REQUEST_READER_KEY);
        if (!reader.readAvailable((InputStream)request.getInputStream())) {
            this.end(event);
        }
    }

    protected void end(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        RequestReader reader = (RequestReader)request.getAttribute(REQUEST_READER_KEY);
        if (reader == null) {
            event.close();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                attributes.put(name, request.getAttribute(name));
            }
            return;
        }
        request.removeAttribute(REQUEST_READER_KEY);
        boolean close = true;
        try {
            close = this.handleRequest(event, reader.getContent());
        }
        finally {
            if (close) {
                event.close();
            }
        }
    }

    protected void error(CometEvent event) throws IOException, ServletException {
        event.getHttpServletRequest().removeAttribute(REQUEST_READER_KEY);
        boolean close = true;
        try {
            close = this.handleError(event);
        }
        finally {
            if (close) {
                event.close();
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new ServletException("Not in a valid Comet configuration (use an APR or NIO connector)");
    }
}

