/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.granite.gravity.tomcat.RequestReader;

public class SingleReadRequestReader
implements RequestReader {
    private static final byte[] BYTES_0 = new byte[0];
    private byte[] bytes = BYTES_0;

    public boolean readAvailable(InputStream is) throws IOException {
        int available;
        while ((available = is.available()) > 0) {
            int oldLength = this.bytes.length;
            if (oldLength > 0) {
                byte[] newBytes = new byte[available + oldLength];
                System.arraycopy(this.bytes, 0, newBytes, 0, oldLength);
                this.bytes = newBytes;
            } else {
                this.bytes = new byte[available];
            }
            if (is.read(this.bytes, oldLength, available) == available) continue;
            throw new IOException("Could not read available bytes: " + available);
        }
        return available >= 0 && is.read() >= 0;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.bytes);
    }
}

