/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.Gravity;
import org.granite.gravity.tomcat.EventUtil;
import org.granite.gravity.tomcat.OutgoingPool;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.UUIDUtil;

public class TomcatChannel
extends AbstractChannel
implements Runnable {
    private static final Logger log = Logger.getLogger(TomcatChannel.class);
    public static final String CHANNEL_ID_KEY = String.valueOf(TomcatChannel.class.getName()) + ".CHANNEL_ID";
    public static final String AMF3_MESSAGE_KEY = String.valueOf(TomcatChannel.class.getName()) + ".AMF3_MESSAGE_ID";
    private final OutgoingPool outgoing;
    private final ArrayList<Message> queue;
    private State state = State.IDLE;
    private CometEvent event = null;

    public TomcatChannel(Gravity gravity, OutgoingPool outgoing) {
        super(gravity);
        this.outgoing = outgoing;
        this.queue = new ArrayList();
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public synchronized void setCometEvent(CometEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Channel: %s got new event: %s", new Object[]{this.getClientId(), EventUtil.toString(event)});
        }
        if (EventUtil.isTimeout(event)) {
            if (this.state == State.SENDING) {
                if (this.event != null) {
                    throw new IllegalStateException("Current timeout event is not closed, state: " + (Object)((Object)this.state));
                }
                this.event = event;
            } else {
                block17: {
                    this.outgoing.remove(this);
                    if (this.event != null) {
                        try {
                            try {
                                this.event.close();
                            }
                            catch (Exception e) {
                                log.error((Throwable)e, "Error while closing event: %s", new Object[]{EventUtil.toString(this.event)});
                                this.event = null;
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            this.event = null;
                            throw throwable;
                        }
                        this.event = null;
                    }
                }
                try {
                    event.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Error while closing event: %s", new Object[]{EventUtil.toString(event)});
                }
            }
        } else if (this.state == State.IDLE && !EventUtil.isError(event)) {
            if (this.event != null) {
                throw new IllegalStateException("Current event is not closed, state: " + (Object)((Object)this.state));
            }
            this.event = event;
            this.tryToDeliver();
        } else {
            throw new IllegalStateException("State: " + (Object)((Object)this.state) + ", event: " + EventUtil.toString(event));
        }
    }

    protected synchronized void clearQueue() {
        this.queue.clear();
    }

    public synchronized void deliver(AbstractChannel from, Message message, String subscriptionId) {
        log.debug("Channel: %s got new message: %s", new Object[]{this.getClientId(), message});
        message.setHeader("DSDstClientId", (Object)subscriptionId);
        this.queue.add(message);
        this.tryToDeliver();
    }

    protected void tryToDeliver() {
        if (this.state == State.IDLE && this.event != null && !this.queue.isEmpty()) {
            this.state = State.QUEUED;
            try {
                this.outgoing.deliver(this);
            }
            catch (RejectedExecutionException e) {
                log.warn((Throwable)e, "Could not queue channel (queue full): %s", new Object[]{this.getClientId()});
                this.state = State.IDLE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block66: {
            if (log.isDebugEnabled()) {
                log.debug(">> Thread #%d running channel: %s", new Object[]{Thread.currentThread().getId(), this.getClientId()});
            }
            CometEvent event = null;
            Message requestMessage = null;
            AsyncMessage[] pendingMessages = null;
            TomcatChannel tomcatChannel = this;
            synchronized (tomcatChannel) {
                if (this.event == null) {
                    return;
                }
                if (this.event.getHttpServletRequest() == null) {
                    this.gravity.removeChannel(this.getClientId());
                    return;
                }
                if (this.queue.isEmpty()) {
                    log.warn("Empty queue while running channel: %s", new Object[]{this.getClientId()});
                    return;
                }
                this.state = State.SENDING;
                event = this.event;
                this.event = null;
                requestMessage = (Message)event.getHttpServletRequest().getAttribute(AMF3_MESSAGE_KEY);
                pendingMessages = this.queue.toArray(new AsyncMessage[this.queue.size()]);
                this.queue.clear();
            }
            boolean retry = false;
            try {
                AsyncMessage[] responseMessages = new AsyncMessage[pendingMessages.length];
                int i = 0;
                AsyncMessage[] asyncMessageArray = pendingMessages;
                int n = pendingMessages.length;
                int n2 = 0;
                while (n2 < n) {
                    AsyncMessage pendingMessage = asyncMessageArray[n2];
                    AsyncMessage responseMessage = new AsyncMessage();
                    responseMessage.setBody(pendingMessage.getBody());
                    responseMessage.setClientId(pendingMessage.getClientId());
                    responseMessage.setCorrelationId(requestMessage.getMessageId());
                    responseMessage.setDestination(pendingMessage.getDestination());
                    responseMessage.setHeaders(pendingMessage.getHeaders());
                    responseMessage.setMessageId(UUIDUtil.randomUUID());
                    responseMessage.setTimestamp(System.currentTimeMillis());
                    responseMessages[i++] = responseMessage;
                    ++n2;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Thread #%d - Sending: ", new Object[]{Thread.currentThread().getId(), responseMessages});
                }
                HttpServletResponse response = event.getHttpServletResponse();
                HttpGraniteContext context = HttpGraniteContext.createThreadIntance((GraniteConfig)this.gravity.getGraniteConfig(), (ServicesConfig)this.gravity.getServicesConfig(), null, (HttpServletRequest)event.getHttpServletRequest(), (HttpServletResponse)response);
                ((AMFContextImpl)context.getAMFContext()).setCurrentAmf3Message(requestMessage);
                response.setContentType("application/x-amf");
                AMF3Serializer serializer = new AMF3Serializer((OutputStream)response.getOutputStream());
                serializer.writeObject((Object)responseMessages);
                response.setStatus(200);
                response.flushBuffer();
            }
            catch (IOException e) {
                retry = true;
                log.error((Throwable)e, "IO error when sending response for channel: %s (retrying latter)", new Object[]{this.getClientId()});
                GraniteContext.release();
                TomcatChannel tomcatChannel2 = this;
                synchronized (tomcatChannel2) {
                    block65: {
                        this.state = State.IDLE;
                        try {
                            event.close();
                        }
                        catch (Exception e2) {
                            log.error((Throwable)e2, "Error while closing event: %s", new Object[]{event});
                        }
                        if (this.event != null) {
                            if (!EventUtil.isTimeout(this.event)) {
                                log.error("Unexpected event when closing response: %s", new Object[]{EventUtil.toString(this.event)});
                            }
                            try {
                                try {
                                    this.event.close();
                                }
                                catch (IOException e3) {
                                    log.error((Throwable)e3, "Error while closing event: %s", new Object[]{EventUtil.toString(this.event)});
                                    this.event = null;
                                    break block65;
                                }
                            }
                            catch (Throwable throwable) {
                                this.event = null;
                                throw throwable;
                            }
                            this.event = null;
                        }
                    }
                    if (retry) {
                        this.queue.addAll(0, (Collection<Message>)Arrays.asList(pendingMessages));
                    }
                    break block66;
                }
            }
            catch (Exception e) {
                try {
                    log.error((Throwable)e, "Unrecoverable error when sending response for channel: %s", new Object[]{this.getClientId()});
                }
                catch (Throwable throwable) {
                    GraniteContext.release();
                    TomcatChannel tomcatChannel3 = this;
                    synchronized (tomcatChannel3) {
                        block70: {
                            this.state = State.IDLE;
                            try {
                                event.close();
                            }
                            catch (Exception e4) {
                                log.error((Throwable)e4, "Error while closing event: %s", new Object[]{event});
                            }
                            if (this.event != null) {
                                if (!EventUtil.isTimeout(this.event)) {
                                    log.error("Unexpected event when closing response: %s", new Object[]{EventUtil.toString(this.event)});
                                }
                                try {
                                    try {
                                        this.event.close();
                                    }
                                    catch (IOException e5) {
                                        log.error((Throwable)e5, "Error while closing event: %s", new Object[]{EventUtil.toString(this.event)});
                                        this.event = null;
                                        break block70;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    this.event = null;
                                    throw throwable2;
                                }
                                this.event = null;
                            }
                        }
                        if (retry) {
                            this.queue.addAll(0, (Collection<Message>)Arrays.asList(pendingMessages));
                        }
                    }
                    throw throwable;
                }
                GraniteContext.release();
                TomcatChannel tomcatChannel4 = this;
                synchronized (tomcatChannel4) {
                    block68: {
                        this.state = State.IDLE;
                        try {
                            event.close();
                        }
                        catch (Exception e6) {
                            log.error((Throwable)e6, "Error while closing event: %s", new Object[]{event});
                        }
                        if (this.event != null) {
                            if (!EventUtil.isTimeout(this.event)) {
                                log.error("Unexpected event when closing response: %s", new Object[]{EventUtil.toString(this.event)});
                            }
                            try {
                                try {
                                    this.event.close();
                                }
                                catch (IOException e7) {
                                    log.error((Throwable)e7, "Error while closing event: %s", new Object[]{EventUtil.toString(this.event)});
                                    this.event = null;
                                    break block68;
                                }
                            }
                            catch (Throwable throwable) {
                                this.event = null;
                                throw throwable;
                            }
                            this.event = null;
                        }
                    }
                    if (retry) {
                        this.queue.addAll(0, (Collection<Message>)Arrays.asList(pendingMessages));
                    }
                    break block66;
                }
            }
            GraniteContext.release();
            TomcatChannel tomcatChannel5 = this;
            synchronized (tomcatChannel5) {
                block72: {
                    this.state = State.IDLE;
                    try {
                        event.close();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Error while closing event: %s", new Object[]{event});
                    }
                    if (this.event != null) {
                        if (!EventUtil.isTimeout(this.event)) {
                            log.error("Unexpected event when closing response: %s", new Object[]{EventUtil.toString(this.event)});
                        }
                        try {
                            try {
                                this.event.close();
                            }
                            catch (IOException e) {
                                log.error((Throwable)e, "Error while closing event: %s", new Object[]{EventUtil.toString(this.event)});
                                this.event = null;
                                break block72;
                            }
                        }
                        catch (Throwable throwable) {
                            this.event = null;
                            throw throwable;
                        }
                        this.event = null;
                    }
                }
                if (retry) {
                    this.queue.addAll(0, (Collection<Message>)Arrays.asList(pendingMessages));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<< Thread #%d running channel: %s", new Object[]{Thread.currentThread().getId(), this.getClientId()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        QUEUED,
        SENDING;

    }
}

