/*
 * Decompiled with CFR 0.152.
 */
package org.granite.hibernate;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Type;
import org.hibernate.collection.AbstractPersistentCollection;

public abstract class HibernateAbstractPersistentCollection
implements Externalizable,
Serializable {
    private boolean initialized;
    private boolean dirty;

    public HibernateAbstractPersistentCollection() {
    }

    public HibernateAbstractPersistentCollection(boolean initialized, boolean dirty) {
        this.initialized = initialized;
        this.dirty = dirty;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void checkDirtiness(AbstractPersistentCollection collection) {
        if (this.dirty) {
            collection.dirty();
        }
    }

    public abstract Object newInstance(Type var1);

    protected abstract void writeCollectionContent(ObjectOutput var1) throws IOException;

    protected abstract void readCollectionContent(ObjectInput var1) throws IOException, ClassNotFoundException;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.initialized);
        if (this.initialized) {
            out.writeObject(this.dirty);
            this.writeCollectionContent(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialized = (Boolean)in.readObject();
        if (this.initialized) {
            this.dirty = (Boolean)in.readObject();
            this.readCollectionContent(in);
        }
    }
}

