/*
 * Decompiled with CFR 0.152.
 */
package org.granite.hibernate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.hibernate.HibernateAbstractPersistentCollection;
import org.granite.hibernate.HibernatePersistentBag;
import org.granite.hibernate.HibernatePersistentList;
import org.granite.hibernate.HibernatePersistentMap;
import org.granite.hibernate.HibernatePersistentSet;
import org.granite.hibernate.HibernateProxyInstanciator;
import org.granite.hibernate.ProxyFactory;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.granite.util.ClassUtil;
import org.hibernate.collection.PersistentBag;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentList;
import org.hibernate.collection.PersistentMap;
import org.hibernate.collection.PersistentSet;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateExternalizer
extends DefaultExternalizer {
    private static final Logger log = Logger.getLogger(HibernateExternalizer.class);
    private final ConcurrentHashMap<String, ProxyFactory> proxyFactories = new ConcurrentHashMap();

    public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class clazz = ClassUtil.forName((String)type);
        if (!this.isRegularEntity(clazz)) {
            return super.newInstance(type, in);
        }
        String laziness = (String)in.readObject();
        if (laziness == null) {
            return super.newInstance(type, in);
        }
        return new HibernateProxyInstanciator(this.proxyFactories, laziness);
    }

    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        if (o instanceof HibernateProxyInstanciator) {
            log.debug("Reading Hibernate Proxy...", new Object[0]);
            ((HibernateProxyInstanciator)((Object)o)).readId(in);
        } else if (!this.isRegularEntity(o.getClass())) {
            log.debug("Delegating non regular entity reading to DefaultExternalizer...", new Object[0]);
            super.readExternal(o, in);
        } else {
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            Converters converters = config.getConverters();
            ClassGetter classGetter = config.getClassGetter();
            Class oClass = classGetter.getClass(o);
            List fields = this.findOrderedFields(oClass);
            log.debug("Reading entity %s with fields %s", new Object[]{oClass.getName(), fields});
            for (Property field : fields) {
                if (field instanceof MethodProperty && field.isAnnotationPresent(ExternalizedProperty.class)) continue;
                Object value = in.readObject();
                if (value instanceof HibernateAbstractPersistentCollection) {
                    value = ((HibernateAbstractPersistentCollection)value).newInstance(field.getType());
                } else if (!(value instanceof HibernateProxy)) {
                    value = converters.convert(value, field.getType());
                }
                field.setProperty(o, value, false);
            }
        }
    }

    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        Class oClass = classGetter.getClass(o);
        if (o instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)o;
            if (proxy.getHibernateLazyInitializer().isUninitialized()) {
                String description = this.getProxyDescription(proxy);
                Serializable id = proxy.getHibernateLazyInitializer().getIdentifier();
                log.debug("Writing uninitialized HibernateProxy %s with id %s", new Object[]{description, id});
                out.writeObject(description);
                out.writeObject(id);
                return;
            }
            log.debug("Writing initialized HibernateProxy...", new Object[0]);
            o = proxy.getHibernateLazyInitializer().getImplementation();
        }
        if (!this.isRegularEntity(o.getClass())) {
            log.debug("Delegating non regular entity writing to DefaultExternalizer...", new Object[0]);
            super.writeExternal(o, out);
        } else {
            out.writeObject(null);
            List fields = this.findOrderedFields(oClass);
            log.debug("Writing entity %s with fields %s", new Object[]{o.getClass().getName(), fields});
            for (Property field : fields) {
                Object value = field.getProperty(o);
                if (value instanceof PersistentCollection) {
                    if (value instanceof PersistentSet) {
                        value = new HibernatePersistentSet((PersistentSet)value);
                    } else if (value instanceof PersistentList) {
                        value = new HibernatePersistentList((PersistentList)value);
                    } else if (value instanceof PersistentMap) {
                        value = new HibernatePersistentMap((PersistentMap)value);
                    } else if (value instanceof PersistentBag) {
                        value = new HibernatePersistentBag((PersistentBag)value);
                    } else {
                        throw new UnsupportedOperationException("Unsupported collection type: " + value);
                    }
                }
                out.writeObject(value);
            }
        }
    }

    public int accept(Class<?> clazz) {
        return clazz.isAnnotationPresent(Entity.class) || clazz.isAnnotationPresent(MappedSuperclass.class) || clazz.isAnnotationPresent(Embeddable.class) ? 1 : -1;
    }

    protected String getProxyDescription(HibernateProxy proxy) {
        LazyInitializer initializer = proxy.getHibernateLazyInitializer();
        StringBuilder sb = new StringBuilder();
        sb.append(initializer.getClass().getName()).append(':');
        if (initializer.getPersistentClass() != null) {
            sb.append(initializer.getPersistentClass().getName());
        }
        sb.append(':');
        if (initializer.getEntityName() != null) {
            sb.append(initializer.getEntityName());
        }
        return sb.toString();
    }

    protected boolean isRegularEntity(Class<?> clazz) {
        return clazz.isAnnotationPresent(Entity.class) || clazz.isAnnotationPresent(MappedSuperclass.class);
    }
}

