/*
 * Decompiled with CFR 0.152.
 */
package org.granite.hibernate;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.util.ClassUtil;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.AbstractComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory {
    private static final Class<?>[] INTERFACES = new Class[]{HibernateProxy.class};
    private final ConcurrentHashMap<Class<?>, Type> identifierTypes = new ConcurrentHashMap();
    private final Method getProxyFactory;
    private final Method getProxy;

    public ProxyFactory(String initializerClassName) {
        try {
            Class initializerClass = ClassUtil.forName((String)initializerClassName);
            this.getProxyFactory = initializerClass.getMethod("getProxyFactory", Class.class, Class[].class);
            this.getProxy = initializerClass.getMethod("getProxy", Class.class, String.class, Class.class, Class[].class, Method.class, Method.class, AbstractComponentType.class, Serializable.class, SessionImplementor.class);
        }
        catch (Exception e) {
            throw new ServiceException("Could not introspect initializer class: " + initializerClassName, (Throwable)e);
        }
    }

    public HibernateProxy getProxyInstance(String persistentClassName, String entityName, Serializable id) {
        try {
            Class persistentClass = ClassUtil.forName((String)persistentClassName);
            Class factory = (Class)this.getProxyFactory.invoke(null, persistentClass, INTERFACES);
            Type identifierType = this.getIdentifierType(persistentClass);
            if (id == null || !identifierType.equals(id.getClass())) {
                GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
                id = (Serializable)config.getConverters().convert((Object)id, identifierType);
            }
            Object[] objectArray = new Object[9];
            objectArray[0] = factory;
            objectArray[1] = entityName;
            objectArray[2] = persistentClass;
            objectArray[3] = INTERFACES;
            objectArray[7] = id;
            return (HibernateProxy)this.getProxy.invoke(null, objectArray);
        }
        catch (Exception e) {
            throw new ServiceException("Error with proxy description: " + persistentClassName + '/' + entityName + " and id: " + id, (Throwable)e);
        }
    }

    private Type getIdentifierType(Class<?> persistentClass) {
        int n;
        int n2;
        Object[] objectArray;
        Type type = this.identifierTypes.get(persistentClass);
        if (type != null) {
            return type;
        }
        Class<?> clazz = persistentClass;
        while (clazz != Object.class && clazz != null) {
            objectArray = clazz.getDeclaredFields();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Field field = objectArray[n];
                if (field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class)) {
                    type = field.getGenericType();
                    break;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        if (type == null) {
            PropertyDescriptor[] propertyDescriptors = null;
            try {
                BeanInfo info = Introspector.getBeanInfo(persistentClass);
                propertyDescriptors = info.getPropertyDescriptors();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not find id in: " + persistentClass, e);
            }
            objectArray = propertyDescriptors;
            n2 = propertyDescriptors.length;
            n = 0;
            while (n < n2) {
                Object propertyDescriptor = objectArray[n];
                Method method = ((PropertyDescriptor)propertyDescriptor).getReadMethod();
                if (method != null && (method.isAnnotationPresent(Id.class) || method.isAnnotationPresent(EmbeddedId.class))) {
                    type = method.getGenericReturnType();
                    break;
                }
                method = ((PropertyDescriptor)propertyDescriptor).getWriteMethod();
                if (method != null && (method.isAnnotationPresent(Id.class) || method.isAnnotationPresent(EmbeddedId.class))) {
                    type = method.getGenericParameterTypes()[0];
                    break;
                }
                ++n;
            }
        }
        if (type != null) {
            Type previousType = this.identifierTypes.putIfAbsent(persistentClass, type);
            if (previousType != null) {
                type = previousType;
            }
            return type;
        }
        throw new IllegalArgumentException("Could not find id in: " + persistentClass);
    }
}

