/*
 * Decompiled with CFR 0.152.
 */
package org.granite.hibernate;

import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.DefaultClassGetter;
import org.granite.util.ClassUtil;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateClassGetter
extends DefaultClassGetter {
    public static final Logger log = Logger.getLogger(HibernateClassGetter.class);

    public Class<?> getClass(Object o) {
        if (o instanceof HibernateProxy) {
            String className;
            HibernateProxy proxy = (HibernateProxy)o;
            LazyInitializer initializer = proxy.getHibernateLazyInitializer();
            String string = className = initializer.isUninitialized() ? initializer.getEntityName() : initializer.getImplementation().getClass().getName();
            if (className != null && className.length() > 0) {
                try {
                    return ClassUtil.forName((String)className);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Could not get class with initializer: %s for: %s", new Object[]{initializer.getClass().getName(), className});
                }
            }
            return initializer.getPersistentClass();
        }
        return super.getClass(o);
    }

    public boolean isInitialized(Object o) {
        return Hibernate.isInitialized((Object)o);
    }

    public void initialize(Object o) {
        Hibernate.initialize((Object)o);
    }
}

