/*
 * Decompiled with CFR 0.152.
 */
package org.granite.hibernate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.granite.hibernate.HibernateAbstractPersistentCollection;
import org.granite.util.ClassUtil;
import org.hibernate.Hibernate;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentSet;
import org.hibernate.collection.PersistentSortedSet;

public class HibernatePersistentSet
extends HibernateAbstractPersistentCollection {
    private static final long serialVersionUID = 1L;
    private Object[] content;

    public HibernatePersistentSet() {
    }

    public HibernatePersistentSet(PersistentSet value) {
        super(Hibernate.isInitialized((Object)value), value.isDirty());
        if (this.isInitialized()) {
            this.content = value.toArray();
        }
    }

    public Object newInstance(Type target) {
        PersistentSortedSet instance = null;
        boolean sorted = SortedSet.class.isAssignableFrom(ClassUtil.classOfType((Type)target));
        if (this.isInitialized()) {
            if (this.content != null) {
                AbstractSet set = sorted ? new TreeSet() : new HashSet(this.content.length);
                Object[] objectArray = this.content;
                int n = this.content.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    set.add(o);
                    ++n2;
                }
                instance = sorted ? new PersistentSortedSet(null, (SortedSet)((Object)set)) : new PersistentSet(null, set);
                this.checkDirtiness((AbstractPersistentCollection)instance);
            }
        } else {
            instance = sorted ? new PersistentSortedSet() : new PersistentSet();
        }
        return instance;
    }

    protected void writeCollectionContent(ObjectOutput out) throws IOException {
        out.writeObject(this.content);
    }

    protected void readCollectionContent(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o != null) {
            this.content = o instanceof Collection ? ((Collection)o).toArray() : (o.getClass().isArray() ? (Object[])o : new Object[]{o});
        }
    }
}

