/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.hibernate;

import java.util.HashMap;
import java.util.Map;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceException;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateExceptionConverter
implements ExceptionConverter {
    public static final String ENTITY_EXISTS = "Persistence.EntityExists";
    public static final String ENTITY_NOT_FOUND = "Persistence.EntityNotFound";
    public static final String NON_UNIQUE_RESULT = "Persistence.NonUnique";
    public static final String NO_RESULT = "Persistence.NoResult";
    public static final String OPTIMISTIC_LOCK = "Persistence.OptimisticLock";
    public static final String TRANSACTION_REQUIRED = "Persistence.TransactionRequired";
    public static final String ROLLBACK = "Persistence.Rollback";
    public static final String OTHER = "Persistence.Error";

    public boolean accepts(Throwable t) {
        return t.getClass().equals(NonUniqueObjectException.class) || t.getClass().equals(ObjectNotFoundException.class) || t.getClass().equals(NonUniqueResultException.class) || StaleStateException.class.isAssignableFrom(t.getClass()) || HibernateException.class.isAssignableFrom(t.getClass());
    }

    public ServiceException convert(Throwable t, String detail, Map<String, Object> extendedData) {
        String error = null;
        HashMap<String, Object> ex = null;
        if (t.getClass().equals(NonUniqueObjectException.class)) {
            error = ENTITY_EXISTS;
        } else if (t.getClass().equals(ObjectNotFoundException.class)) {
            error = ENTITY_NOT_FOUND;
        } else if (t.getClass().equals(NonUniqueResultException.class)) {
            error = NON_UNIQUE_RESULT;
        } else if (t.getClass().equals(StaleStateException.class)) {
            error = OPTIMISTIC_LOCK;
            if (t instanceof StaleObjectStateException) {
                ex = new HashMap<String, Object>();
                ex.put("entityName", ((StaleObjectStateException)t).getEntityName());
                ex.put("identifier", ((StaleObjectStateException)t).getIdentifier());
            }
        } else {
            error = OTHER;
        }
        ServiceException se = new ServiceException(error, t.getMessage(), detail, t);
        if (ex != null && !ex.isEmpty()) {
            se.getExtendedData().putAll(ex);
        }
        return se;
    }
}

