/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.hibernate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.context.GraniteContext;
import org.granite.tide.validators.EntityValidator;
import org.granite.tide.validators.InvalidValue;
import org.hibernate.validator.ClassValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateValidator
implements EntityValidator {
    private static final String KEY = String.valueOf(HibernateValidator.class.getName()) + ".validators";

    public HibernateValidator() {
        GraniteContext gc = GraniteContext.getCurrentInstance();
        ConcurrentHashMap validators = new ConcurrentHashMap(20);
        gc.getApplicationMap().put(KEY, validators);
    }

    public InvalidValue[] getPotentialInvalidValues(Class<?> entityClass, String propertyName, Object value) {
        GraniteContext gc = GraniteContext.getCurrentInstance();
        Map validators = (Map)gc.getApplicationMap().get(KEY);
        ClassValidator validator = (ClassValidator)validators.get(entityClass);
        if (validator == null) {
            validator = new ClassValidator(entityClass);
            validators.put(entityClass, validator);
        }
        org.hibernate.validator.InvalidValue[] invalidValues = validator.getPotentialInvalidValues(propertyName, value);
        return HibernateValidator.convertInvalidValues(invalidValues);
    }

    public static InvalidValue[] convertInvalidValues(org.hibernate.validator.InvalidValue[] values) {
        InvalidValue[] converted = new InvalidValue[values.length];
        int i = 0;
        while (i < values.length) {
            org.hibernate.validator.InvalidValue value = values[i];
            converted[i] = value.getBean() == null ? new InvalidValue(value.getBeanClass(), value.getPropertyPath(), value.getValue(), value.getMessage()) : new InvalidValue(value.getRootBean() != null ? value.getRootBean() : value.getBean(), value.getPropertyPath(), value.getValue(), value.getMessage());
            ++i;
        }
        return converted;
    }
}

