/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.hibernate;

import java.util.Map;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceException;
import org.granite.tide.hibernate.HibernateValidator;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateValidatorExceptionConverter
implements ExceptionConverter {
    public static final String VALIDATION_FAILED = "Validation.Failed";

    public boolean accepts(Throwable t) {
        return t.getClass().equals(InvalidStateException.class);
    }

    public ServiceException convert(Throwable t, String detail, Map<String, Object> extendedData) {
        InvalidValue[] invalidValues = ((InvalidStateException)t).getInvalidValues();
        extendedData.put("invalidValues", HibernateValidator.convertInvalidValues(invalidValues));
        ServiceException se = new ServiceException(VALIDATION_FAILED, t.getMessage(), detail, t);
        se.getExtendedData().putAll(extendedData);
        return se;
    }
}

