/*
 * Decompiled with CFR 0.152.
 */
package org.granite.seam21;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.HttpServletRequestParamWrapper;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;

public class Seam21Interceptor
implements AMF3MessageInterceptor {
    private static final Logger log = Logger.getLogger(Seam21Interceptor.class);
    private static final String CONVERSATION_ID = "conversationId";
    private static final String PARENT_CONVERSATION_ID = "parentConversationId";
    private static final String IS_LONG_RUNNING_CONVERSATION = "isLongRunningConversation";
    private static final String MESSAGE_HAEDER = "MESSAGE_HEADER";
    private static final String MSG_SEP = ":;:";

    public void before(Message amfReqMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Pre processing of request message: %s", new Object[]{amfReqMessage});
        }
        try {
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (context instanceof HttpGraniteContext) {
                log.debug("Creating custom HttpServletRequest wrapper", new Object[0]);
                HttpServletRequestParamWrapper request = new HttpServletRequestParamWrapper(((HttpGraniteContext)context).getRequest());
                this.exportHeaders(request, amfReqMessage);
                this.initializeSeamContext((HttpServletRequest)request);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while pre processing the request message.", new Object[0]);
            throw new ServiceException("Error while pre processing the request message - " + e.getMessage());
        }
    }

    public void after(Message amfReqMessage, Message amfRespMessage) {
        block6: {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Post processing of response message: %s", new Object[]{amfReqMessage});
                }
                if (!(GraniteContext.getCurrentInstance() instanceof HttpGraniteContext)) break block6;
                try {
                    this.importHeaders(amfRespMessage);
                }
                finally {
                    this.destroySeamContext();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while post processing the response message.", new Object[0]);
                throw new ServiceException("Error while post processing the response message - " + e.getMessage());
            }
        }
    }

    protected void exportHeaders(HttpServletRequestParamWrapper request, Message amf3RequestMessage) {
        Map headerMap = amf3RequestMessage.getHeaders();
        if (headerMap != null && headerMap.size() > 0) {
            for (String key : headerMap.keySet()) {
                String value;
                String string = value = headerMap.get(key) == null ? null : headerMap.get(key).toString();
                if (value == null) continue;
                request.setParameter(key, value);
            }
        }
    }

    protected void importHeaders(Message amf3ResponseMessage) {
        if (amf3ResponseMessage != null) {
            Conversation conversation = Conversation.instance();
            log.debug("CONVERSATION_ID: %s", new Object[]{conversation.getId()});
            amf3ResponseMessage.setHeader(CONVERSATION_ID, (Object)conversation.getId());
            log.debug("PARENT_CONVERSATION_ID: %s", new Object[]{conversation.getParentId()});
            amf3ResponseMessage.setHeader(PARENT_CONVERSATION_ID, (Object)conversation.getParentId());
            log.debug("IS_LONG_RUNNING_CONVERSATION: %s", new Object[]{conversation.isLongRunning()});
            amf3ResponseMessage.setHeader(IS_LONG_RUNNING_CONVERSATION, (Object)conversation.isLongRunning());
            log.debug("Processing the Status messages.", new Object[0]);
            this.processStatusMessages(amf3ResponseMessage);
        }
    }

    protected void initializeSeamContext(HttpServletRequest request) {
        log.debug("beginning request", new Object[0]);
        ServletLifecycle.beginRequest((HttpServletRequest)request);
        ServletContexts.instance().setRequest(request);
        this.restoreConversationId();
        String conversationId = ConversationPropagation.instance().getConversationId();
        Manager.instance().restoreConversation();
        ServletLifecycle.resumeConversation((HttpServletRequest)request);
        this.handleConversationPropagation();
        if (conversationId != null && !conversationId.equals(Manager.instance().getCurrentConversationId())) {
            Manager.instance().updateCurrentConversationId(conversationId);
        }
        if (request.getSession(false) == null) {
            request.getSession(true);
        }
    }

    private void destroySeamContext() {
        Manager.instance().endRequest((Map)new ServletRequestSessionMap(ServletContexts.getInstance().getRequest()));
        ServletLifecycle.endRequest((HttpServletRequest)ServletContexts.getInstance().getRequest());
        log.debug("ended request", new Object[0]);
    }

    protected void processStatusMessages(Message amf3ResponseMessage) {
        if (amf3ResponseMessage != null) {
            StatusMessages statusMessages = StatusMessages.instance();
            if (statusMessages == null) {
                return;
            }
            try {
                Method m = StatusMessages.class.getDeclaredMethod("doRunTasks", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)statusMessages, new Object[0]);
                Method m2 = StatusMessages.class.getDeclaredMethod("getMessages", new Class[0]);
                m2.setAccessible(true);
                List messages = (List)m2.invoke((Object)statusMessages, new Object[0]);
                log.debug("Found Messages: %b", new Object[]{!messages.isEmpty()});
                StringBuilder messagesBuf = new StringBuilder();
                for (StatusMessage msg : messages) {
                    log.debug("StatusMessage %s - %s", new Object[]{msg.getDetail(), msg.getSummary()});
                    messagesBuf.append(msg.getSummary());
                    messagesBuf.append(MSG_SEP);
                }
                String messageStr = messagesBuf.toString().trim();
                if (messageStr.length() > 0) {
                    messageStr = messageStr.substring(0, messageStr.lastIndexOf(MSG_SEP));
                    amf3ResponseMessage.setHeader(MESSAGE_HAEDER, (Object)messageStr);
                }
            }
            catch (Exception e) {
                log.error("Could not get status messages", new Object[]{e});
            }
        }
    }

    protected void handleConversationPropagation() {
        Manager.instance().handleConversationPropagation(ServletContexts.getInstance().getRequest().getParameterMap());
    }

    protected void restoreConversationId() {
        ConversationPropagation.instance().restoreConversationId(ServletContexts.getInstance().getRequest().getParameterMap());
    }
}

