/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.TideMessage;
import org.granite.tide.TideServiceContext;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.seam.ContextEvent;
import org.granite.tide.seam.ContextResult;
import org.granite.tide.seam.ContextUpdate;
import org.granite.tide.seam.InvocationCall;
import org.granite.tide.seam.InvocationResult;
import org.granite.tide.seam.ScopedContextResult;
import org.granite.tide.seam.TideDataModel;
import org.granite.tide.seam.TideInvocation;
import org.granite.tide.seam.TideUserEvents;
import org.granite.tide.seam.UserEvents;
import org.granite.tide.seam.async.AsyncContext;
import org.granite.tide.seam.lazy.SeamInitializer;
import org.granite.tide.util.Reflections;
import org.jboss.seam.Component;
import org.jboss.seam.Namespace;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSeamServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    public static final String COMPONENT_NAME = "org.granite.tide.seam.serviceContext";
    @Logger
    protected Log log;
    private UserEvents userEvents;
    private boolean isAsynchronousContext = true;
    private Map<ContextResult, Boolean> resultsEval = new ConcurrentHashMap<ContextResult, Boolean>();

    public void initCall() {
        super.initCall();
        if (this.userEvents != null) {
            return;
        }
        if (this.getSessionId() != null) {
            this.userEvents = TideUserEvents.instance().getUserEvents(this.getSessionId());
        } else {
            GraniteContext graniteContext = GraniteContext.getCurrentInstance();
            if (graniteContext instanceof HttpGraniteContext) {
                HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
                if (session != null) {
                    this.setSessionId(session.getId());
                }
                this.isAsynchronousContext = false;
            }
        }
    }

    public void setSessionId(String sessionId) {
        super.setSessionId(sessionId);
        this.userEvents = TideUserEvents.instance().getUserEvents(sessionId);
    }

    @Destroy
    public void endSession() {
        if (!this.isAsynchronousContext && this.getSessionId() != null) {
            TideUserEvents.instance().unregisterSession(this.getSessionId());
        }
    }

    public AsyncContext getAsyncContext() {
        return new AsyncContext(this.getSessionId(), new ArrayList<ContextResult>((Collection)this.resultsEval.keySet()));
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        AsyncPublisher asyncPublisher = this.getAsyncPublisher();
        if (asyncPublisher != null) {
            asyncPublisher.initThread();
        }
        Contexts.getSessionContext().set("org.jboss.seam.security.identity", (Object)asyncContext.getIdentity());
        this.setSessionId(asyncContext.getSessionId());
        for (ContextResult resultEval : asyncContext.getResults()) {
            this.resultsEval.put(resultEval, Boolean.FALSE);
        }
    }

    protected abstract List<TideMessage> getTideMessages();

    protected abstract void initTideMessages();

    protected abstract void clearTideMessages();

    public Object findComponent(String componentName) {
        Component component = this.lookupComponent(componentName);
        if (component == null) {
            return null;
        }
        return Component.getInstance((String)component.getName());
    }

    public Class<?> findComponentClass(String componentName) {
        Component component = this.lookupComponent(componentName);
        if (component == null) {
            return null;
        }
        return component.getBeanClass();
    }

    public void raiseEvent(String type, Object ... params) {
        TideInvocation tideInvocation = TideInvocation.get();
        if (tideInvocation == null) {
            return;
        }
        if (this.userEvents != null) {
            String sessionId;
            if (!type.endsWith("org.jboss.seam.international.localeSelector")) {
                this.log.debug((Object)"Intercept event {0}", new Object[]{type});
            }
            if ((sessionId = this.getSessionId()) != null && this.userEvents.hasEventType(type)) {
                tideInvocation.addEvent(new ContextEvent(type, params));
            }
        } else if (Contexts.getSessionContext().isSet("org.granite.seam.login")) {
            tideInvocation.addEvent(new ContextEvent(type, params));
        }
    }

    protected AsyncPublisher getAsyncPublisher() {
        return (AsyncPublisher)Component.getInstance((String)"org.granite.tide.seam.async.publisher");
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName) {
        String sessionId;
        InvocationCall call = (InvocationCall)c;
        List<String> listeners = call.getListeners();
        List<ContextUpdate> updates = call.getUpdates();
        Object[] results = call.getResults();
        if (Contexts.isEventContextActive() && Contexts.isSessionContextActive() && Contexts.getSessionContext().isSet("org.granite.seam.login")) {
            for (Map.Entry<ContextResult, Boolean> me : this.resultsEval.entrySet()) {
                if (me.getKey().getExpression() != null || !Contexts.getSessionContext().isSet(me.getKey().getComponentName())) continue;
                me.setValue(Boolean.TRUE);
            }
            Contexts.getSessionContext().remove("org.granite.seam.login");
        }
        if ((sessionId = this.getSessionId()) != null && listeners != null) {
            for (String listener : listeners) {
                TideUserEvents.instance().registerEventType(sessionId, listener);
            }
            if (this.userEvents == null) {
                this.userEvents = TideUserEvents.instance().getUserEvents(this.getSessionId());
            }
        }
        if (results != null) {
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                ContextResult cr = (ContextResult)result;
                this.resultsEval.put(new ScopedContextResult(cr.getComponentName(), cr.getExpression(), ScopeType.UNSPECIFIED, null), Boolean.TRUE);
                ++n2;
            }
        }
        boolean instrumented = false;
        Component component = null;
        if (componentName != null) {
            component = this.lookupComponent(componentName);
            if (component.isInterceptionEnabled()) {
                instrumented = true;
            }
            for (Map.Entry entry : this.resultsEval.entrySet()) {
                if (!((ContextResult)entry.getKey()).getComponentName().equals(componentName)) continue;
                entry.setValue(Boolean.TRUE);
            }
        }
        this.initTideMessages();
        TideInvocation tideInvocation = TideInvocation.get();
        tideInvocation.update(updates);
        if (!instrumented) {
            this.restoreContext(updates, component, null);
            tideInvocation.updated();
        }
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName) {
        TideInvocation tideInvocation = TideInvocation.get();
        List<ContextUpdate> results = null;
        boolean inConversation = false;
        boolean restrict = false;
        Component component = null;
        if (componentName != null) {
            component = this.lookupComponent(componentName);
            if (Contexts.isMethodContextActive() && Contexts.getMethodContext().isSet(component.getName())) {
                inConversation = true;
            } else if (Contexts.isEventContextActive() && Contexts.getEventContext().isSet(component.getName())) {
                inConversation = true;
            } else if (Contexts.isPageContextActive() && Contexts.getPageContext().isSet(component.getName())) {
                inConversation = true;
            } else if (Contexts.isConversationContextActive() && Contexts.getConversationContext().isSet(component.getName())) {
                inConversation = true;
            }
            restrict = component.beanClassHasAnnotation(Restrict.class);
        }
        results = !tideInvocation.isEvaluated() ? this.evaluateResults(null, null, componentName == null) : tideInvocation.getResults();
        InvocationResult res = new InvocationResult(result, results);
        res.setInConversation(inConversation);
        res.setRestrict(restrict);
        res.setEvents(tideInvocation.getEvents());
        res.setMessages(this.getTideMessages());
        this.clearTideMessages();
        TideInvocation.remove();
        return res;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName) {
        this.clearTideMessages();
        TideInvocation.remove();
    }

    public void addResultEval(ContextResult result) {
        this.resultsEval.put(result, Boolean.TRUE);
    }

    private Component lookupComponent(String componentName) {
        Init init = Init.instance();
        Component component = Component.forName((String)componentName);
        if (component == null) {
            for (Namespace ns : init.getGlobalImports()) {
                try {
                    Method m = ns.getClass().getDeclaredMethod("qualifyName", String.class);
                    m.setAccessible(true);
                    String nsName = (String)org.jboss.seam.util.Reflections.invoke((Method)m, (Object)ns, (Object[])new Object[]{componentName});
                    component = Component.forName((String)nsName);
                    if (component == null) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return component;
    }

    public void restoreContext(List<ContextUpdate> updates, Component component, Object target) {
        if (updates == null) {
            return;
        }
        HashMap cache = new HashMap();
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        for (ContextUpdate update : updates) {
            boolean disabled;
            this.log.debug((Object)"Before invocation: evaluating expression #0.#1", new Object[]{update.getComponentName(), update.getExpression()});
            Component sourceComponent = this.lookupComponent(update.getComponentName());
            String sourceComponentName = sourceComponent != null ? sourceComponent.getName() : update.getComponentName();
            Object previous = null;
            if (update.getExpression() != null) {
                if (target == null && (component == null || !component.getName().equals(sourceComponentName))) continue;
                try {
                    String[] path = update.getExpression().split("\\.");
                    Object instance = component != null && component.getName().equals(sourceComponentName) ? target : Component.getInstance((String)sourceComponentName);
                    boolean bl = disabled = instance != null && sourceComponent != null && config.isComponentTideDisabled(sourceComponentName, sourceComponent.getBeanClass(), instance);
                    if (disabled) continue;
                    Object bean = instance;
                    Object value = instance;
                    if (update.getValue() != null) {
                        org.granite.tide.entity.Entity entity;
                        boolean getPrevious = true;
                        if (update.getValue().getClass().getAnnotation(Entity.class) != null && (entity = new org.granite.tide.entity.Entity(update.getValue())).getIdentifier() == null) {
                            getPrevious = false;
                        }
                        if (getPrevious) {
                            try {
                                int i = 0;
                                while (i < path.length) {
                                    if (value != null) {
                                        Method getter = Reflections.getGetterMethod(value.getClass(), (String)path[i]);
                                        value = org.jboss.seam.util.Reflections.invoke((Method)getter, (Object)value, (Object[])new Object[0]);
                                        if (i < path.length - 1) {
                                            bean = value;
                                        }
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.log.warn((Object)("Partial merge only: " + e.getMessage()), new Object[0]);
                                value = null;
                            }
                            previous = value;
                        }
                    }
                    value = this.mergeExternal(update.getValue(), previous, cache);
                    if (bean == null) continue;
                    Method setter = org.jboss.seam.util.Reflections.getSetterMethod(bean.getClass(), (String)path[path.length - 1]);
                    org.jboss.seam.util.Reflections.invoke((Method)setter, (Object)bean, (Object[])new Object[]{value});
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Impossible to restore expression " + update.toString(), e);
                }
            }
            if (sourceComponent != null) {
                boolean disabled2;
                ScopeType scope = sourceComponent.getScope();
                if ((!update.getInConversation() || scope != ScopeType.EVENT && scope != ScopeType.STATELESS && scope != ScopeType.CONVERSATION && scope != ScopeType.BUSINESS_PROCESS && scope != ScopeType.METHOD && scope != ScopeType.PAGE) && (update.getInConversation() || scope != ScopeType.EVENT && scope != ScopeType.STATELESS && scope != ScopeType.SESSION && scope != ScopeType.METHOD && scope != ScopeType.PAGE)) {
                    scope = ScopeType.EVENT;
                }
                boolean bl = disabled2 = (previous = scope.getContext().get(sourceComponentName)) != null && config.isComponentTideDisabled(sourceComponentName, sourceComponent.getBeanClass(), previous);
                if (disabled2) continue;
                Object value = this.mergeExternal(update.getValue(), previous, cache);
                scope.getContext().set(sourceComponentName, value);
                continue;
            }
            Object[] prev = AbstractSeamServiceContext.lookupInStatefulContexts(sourceComponentName, ScopeType.UNSPECIFIED);
            ScopeType scope = ScopeType.UNSPECIFIED;
            if (prev != null) {
                previous = prev[0];
                scope = (ScopeType)prev[1];
            }
            boolean bl = disabled = previous != null && config.isComponentTideDisabled(sourceComponentName, previous.getClass(), previous);
            if (disabled) continue;
            if (scope == ScopeType.UNSPECIFIED) {
                scope = ScopeType.EVENT;
                scope.getContext().set(String.valueOf(sourceComponentName) + "_tide_unspecified_", (Object)true);
            }
            Object value = this.mergeExternal(update.getValue(), previous, cache);
            scope.getContext().set(sourceComponentName, value);
        }
    }

    public void addResultEvaluation(String componentName) {
        this.log.debug((Object)"Add evaluation for component #0", new Object[]{componentName});
        for (Map.Entry<ContextResult, Boolean> me : this.resultsEval.entrySet()) {
            if (!me.getKey().getComponentName().equals(componentName)) continue;
            me.setValue(Boolean.TRUE);
        }
    }

    public List<ContextUpdate> evaluateResults(Component component, Object target, boolean nothing) {
        ArrayList<ContextUpdate> resultsMap = new ArrayList<ContextUpdate>();
        if (nothing) {
            return resultsMap;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        SeamInitializer.instance();
        for (Map.Entry<ContextResult, Boolean> me : this.resultsEval.entrySet()) {
            String targetComponentName;
            if (!me.getValue().booleanValue()) continue;
            ContextResult res = me.getKey();
            Component targetComponent = this.lookupComponent(res.getComponentName());
            String string = targetComponentName = targetComponent != null ? targetComponent.getName() : res.getComponentName();
            if (res.getExpression() != null && component != null && targetComponent != null && !component.getName().equals(targetComponentName)) continue;
            int idx = 0;
            boolean add = true;
            while (idx >= 0) {
                String ex;
                idx = res.getExpression() != null ? res.getExpression().indexOf(".", idx + 1) : -1;
                String expr = idx > 0 ? res.getExpression().substring(0, idx) : res.getExpression();
                String string2 = ex = expr != null ? String.valueOf(res.getComponentName()) + "." + expr : res.getComponentName();
                if (exprs.contains(ex)) continue;
                this.log.debug((Object)"After invocation: evaluating expression #0", new Object[]{ex});
                String[] path = expr != null ? expr.split("\\.") : new String[]{};
                try {
                    Object value = null;
                    ScopeType scopeType = res.getScope();
                    Boolean restrict = res.getRestrict();
                    if (res.getExpression() == null) {
                        if (targetComponent != null) {
                            if (ScopeType.UNSPECIFIED.equals((Object)scopeType)) {
                                value = Component.getInstance((String)targetComponent.getName());
                                scopeType = targetComponent.getScope();
                                if (ScopeType.STATELESS.equals((Object)scopeType)) {
                                    scopeType = ScopeType.EVENT;
                                }
                                if (value != null && config.isComponentTideDisabled(targetComponentName, targetComponent.getBeanClass(), value)) {
                                    add = false;
                                }
                            } else {
                                value = Component.getInstance((String)targetComponent.getName(), (ScopeType)scopeType);
                                if (value != null && config.isComponentTideDisabled(targetComponentName, value.getClass(), value)) {
                                    add = false;
                                }
                            }
                            restrict = targetComponent.beanClassHasAnnotation(Restrict.class);
                        } else {
                            Object[] val = AbstractSeamServiceContext.lookupInStatefulContexts(res.getComponentName(), scopeType);
                            if (val != null) {
                                value = val[0];
                                scopeType = (ScopeType)val[1];
                                if (value != null && config.isComponentTideDisabled(res.getComponentName(), value.getClass(), value)) {
                                    add = false;
                                }
                            }
                        }
                    } else if (expr != null && targetComponent != null) {
                        if (component != null && component.getName().equals(targetComponent.getName())) {
                            value = target;
                            scopeType = targetComponent.getScope();
                        } else if (ScopeType.UNSPECIFIED.equals((Object)scopeType)) {
                            value = Component.getInstance((String)targetComponent.getName());
                            scopeType = targetComponent.getScope();
                        } else {
                            value = Component.getInstance((String)targetComponent.getName(), (ScopeType)scopeType);
                        }
                        if (value != null && config.isComponentTideDisabled(targetComponent.getName(), targetComponent.getBeanClass(), value)) {
                            add = false;
                        }
                        if (add) {
                            int i = 0;
                            while (i < path.length) {
                                if (value == null) break;
                                Method getter = Reflections.getGetterMethod(value.getClass(), (String)path[i]);
                                value = org.jboss.seam.util.Reflections.invoke((Method)getter, (Object)value, (Object[])new Object[0]);
                                ++i;
                            }
                            restrict = targetComponent.beanClassHasAnnotation(Restrict.class);
                        }
                    }
                    if (add) {
                        if (value instanceof TideDataModel) {
                            value = ((TideDataModel)((Object)value)).getWrappedData();
                        } else if (value != null && classGetter != null) {
                            classGetter.initialize(value);
                            if (res.getExpression() != null) {
                                String[] fullPath = res.getExpression().split("\\.");
                                Object v = value;
                                int i = path.length;
                                while (i < fullPath.length) {
                                    Method getter = Reflections.getGetterMethod(v.getClass(), (String)fullPath[i]);
                                    if ((v = org.jboss.seam.util.Reflections.invoke((Method)getter, (Object)v, (Object[])new Object[0])) == null) break;
                                    classGetter.initialize(v);
                                    ++i;
                                }
                            }
                        }
                        boolean inConversation = scopeType == ScopeType.CONVERSATION;
                        resultsMap.add(new ContextUpdate(res.getComponentName(), expr, value, inConversation, Boolean.TRUE.equals(restrict)));
                        add = false;
                    }
                    exprs.add(ex);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not evaluate result expression: " + ex, e);
                }
            }
            me.setValue(Boolean.FALSE);
        }
        return resultsMap;
    }

    public Object invokeAsynchronous(AsyncContext asyncContext, String targetComponentName, String methodName, Class<?>[] paramTypes, Object[] params) {
        Method method;
        this.setAsyncContext(asyncContext);
        Contexts.getEventContext().remove("org.jboss.seam.async.AsynchronousIntercepter.REENTRANT");
        for (Map.Entry<ContextResult, Boolean> me : this.resultsEval.entrySet()) {
            if (!me.getKey().getComponentName().equals(targetComponentName)) continue;
            me.setValue(Boolean.TRUE);
        }
        Object target = Component.getInstance((String)targetComponentName);
        try {
            method = target.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
        Object result = org.jboss.seam.util.Reflections.invokeAndWrap((Method)method, (Object)target, (Object[])params);
        this.sendEvent(targetComponentName);
        return result;
    }

    protected ITidePersistenceManager getTidePersistenceManager(boolean create) {
        return SeamInitializer.instance().getTidePersistenceManager();
    }

    public static Object[] lookupInStatefulContexts(String name, ScopeType scope) {
        Object[] objectArray;
        Object result;
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.METHOD.equals((Object)scope)) && Contexts.isMethodContextActive() && (result = Contexts.getMethodContext().get(name)) != null) {
            return new Object[]{result, Contexts.getMethodContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.EVENT.equals((Object)scope)) && Contexts.isEventContextActive() && (result = Contexts.getEventContext().get(name)) != null) {
            return new Object[]{result, Contexts.getEventContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.PAGE.equals((Object)scope)) && Contexts.isPageContextActive() && (result = Contexts.getPageContext().get(name)) != null) {
            return new Object[]{result, Contexts.getPageContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.CONVERSATION.equals((Object)scope)) && Contexts.isConversationContextActive() && (result = Contexts.getConversationContext().get(name)) != null) {
            return new Object[]{result, Contexts.getConversationContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.SESSION.equals((Object)scope)) && Contexts.isSessionContextActive() && (result = Contexts.getSessionContext().get(name)) != null) {
            return new Object[]{result, Contexts.getSessionContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.BUSINESS_PROCESS.equals((Object)scope)) && Contexts.isBusinessProcessContextActive() && (result = Contexts.getBusinessProcessContext().get(name)) != null) {
            return new Object[]{result, Contexts.getBusinessProcessContext().getType()};
        }
        if ((ScopeType.UNSPECIFIED.equals((Object)scope) || ScopeType.APPLICATION.equals((Object)scope)) && Contexts.isApplicationContextActive() && (result = Contexts.getApplicationContext().get(name)) != null) {
            return new Object[]{result, Contexts.getApplicationContext().getType()};
        }
        if (ScopeType.UNSPECIFIED.equals((Object)scope)) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[1] = scope;
        }
        return objectArray;
    }
}

