/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import flex.messaging.messages.Message;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.granite.config.flex.Destination;
import org.granite.messaging.service.ExtendedServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.tide.TideMessage;
import org.jboss.seam.faces.FacesMessages;

public class SeamServiceExceptionHandler
extends ExtendedServiceExceptionHandler {
    private static final long serialVersionUID = -1L;

    public SeamServiceExceptionHandler() {
        super(true);
    }

    public SeamServiceExceptionHandler(boolean logException) {
        super(logException);
    }

    protected ServiceException getServiceException(Message request, Destination destination, String method, Throwable t) {
        ServiceException se = super.getServiceException(request, destination, method, t);
        FacesMessages.afterPhase();
        FacesMessages.instance().beforeRenderResponse();
        List facesMessages = FacesMessages.instance().getCurrentMessages();
        ArrayList<TideMessage> tideMessages = new ArrayList<TideMessage>(facesMessages.size());
        for (FacesMessage fm : facesMessages) {
            String severity = null;
            if (fm.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severity = "INFO";
            } else if (fm.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severity = "WARNING";
            } else if (fm.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severity = "ERROR";
            } else if (fm.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severity = "FATAL";
            }
            tideMessages.add(new TideMessage(severity, fm.getSummary(), fm.getDetail()));
        }
        se.getExtendedData().put("messages", tideMessages);
        return se;
    }
}

