/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.lang.reflect.Method;
import java.util.List;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.seam.TideInterceptor;
import org.granite.tide.seam.async.TideAsynchronousInterceptor;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.async.AsynchronousInterceptor;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.intercept.Interceptor;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.granite.tide.seam.init")
@Install(precedence=10)
@Startup
@BypassInterceptors
public class TideInit {
    public TideInit() {
        Context context = Contexts.getApplicationContext();
        String[] stringArray = context.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component;
            Object object;
            String name = stringArray[n2];
            if (name.endsWith(".component") && (object = context.get(name)) instanceof Component && (component = (Component)object).isInterceptionEnabled() && component.getScope() != ScopeType.APPLICATION) {
                this.instrumentComponent(component);
            }
            ++n2;
        }
    }

    private void instrumentComponent(Component component) {
        AsyncPublisher asyncPublisher;
        List li = component.getInterceptors(InterceptorType.ANY);
        boolean newSortServer = false;
        boolean newSortClient = false;
        boolean found = false;
        for (Interceptor i : li) {
            if (!i.getUserInterceptorClass().equals(TideInterceptor.class)) continue;
            found = true;
            break;
        }
        if (!found) {
            component.addInterceptor(new Interceptor((Object)new TideInterceptor(), component));
            newSortServer = true;
        }
        if ((asyncPublisher = (AsyncPublisher)Component.getInstance((String)"org.granite.tide.seam.async.publisher")) != null) {
            boolean async = false;
            li = component.getClientSideInterceptors();
            for (Interceptor in : li) {
                if (!in.getUserInterceptorClass().equals(AsynchronousInterceptor.class)) continue;
                async = true;
                break;
            }
            if (async) {
                component.addInterceptor(new Interceptor((Object)new TideAsynchronousInterceptor(), component));
                newSortClient = true;
            }
        }
        if (newSortServer || newSortClient) {
            try {
                Method m = component.getClass().getDeclaredMethod("newSort", List.class);
                m.setAccessible(true);
                if (newSortServer) {
                    m.invoke((Object)component, component.getInterceptors(InterceptorType.SERVER));
                }
                if (newSortClient) {
                    m.invoke((Object)component, component.getInterceptors(InterceptorType.CLIENT));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

