/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam;

import java.util.ArrayList;
import java.util.List;
import org.granite.tide.seam.ContextEvent;
import org.granite.tide.seam.ContextUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideInvocation {
    private static ThreadLocal<TideInvocation> invocation = new ThreadLocal<TideInvocation>(){

        @Override
        protected TideInvocation initialValue() {
            return new TideInvocation();
        }
    };
    private boolean locked = false;
    private boolean enabled = false;
    private boolean updated = false;
    private boolean evaluated = false;
    private final List<ContextUpdate> updates = new ArrayList<ContextUpdate>();
    private final List<ContextUpdate> results = new ArrayList<ContextUpdate>();
    private final List<ContextEvent> events = new ArrayList<ContextEvent>();

    public static TideInvocation get() {
        return invocation.get();
    }

    public static void remove() {
        invocation.remove();
    }

    public List<ContextUpdate> getUpdates() {
        return this.updates;
    }

    public List<ContextUpdate> getResults() {
        return this.results;
    }

    public List<ContextEvent> getEvents() {
        return this.events;
    }

    public void update(List<ContextUpdate> updates) {
        this.enabled = true;
        this.updated = false;
        this.updates.clear();
        if (updates != null) {
            this.updates.addAll(updates);
        }
    }

    public void updated() {
        this.updated = true;
        this.updates.clear();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void evaluate() {
        this.evaluated = false;
        this.results.clear();
    }

    public void evaluated(List<ContextUpdate> results) {
        this.evaluated = true;
        this.results.addAll(results);
        this.updated = false;
        this.updates.clear();
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public void addEvent(ContextEvent event) {
        this.events.add(event);
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

