/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam.async;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.granite.tide.seam.AbstractSeamServiceContext;
import org.granite.tide.seam.async.AsyncContext;
import org.granite.tide.seam.async.AsynchronousInvoker;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Duration;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.FinalExpiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.annotations.async.IntervalDuration;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.async.AsynchronousInterceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;

@Interceptor(stateless=true, type=InterceptorType.CLIENT, around={AsynchronousInterceptor.class})
public class TideAsynchronousInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 9194177339867853303L;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        AbstractSeamServiceContext serviceContext;
        boolean scheduleAsync;
        if (invocation.getTarget() instanceof AsynchronousInvoker) {
            return invocation.proceed();
        }
        boolean bl = scheduleAsync = invocation.getMethod().isAnnotationPresent(Asynchronous.class) && (!Contexts.getEventContext().isSet("org.jboss.seam.core.executingAsynchronousCall") || Contexts.getEventContext().isSet("org.jboss.seam.async.AsynchronousIntercepter.REENTRANT"));
        if (scheduleAsync && (serviceContext = (AbstractSeamServiceContext)((Object)Component.getInstance((String)"org.granite.tide.seam.serviceContext", (boolean)false))) != null && serviceContext.getSessionId() != null) {
            Annotation[][] parameterAnnotations = invocation.getMethod().getParameterAnnotations();
            Long duration = null;
            Date expiration = null;
            Date finalExpiration = null;
            Long intervalDuration = null;
            String intervalCron = null;
            int i = 0;
            while (i < parameterAnnotations.length) {
                Annotation[] annotations;
                Annotation[] annotationArray = annotations = parameterAnnotations[i];
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    if (annotation.annotationType().equals(Duration.class)) {
                        duration = (Long)invocation.getParameters()[i];
                    } else if (annotation.annotationType().equals(Expiration.class)) {
                        expiration = (Date)invocation.getParameters()[i];
                    } else if (annotation.annotationType().equals(FinalExpiration.class)) {
                        finalExpiration = (Date)invocation.getParameters()[i];
                    } else if (annotation.annotationType().equals(IntervalDuration.class)) {
                        intervalDuration = (Long)invocation.getParameters()[i];
                    } else if (annotation.annotationType().equals(IntervalCron.class)) {
                        intervalCron = (String)invocation.getParameters()[i];
                    }
                    ++n2;
                }
                ++i;
            }
            String targetComponentName = this.getComponent().getName();
            String methodName = invocation.getMethod().getName();
            Class<?>[] paramTypes = invocation.getMethod().getParameterTypes();
            Object[] params = invocation.getParameters();
            AsynchronousInvoker invoker = (AsynchronousInvoker)Component.getInstance((String)"org.granite.tide.seam.asynchronousInvoker");
            AsyncContext asyncContext = serviceContext.getAsyncContext();
            if (intervalCron != null) {
                return invoker.invokeAsynchronousCron(asyncContext, targetComponentName, methodName, paramTypes, params, duration, expiration, finalExpiration, intervalCron);
            }
            if (finalExpiration != null) {
                return invoker.invokeAsynchronousDuration(asyncContext, targetComponentName, methodName, paramTypes, params, duration, expiration, finalExpiration, intervalDuration);
            }
            return invoker.invokeAsynchronousDuration(asyncContext, targetComponentName, methodName, paramTypes, params, duration, expiration, intervalDuration);
        }
        return invocation.proceed();
    }

    public boolean isInterceptorEnabled() {
        return true;
    }
}

