/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam.lazy;

import java.io.Serializable;
import java.util.HashSet;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.entity.PersistenceContextManager;
import org.hibernate.Session;
import org.jboss.seam.Entity;
import org.jboss.seam.util.Reflections;

public class HibernateContextManager
implements ITidePersistenceManager {
    private Session session = null;

    public HibernateContextManager() {
    }

    public HibernateContextManager(Session session) {
        this.session = session;
    }

    public Object attachEntity(Object entity, String[] propertyNames, boolean merge) {
        Object attachedEntity = null;
        ClassGetter getter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        try {
            attachedEntity = merge ? this.mergeEntity(entity) : entity;
            int i = 0;
            while (i < propertyNames.length) {
                Object initializedObj = Reflections.getGetterMethod(attachedEntity.getClass(), (String)propertyNames[i]).invoke(attachedEntity, new Object[0]);
                getter.initialize(initializedObj);
                ++i;
            }
            if (merge && getter != null) {
                PersistenceContextManager.reinitialize((Object)attachedEntity, (Object)entity, (ClassGetter)getter, new HashSet());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to attach entity and init collection", e);
        }
        this.disconnectSession();
        return attachedEntity;
    }

    public Object findEntity(Object entity) {
        Serializable id = (Serializable)Entity.forClass(entity.getClass()).getIdentifier(entity);
        if (id == null) {
            return null;
        }
        return this.session.get(entity.getClass(), id);
    }

    public Object mergeEntity(Object entity) {
        return this.findEntity(entity);
    }

    protected void disconnectSession() {
        this.session.disconnect();
    }
}

