/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam.lazy;

import java.io.Serializable;
import java.util.HashSet;
import javax.persistence.EntityManager;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.tide.ITidePersistenceManager;
import org.jboss.seam.Entity;
import org.jboss.seam.util.Reflections;

public class PersistenceContextManager
implements ITidePersistenceManager {
    private EntityManager em;

    public PersistenceContextManager() {
    }

    public PersistenceContextManager(EntityManager em) {
        this.em = em;
    }

    public Object attachEntity(Object entity, String[] propertyNames, boolean merge) {
        Object attachedEntity = null;
        ClassGetter getter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        try {
            Object object = attachedEntity = merge ? this.mergeEntity(entity) : entity;
            if (attachedEntity != null) {
                int i = 0;
                while (i < propertyNames.length) {
                    Object initializedObj = Reflections.getGetterMethod(attachedEntity.getClass(), (String)propertyNames[i]).invoke(attachedEntity, new Object[0]);
                    if (getter != null) {
                        getter.initialize(initializedObj);
                    }
                    ++i;
                }
            }
            if (merge && getter != null) {
                org.granite.tide.entity.PersistenceContextManager.reinitialize((Object)attachedEntity, (Object)entity, (ClassGetter)getter, new HashSet());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to attach entity and init collection", e);
        }
        return attachedEntity;
    }

    public Object mergeEntity(Object entity) {
        return this.findEntity(entity);
    }

    public Object findEntity(Object entity) {
        Serializable id = (Serializable)Entity.forClass(entity.getClass()).getIdentifier(entity);
        if (id == null) {
            return null;
        }
        return this.em.find(entity.getClass(), (Object)id);
    }
}

