/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.seam21;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.granite.tide.TideMessage;
import org.granite.tide.seam.AbstractSeamServiceContext;
import org.granite.tide.seam21.TideStatusMessages;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.international.StatusMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.SESSION)
@Name(value="org.granite.tide.seam.serviceContext")
@Install(precedence=11)
@BypassInterceptors
public class Seam21ServiceContext
extends AbstractSeamServiceContext {
    private static final long serialVersionUID = 1L;

    @Override
    protected void initTideMessages() {
        StatusMessages.instance();
    }

    @Override
    protected void clearTideMessages() {
        StatusMessages statusMessages = StatusMessages.instance();
        if (statusMessages instanceof TideStatusMessages) {
            statusMessages.clear();
        }
    }

    @Override
    protected List<TideMessage> getTideMessages() {
        StatusMessages statusMessages = StatusMessages.instance();
        if (statusMessages == null) {
            return Collections.emptyList();
        }
        try {
            Method m = StatusMessages.class.getDeclaredMethod("doRunTasks", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)statusMessages, new Object[0]);
            Method m2 = StatusMessages.class.getDeclaredMethod("getMessages", new Class[0]);
            m2.setAccessible(true);
            List messages = (List)m2.invoke((Object)statusMessages, new Object[0]);
            ArrayList<TideMessage> tideMessages = new ArrayList<TideMessage>(messages.size());
            this.log.debug((Object)"Found Messages: %b", new Object[]{!messages.isEmpty()});
            for (StatusMessage msg : messages) {
                String severity = null;
                if (msg.getSeverity() == StatusMessage.Severity.INFO) {
                    severity = "INFO";
                } else if (msg.getSeverity() == StatusMessage.Severity.WARN) {
                    severity = "WARNING";
                } else if (msg.getSeverity() == StatusMessage.Severity.ERROR) {
                    severity = "ERROR";
                } else if (msg.getSeverity() == StatusMessage.Severity.FATAL) {
                    severity = "FATAL";
                }
                tideMessages.add(new TideMessage(severity, msg.getSummary(), msg.getDetail()));
            }
            return tideMessages;
        }
        catch (Exception e) {
            this.log.error((Object)"Could not get status messages", (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }
}

