/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.entity.PersistenceContextManager;
import org.granite.tide.spring.InvocationResult;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    protected ApplicationContext springContext = null;
    private String entityManagerFactoryBeanName = null;
    private Logger log = Logger.getLogger(SpringServiceContext.class);

    public SpringServiceContext() throws ServiceException {
        this.log.debug("Getting spring context from container", new Object[0]);
        GraniteContext context = GraniteContext.getCurrentInstance();
        ServletContext sc = ((HttpGraniteContext)context).getServletContext();
        this.springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public Object findComponent(String componentName) {
        try {
            Object bean = this.springContext.getBean(componentName);
            return bean;
        }
        catch (NoSuchBeanDefinitionException nexc) {
            String msg = "Spring service named '" + componentName + "' does not exist.";
            ServiceException e = new ServiceException(msg, (Throwable)nexc);
            throw e;
        }
        catch (BeansException bexc) {
            String msg = "Unable to create Spring service named '" + componentName + "'";
            ServiceException e = new ServiceException(msg, (Throwable)bexc);
            throw e;
        }
    }

    public Class<?> findComponentClass(String componentName) {
        try {
            Object bean = this.findComponent(componentName);
            return AopUtils.getTargetClass((Object)bean);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName) {
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName) {
        InvocationResult ires = new InvocationResult(result);
        return ires;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName) {
    }

    public void setEntityManagerFactoryBeanName(String beanName) {
        this.entityManagerFactoryBeanName = beanName;
    }

    protected ITidePersistenceManager getTidePersistenceManager(boolean create) {
        if (!create) {
            return null;
        }
        String beanName = this.entityManagerFactoryBeanName != null ? this.entityManagerFactoryBeanName : "entityManagerFactory";
        EntityManagerFactory factory = (EntityManagerFactory)this.findComponent(beanName);
        EntityManager em = factory.createEntityManager();
        if (em == null) {
            return null;
        }
        return new PersistenceContextManager(em);
    }
}

