/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.parser;

import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.graphper.parser.ParseException;

public class DotSyntaxErrorListener
extends BaseErrorListener {
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (offendingSymbol == null) {
            throw new ParseException("line " + line + ":" + charPositionInLine + " " + msg);
        }
        CommonToken token = (CommonToken)offendingSymbol;
        CharStream inputStream = token.getTokenSource().getInputStream();
        String fullText = inputStream.toString();
        String[] lines = fullText.split("\r?\n");
        String errorLine = line > 0 && line <= lines.length ? lines[line - 1] : "<unknown line>";
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append("line ").append(line).append(":").append(charPositionInLine).append(" ").append(msg).append(System.lineSeparator()).append(errorLine).append(System.lineSeparator());
        for (int i = 0; i < charPositionInLine; ++i) {
            errorBuilder.append(' ');
        }
        errorBuilder.append('^');
        throw new ParseException(errorBuilder.toString());
    }
}

