/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.parser;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.Node;
import org.graphper.api.Subgraph;
import org.graphper.parser.DotTempAttrListener;
import org.graphper.parser.NodeExtractor;
import org.graphper.parser.ParseException;
import org.graphper.parser.ParserUtils;
import org.graphper.parser.PostGraphComponents;
import org.graphper.parser.grammar.DOTParser;

public class GraphvizListener
extends DotTempAttrListener {
    private final Deque<GraphContainer.GraphContainerBuilder> containerStack = new LinkedList<GraphContainer.GraphContainerBuilder>();
    private Map<DOTParser.SubgraphContext, GraphContainer> subGraphMap = null;
    private Graphviz graphviz;
    private final NodeExtractor nodeExtractor;
    private final PostGraphComponents postGraphComponents;

    public GraphvizListener(NodeExtractor nodeExtractor, PostGraphComponents postGraphComponents) {
        Objects.requireNonNull(nodeExtractor);
        this.nodeExtractor = nodeExtractor;
        this.postGraphComponents = postGraphComponents;
    }

    @Override
    protected boolean isFocusStmtType(DOTParser.Attr_stmtContext ctx) {
        return ctx.EDGE() != null;
    }

    @Override
    public void enterGraphs(DOTParser.GraphsContext ctx) {
        Iterator<DOTParser.GraphContext> iterator = ctx.graph().iterator();
        iterator.next();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public void enterGraph(DOTParser.GraphContext ctx) {
        Graphviz.GraphvizBuilder graphvizBuilder;
        if (ctx.GRAPH() != null) {
            graphvizBuilder = Graphviz.graph();
        } else if (ctx.DIGRAPH() != null) {
            graphvizBuilder = Graphviz.digraph();
        } else {
            throw new ParseException("invalid graph");
        }
        if (ctx.id_() != null) {
            graphvizBuilder.id(ctx.id_().getText());
        }
        this.containerStack.push((GraphContainer.GraphContainerBuilder)graphvizBuilder);
    }

    @Override
    public void exitGraph(DOTParser.GraphContext ctx) {
        Graphviz.GraphvizBuilder graphvizBuilder = (Graphviz.GraphvizBuilder)this.containerStack.pop();
        if (this.postGraphComponents != null) {
            this.postGraphComponents.postGraphviz(graphvizBuilder);
        }
        this.graphviz = graphvizBuilder.build();
    }

    @Override
    public void enterStmt(DOTParser.StmtContext ctx) {
        int scount = ctx.id_().size() / 2;
        for (int c = 0; c < scount; ++c) {
            DOTParser.Id_Context left = ctx.id_().get(2 * c);
            DOTParser.Id_Context right = ctx.id_().get(2 * c + 1);
            String key = left.getText();
            String value = right.getText();
            if (this.containerStack.peek() instanceof Subgraph.SubgraphBuilder) {
                Subgraph.SubgraphBuilder sb = (Subgraph.SubgraphBuilder)this.containerStack.peek();
                ParserUtils.subgraphAttribute(key, value, sb);
                continue;
            }
            if (!(this.containerStack.peek() instanceof Cluster.ClusterBuilder)) continue;
            Cluster.ClusterBuilder cb = (Cluster.ClusterBuilder)this.containerStack.pop();
            if (this.containerStack.peek() instanceof Subgraph.SubgraphBuilder) {
                Subgraph.SubgraphBuilder sb = (Subgraph.SubgraphBuilder)this.containerStack.peek();
                ParserUtils.subgraphAttribute(key, value, sb);
            }
            this.containerStack.push((GraphContainer.GraphContainerBuilder)cb);
        }
    }

    @Override
    public void enterAttr_stmt(DOTParser.Attr_stmtContext ctx) {
        super.enterAttr_stmt(ctx);
        if (ctx.GRAPH() != null) {
            if (this.containerStack.peek() instanceof Graphviz.GraphvizBuilder) {
                Graphviz.GraphvizBuilder gb = (Graphviz.GraphvizBuilder)this.containerStack.peek();
                ParserUtils.graphAttributes(ctx.attr_list(), gb);
            } else if (this.containerStack.peek() instanceof Subgraph.SubgraphBuilder) {
                Subgraph.SubgraphBuilder sb = (Subgraph.SubgraphBuilder)this.containerStack.peek();
                ParserUtils.subgraphAttributes(ctx.attr_list(), sb);
            } else if (this.containerStack.peek() instanceof Cluster.ClusterBuilder) {
                Cluster.ClusterBuilder sb = (Cluster.ClusterBuilder)this.containerStack.peek();
                ParserUtils.clusterAttributes(ctx.attr_list(), sb);
            }
        }
    }

    @Override
    public void enterGraph_a_list(DOTParser.Graph_a_listContext ctx) {
        if (this.containerStack.peek() instanceof Graphviz.GraphvizBuilder) {
            Graphviz.GraphvizBuilder gb = (Graphviz.GraphvizBuilder)this.containerStack.peek();
            ParserUtils.graphAttributes(ctx.a_list(), gb);
        } else if (this.containerStack.peek() instanceof Subgraph.SubgraphBuilder) {
            Subgraph.SubgraphBuilder sb = (Subgraph.SubgraphBuilder)this.containerStack.peek();
            ParserUtils.subgraphAttributes(ctx.a_list(), sb);
        } else if (this.containerStack.peek() instanceof Cluster.ClusterBuilder) {
            Cluster.ClusterBuilder sb = (Cluster.ClusterBuilder)this.containerStack.peek();
            ParserUtils.clusterAttributes(ctx.a_list(), sb);
        }
    }

    @Override
    public void exitEdge_stmt(DOTParser.Edge_stmtContext ctx) {
        ParserRuleContext first = ctx.node_id() != null ? ctx.node_id() : ctx.subgraph();
        int edgecount = ctx.edgeRHS().children.size() / 2;
        for (int c = 0; c < edgecount; ++c) {
            ParseTree second = (ParseTree)ctx.edgeRHS().children.get(2 * c + 1);
            this.edge((ParseTree)first, second, ctx.attr_list());
            first = second;
        }
    }

    private void edge(ParseTree first, ParseTree second, DOTParser.Attr_listContext attr_list) {
        if (first instanceof DOTParser.Node_idContext && second instanceof DOTParser.Node_idContext) {
            DOTParser.Node_idContext left = (DOTParser.Node_idContext)first;
            DOTParser.Node_idContext right = (DOTParser.Node_idContext)second;
            String leftId = left.id_().getText();
            String rightId = right.id_().getText();
            Node leftNode = this.getNode(leftId);
            Node rightNode = this.getNode(rightId);
            this.buildLine(attr_list, leftNode, rightNode, left, right);
        } else if (first instanceof DOTParser.SubgraphContext && second instanceof DOTParser.Node_idContext) {
            DOTParser.SubgraphContext left = (DOTParser.SubgraphContext)first;
            DOTParser.Node_idContext right = (DOTParser.Node_idContext)second;
            String rightId = right.id_().getText();
            Node rightNode = this.getNode(rightId);
            this.subgraphNodes(left).forEach(l -> this.buildLine(attr_list, (Node)l, rightNode, null, right));
        } else if (first instanceof DOTParser.Node_idContext && second instanceof DOTParser.SubgraphContext) {
            DOTParser.Node_idContext left = (DOTParser.Node_idContext)first;
            DOTParser.SubgraphContext right = (DOTParser.SubgraphContext)second;
            String leftId = left.id_().getText();
            Node leftNode = this.getNode(leftId);
            this.subgraphNodes(right).forEach(r -> this.buildLine(attr_list, leftNode, (Node)r, left, null));
        } else if (first instanceof DOTParser.SubgraphContext && second instanceof DOTParser.SubgraphContext) {
            DOTParser.SubgraphContext left = (DOTParser.SubgraphContext)first;
            DOTParser.SubgraphContext right = (DOTParser.SubgraphContext)second;
            this.subgraphNodes(left).forEach(l -> this.subgraphNodes(right).forEach(r -> this.buildLine(attr_list, (Node)l, (Node)r, null, null)));
        }
    }

    private Iterable<Node> subgraphNodes(DOTParser.SubgraphContext sg) {
        if (this.subGraphMap == null) {
            throw new IllegalStateException("Cannot found subgraph when edge endpoints are subgraph/cluster");
        }
        GraphContainer container = this.subGraphMap.get((Object)sg);
        if (container == null) {
            throw new IllegalStateException("Cannot found subgraph container");
        }
        return container.nodes();
    }

    private void buildLine(DOTParser.Attr_listContext attr_list, Node leftNode, Node rightNode, DOTParser.Node_idContext leftCtx, DOTParser.Node_idContext rightCtx) {
        Map<String, String> lineAttrs = ParserUtils.getAttrMap(attr_list);
        Map<String, String> tempLineAttrs = this.currentTempAttrs();
        lineAttrs = GraphvizListener.combineAttrs(tempLineAttrs, lineAttrs);
        Line.LineBuilder builder = Line.builder((Node)leftNode, (Node)rightNode);
        ParserUtils.lineAttributes(lineAttrs, builder);
        ParserUtils.setLinePort(builder, this.port(leftCtx, true), this.port(leftCtx, false), true);
        ParserUtils.setLinePort(builder, this.port(rightCtx, true), this.port(rightCtx, false), false);
        if (this.postGraphComponents != null) {
            this.postGraphComponents.postLine(builder);
        }
        Line line = builder.build();
        this.containerStack.peek().addLine(line);
    }

    private String port(DOTParser.Node_idContext node, boolean first) {
        if (node == null) {
            return null;
        }
        DOTParser.PortContext port = node.port();
        if (port == null || port.getChildCount() < 2) {
            return null;
        }
        if (first) {
            ParseTree p = port.getChild(1);
            return p != null ? p.getText() : null;
        }
        if (port.getChildCount() < 4) {
            return null;
        }
        ParseTree p = port.getChild(3);
        return p != null ? p.getText() : null;
    }

    @Override
    public void exitNode_stmt(DOTParser.Node_stmtContext ctx) {
        String id = ctx.node_id().id_().getText();
        this.containerStack.peek().addNode(this.getNode(id));
    }

    @Override
    public void enterSubgraph(DOTParser.SubgraphContext ctx) {
        String id;
        super.enterSubgraph(ctx);
        String string = id = ctx.id_() != null ? ctx.id_().getText() : null;
        if (id != null && id.startsWith("cluster")) {
            Cluster.ClusterBuilder builder = Cluster.builder();
            this.containerStack.push((GraphContainer.GraphContainerBuilder)builder);
        } else {
            Subgraph.SubgraphBuilder builder = Subgraph.builder();
            this.containerStack.push((GraphContainer.GraphContainerBuilder)builder);
        }
    }

    @Override
    public void exitSubgraph(DOTParser.SubgraphContext ctx) {
        GraphContainer gc;
        GraphContainer.GraphContainerBuilder child = this.containerStack.pop();
        GraphContainer.GraphContainerBuilder parent = this.containerStack.peek();
        DOTParser.Id_Context id = ctx.id_();
        if (id != null) {
            child.id(id.getText());
        }
        if (this.postGraphComponents != null && child instanceof Cluster.ClusterBuilder) {
            this.postGraphComponents.postCluster((Cluster.ClusterBuilder)child);
        }
        if ((gc = child.build()).isEmpty()) {
            return;
        }
        if (gc.isCluster()) {
            parent.cluster((Cluster)gc);
        } else if (gc.isSubgraph()) {
            parent.subgraph((Subgraph)gc);
        }
        if (this.subGraphMap == null) {
            this.subGraphMap = new HashMap<DOTParser.SubgraphContext, GraphContainer>();
        }
        this.subGraphMap.put(ctx, gc);
        super.exitSubgraph(ctx);
    }

    public Graphviz getGraphviz() {
        return this.graphviz;
    }

    private Node getNode(String nodeId) {
        return this.nodeExtractor.getNode(nodeId);
    }
}

