/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.parser;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import org.apache_gs.commons.lang3.ArrayUtils;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Cluster;
import org.graphper.api.FloatLabel;
import org.graphper.api.Graphviz;
import org.graphper.api.Html;
import org.graphper.api.Line;
import org.graphper.api.Node;
import org.graphper.api.Subgraph;
import org.graphper.api.attributes.ArrowShape;
import org.graphper.api.attributes.ClusterShapeEnum;
import org.graphper.api.attributes.ClusterStyle;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Dir;
import org.graphper.api.attributes.InitPos;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.Layout;
import org.graphper.api.attributes.LineStyle;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.NodeStyle;
import org.graphper.api.attributes.Port;
import org.graphper.api.attributes.Rank;
import org.graphper.api.attributes.Rankdir;
import org.graphper.api.attributes.Splines;
import org.graphper.api.attributes.Tend;
import org.graphper.parser.HtmlListener;
import org.graphper.parser.HtmlParser;
import org.graphper.parser.grammar.DOTParser;

public class ParserUtils {
    private ParserUtils() {
    }

    public static Map<String, String> getAttrMap(DOTParser.Attr_listContext attr_list) {
        if (attr_list == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attrMap = new HashMap<String, String>(attr_list.getChildCount());
        for (DOTParser.A_listContext al : attr_list.a_list()) {
            ParserUtils.parseAttrs(al, attrMap::put);
        }
        return attrMap;
    }

    private static void parseAttrs(DOTParser.A_listContext a_list, BiConsumer<String, String> pairConsumer) {
        if (a_list == null) {
            return;
        }
        for (int i = 0; i < a_list.id_().size(); i += 2) {
            String key = ParserUtils.parseId(a_list.id_(i), false);
            if (i == a_list.id_().size() - 1) continue;
            String value = ParserUtils.parseId(a_list.id_(i + 1), ParserUtils.isLabel(key));
            pairConsumer.accept(key, value);
        }
    }

    private static String parseId(DOTParser.Id_Context idCtx, boolean isLabel) {
        if (idCtx.ID() != null) {
            return idCtx.ID().getText();
        }
        if (idCtx.STRING() != null) {
            if (isLabel) {
                return "\"" + idCtx.STRING().getText() + "\"";
            }
            return idCtx.STRING().getText();
        }
        if (idCtx.NUMBER() != null) {
            return idCtx.NUMBER().getText();
        }
        if (idCtx.HTML_STRING() != null) {
            return idCtx.HTML_STRING().getText();
        }
        return "";
    }

    public static void subgraphAttributes(DOTParser.Attr_listContext attr_list, Subgraph.SubgraphBuilder l) {
        Map<String, String> attrMap = ParserUtils.getAttrMap(attr_list);
        attrMap.forEach((key, value) -> ParserUtils.subgraphAttribute(key, value, l));
    }

    public static void subgraphAttributes(DOTParser.A_listContext a_list, Subgraph.SubgraphBuilder l) {
        ParserUtils.parseAttrs(a_list, (key, value) -> ParserUtils.subgraphAttribute(key, value, l));
    }

    public static void subgraphAttribute(String key, String value, Subgraph.SubgraphBuilder sb) {
        switch (key.toLowerCase()) {
            case "rank": {
                ParserUtils.setEnum(arg_0 -> ((Subgraph.SubgraphBuilder)sb).rank(arg_0), Rank.class, value.toUpperCase());
                break;
            }
        }
    }

    public static void clusterAttributes(DOTParser.Attr_listContext attr_list, Cluster.ClusterBuilder l) {
        Map<String, String> attrMap = ParserUtils.getAttrMap(attr_list);
        attrMap.forEach((key, value) -> ParserUtils.clusterAttribute(key, value, l));
    }

    public static void clusterAttributes(DOTParser.A_listContext a_list, Cluster.ClusterBuilder l) {
        ParserUtils.parseAttrs(a_list, (key, value) -> ParserUtils.clusterAttribute(key, value, l));
    }

    public static void graphAttributes(DOTParser.Attr_listContext attr_list, Graphviz.GraphvizBuilder gb) {
        Map<String, String> attrMap = ParserUtils.getAttrMap(attr_list);
        attrMap.forEach((key, value) -> ParserUtils.graphAttribute(key, value, gb));
    }

    public static void graphAttributes(DOTParser.A_listContext a_list, Graphviz.GraphvizBuilder gb) {
        ParserUtils.parseAttrs(a_list, (key, value) -> ParserUtils.graphAttribute(key, value, gb));
    }

    public static void graphAttribute(String key, String value, Graphviz.GraphvizBuilder gb) {
        switch (key.toLowerCase()) {
            case "label": {
                ParserUtils.labelHandle(arg_0 -> ((Graphviz.GraphvizBuilder)gb).label(arg_0), arg_0 -> ((Graphviz.GraphvizBuilder)gb).table(arg_0), arg_0 -> ((Graphviz.GraphvizBuilder)gb).labelTag(arg_0), value);
                break;
            }
            case "labelloc": {
                ParserUtils.setEnum(arg_0 -> ((Graphviz.GraphvizBuilder)gb).labelloc(arg_0), Labelloc.class, value.toUpperCase());
                break;
            }
            case "labeljust": {
                ParserUtils.setEnum(arg_0 -> ((Graphviz.GraphvizBuilder)gb).labeljust(arg_0), Labeljust.class, value.toUpperCase());
                break;
            }
            case "fontname": {
                gb.fontName(value);
                break;
            }
            case "splines": {
                ParserUtils.setEnum(arg_0 -> ((Graphviz.GraphvizBuilder)gb).splines(arg_0), Splines.class, value);
                break;
            }
            case "rankdir": {
                ParserUtils.setEnum(arg_0 -> ((Graphviz.GraphvizBuilder)gb).rankdir(arg_0), Rankdir.class, value);
                break;
            }
            case "fillcolor": 
            case "bgcolor": {
                gb.bgColor(ParserUtils.colorOf(value));
                break;
            }
            case "fontcolor": {
                gb.fontColor(ParserUtils.colorOf(value));
                break;
            }
            case "layout": {
                ParserUtils.setEnum(arg_0 -> ((Graphviz.GraphvizBuilder)gb).layout(arg_0), Layout.class, value);
                break;
            }
            case "nodesep": {
                ParserUtils.setDouble(arg_0 -> ((Graphviz.GraphvizBuilder)gb).nodeSep(arg_0), value);
                break;
            }
            case "nslimit": {
                ParserUtils.setInteger(arg_0 -> ((Graphviz.GraphvizBuilder)gb).nslimit(arg_0), value);
                break;
            }
            case "nslimit1": {
                ParserUtils.setInteger(arg_0 -> ((Graphviz.GraphvizBuilder)gb).nslimit1(arg_0), value);
                break;
            }
            case "ranksep": {
                ParserUtils.setDouble(arg_0 -> ((Graphviz.GraphvizBuilder)gb).rankSep(arg_0), value);
                break;
            }
            case "size": {
                Object[] size = ParserUtils.arrayConvert(value, Double::parseDouble, Double.class);
                if (ArrayUtils.isEmpty((Object[])size)) break;
                if (size.length == 1) {
                    gb.scale(((Double)size[0]).doubleValue());
                    break;
                }
                gb.scale(((Double)size[0]).doubleValue(), ((Double)size[1]).doubleValue());
                break;
            }
            case "margin": {
                Object[] margin = ParserUtils.arrayConvert(value, Double::parseDouble, Double.class);
                if (ArrayUtils.isEmpty((Object[])margin)) break;
                if (margin.length == 1) {
                    gb.margin(((Double)margin[0]).doubleValue());
                    break;
                }
                gb.margin(((Double)margin[0]).doubleValue(), ((Double)margin[1]).doubleValue());
                break;
            }
            case "mclimit": {
                ParserUtils.setInteger(arg_0 -> ((Graphviz.GraphvizBuilder)gb).mclimit(arg_0), value);
                break;
            }
            case "fontsize": {
                ParserUtils.setDouble(arg_0 -> ((Graphviz.GraphvizBuilder)gb).fontSize(arg_0), value);
                break;
            }
            case "showgrid": {
                ParserUtils.setBoolean(arg_0 -> ((Graphviz.GraphvizBuilder)gb).showGrid(arg_0), value);
                break;
            }
            case "url": 
            case "href": {
                gb.href(value);
                break;
            }
            case "tooltip": {
                gb.tooltip(value);
                break;
            }
            case "maxiter": {
                ParserUtils.setInteger(arg_0 -> ((Graphviz.GraphvizBuilder)gb).maxiter(arg_0), value);
                break;
            }
            case "k": {
                ParserUtils.setDouble(arg_0 -> ((Graphviz.GraphvizBuilder)gb).k(arg_0), value);
                break;
            }
            case "overlap": {
                ParserUtils.setBoolean(arg_0 -> ((Graphviz.GraphvizBuilder)gb).overlap(arg_0), value);
                break;
            }
            case "initpos": {
                ParserUtils.setEnum(arg_0 -> ((Graphviz.GraphvizBuilder)gb).initPos(arg_0), InitPos.class, value);
                break;
            }
        }
    }

    public static void clusterAttribute(String key, String value, Cluster.ClusterBuilder sb) {
        switch (key.toLowerCase()) {
            case "label": {
                ParserUtils.labelHandle(arg_0 -> ((Cluster.ClusterBuilder)sb).label(arg_0), arg_0 -> ((Cluster.ClusterBuilder)sb).table(arg_0), arg_0 -> ((Cluster.ClusterBuilder)sb).labelTag(arg_0), value);
                break;
            }
            case "labelloc": {
                ParserUtils.setEnum(arg_0 -> ((Cluster.ClusterBuilder)sb).labelloc(arg_0), Labelloc.class, value);
                break;
            }
            case "labeljust": {
                ParserUtils.setEnum(arg_0 -> ((Cluster.ClusterBuilder)sb).labeljust(arg_0), Labeljust.class, value);
                break;
            }
            case "shape": {
                ParserUtils.setEnum(arg_0 -> ((Cluster.ClusterBuilder)sb).shape(arg_0), ClusterShapeEnum.class, value);
                break;
            }
            case "style": {
                ClusterStyle[] clusterStyles = ParserUtils.arrayConvert(value.toUpperCase(), ClusterStyle::valueOf, ClusterStyle.class);
                if (clusterStyles == null) break;
                sb.style(clusterStyles);
                break;
            }
            case "fillcolor": 
            case "bgcolor": {
                sb.bgColor(ParserUtils.colorOf(value));
                break;
            }
            case "color": {
                sb.color(ParserUtils.colorOf(value));
                break;
            }
            case "fontcolor": {
                sb.fontColor(ParserUtils.colorOf(value));
                break;
            }
            case "fontname": {
                sb.fontName(value);
                break;
            }
            case "margin": {
                Object[] margin = ParserUtils.arrayConvert(value, Double::parseDouble, Double.class);
                if (ArrayUtils.isEmpty((Object[])margin)) break;
                if (margin.length == 1) {
                    sb.margin(((Double)margin[0]).doubleValue());
                    break;
                }
                sb.margin(((Double)margin[0]).doubleValue(), ((Double)margin[1]).doubleValue());
                break;
            }
            case "fontsize": {
                ParserUtils.setDouble(arg_0 -> ((Cluster.ClusterBuilder)sb).fontSize(arg_0), value);
                break;
            }
            case "href": 
            case "url": {
                sb.href(value);
                break;
            }
            case "tooltip": {
                sb.tooltip(value);
                break;
            }
            case "penwidth": {
                ParserUtils.setDouble(arg_0 -> ((Cluster.ClusterBuilder)sb).penWidth(arg_0), value);
                break;
            }
        }
    }

    public static void nodeAttributes(DOTParser.Attr_listContext attr_list, Node.NodeBuilder l) {
        Map<String, String> attrMap = ParserUtils.getAttrMap(attr_list);
        ParserUtils.nodeAttributes(l, attrMap);
    }

    public static void nodeAttributes(Node.NodeBuilder nodeBuilder, Map<String, String> attrMap) {
        if (nodeBuilder == null || attrMap == null) {
            return;
        }
        attrMap.forEach((key, value) -> {
            switch (key.toLowerCase()) {
                case "id": {
                    nodeBuilder.id(value);
                    break;
                }
                case "label": {
                    ParserUtils.labelHandle(arg_0 -> ((Node.NodeBuilder)nodeBuilder).label(arg_0), arg_0 -> ((Node.NodeBuilder)nodeBuilder).table(arg_0), arg_0 -> ((Node.NodeBuilder)nodeBuilder).labelTag(arg_0), value);
                    break;
                }
                case "height": {
                    ParserUtils.setDouble(arg_0 -> ((Node.NodeBuilder)nodeBuilder).height(arg_0), value);
                    break;
                }
                case "width": {
                    ParserUtils.setDouble(arg_0 -> ((Node.NodeBuilder)nodeBuilder).width(arg_0), value);
                    break;
                }
                case "shape": {
                    ParserUtils.setEnum(arg_0 -> ((Node.NodeBuilder)nodeBuilder).shape(arg_0), NodeShapeEnum.class, value.toUpperCase());
                    break;
                }
                case "color": {
                    nodeBuilder.color(ParserUtils.colorOf(value));
                    break;
                }
                case "fillcolor": 
                case "bgcolor": {
                    nodeBuilder.fillColor(ParserUtils.colorOf(value));
                    break;
                }
                case "fontcolor": {
                    nodeBuilder.fontColor(ParserUtils.colorOf(value));
                    break;
                }
                case "fontname": {
                    nodeBuilder.fontName(value);
                    break;
                }
                case "labeljust": {
                    ParserUtils.setEnum(arg_0 -> ((Node.NodeBuilder)nodeBuilder).labeljust(arg_0), Labeljust.class, value);
                    break;
                }
                case "labelloc": {
                    ParserUtils.setEnum(arg_0 -> ((Node.NodeBuilder)nodeBuilder).labelloc(arg_0), Labelloc.class, value.toUpperCase());
                    break;
                }
                case "margin": {
                    Object[] margin = ParserUtils.arrayConvert(value, Double::parseDouble, Double.class);
                    if (ArrayUtils.isEmpty((Object[])margin)) break;
                    if (margin.length == 1) {
                        nodeBuilder.margin(((Double)margin[0]).doubleValue());
                        break;
                    }
                    nodeBuilder.margin(((Double)margin[0]).doubleValue(), ((Double)margin[1]).doubleValue());
                    break;
                }
                case "fixedsize": {
                    ParserUtils.setBoolean(arg_0 -> ((Node.NodeBuilder)nodeBuilder).fixedSize(arg_0), value);
                    break;
                }
                case "fontsize": {
                    ParserUtils.setDouble(arg_0 -> ((Node.NodeBuilder)nodeBuilder).fontSize(arg_0), value);
                    break;
                }
                case "style": {
                    ParserUtils.setNodeStyle(arg_0 -> ((Node.NodeBuilder)nodeBuilder).style(arg_0), value);
                    break;
                }
                case "sides": {
                    ParserUtils.setInteger(arg_0 -> ((Node.NodeBuilder)nodeBuilder).sides(arg_0), value.toUpperCase());
                    break;
                }
                case "url": 
                case "href": {
                    nodeBuilder.href(value);
                    break;
                }
                case "tooltip": {
                    nodeBuilder.tooltip(value);
                    break;
                }
                case "image": {
                    nodeBuilder.image(value);
                    break;
                }
                case "penwidth": {
                    ParserUtils.setDouble(arg_0 -> ((Node.NodeBuilder)nodeBuilder).penWidth(arg_0), value);
                    break;
                }
            }
        });
        String imageHeight = attrMap.get("imageHeight");
        String imageWidth = attrMap.get("imageWidth");
        if (imageHeight != null && imageWidth != null) {
            try {
                nodeBuilder.imageSize(Double.parseDouble(imageHeight), Double.parseDouble(imageWidth));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void lineAttributes(Map<String, String> attrMap, Line.LineBuilder builder) {
        FloatLabel.FloatLabelBuilder fb;
        if (attrMap == null || builder == null) {
            return;
        }
        attrMap.forEach((key, value) -> {
            switch (key.toLowerCase()) {
                case "id": {
                    builder.id(value);
                    break;
                }
                case "label": {
                    ParserUtils.labelHandle(arg_0 -> ((Line.LineBuilder)builder).label(arg_0), arg_0 -> ((Line.LineBuilder)builder).table(arg_0), arg_0 -> ((Line.LineBuilder)builder).labelTag(arg_0), value);
                    break;
                }
                case "controlpoints": {
                    ParserUtils.setBoolean(arg_0 -> ((Line.LineBuilder)builder).controlPoints(arg_0), value);
                    break;
                }
                case "showboxes": {
                    ParserUtils.setBoolean(arg_0 -> ((Line.LineBuilder)builder).showboxes(arg_0), value);
                    break;
                }
                case "radian": {
                    ParserUtils.setDouble(arg_0 -> ((Line.LineBuilder)builder).radian(arg_0), value);
                    break;
                }
                case "color": {
                    builder.color(ParserUtils.colorOf(value));
                    break;
                }
                case "weight": {
                    ParserUtils.setDouble(arg_0 -> ((Line.LineBuilder)builder).weight(arg_0), value);
                    break;
                }
                case "fontcolor": {
                    builder.fontColor(ParserUtils.colorOf(value));
                    break;
                }
                case "fontsize": {
                    ParserUtils.setDouble(arg_0 -> ((Line.LineBuilder)builder).fontSize(arg_0), value);
                    break;
                }
                case "fontname": {
                    builder.fontName(value);
                    break;
                }
                case "headclip": {
                    ParserUtils.setBoolean(arg_0 -> ((Line.LineBuilder)builder).headclip(arg_0), value);
                    break;
                }
                case "tailclip": {
                    ParserUtils.setBoolean(arg_0 -> ((Line.LineBuilder)builder).tailclip(arg_0), value);
                    break;
                }
                case "minlen": {
                    ParserUtils.setInteger(arg_0 -> ((Line.LineBuilder)builder).minlen(arg_0), value);
                    break;
                }
                case "style": {
                    LineStyle[] lineStyles = ParserUtils.arrayConvert(value.toUpperCase(), LineStyle::valueOf, LineStyle.class);
                    if (lineStyles == null) break;
                    builder.style(lineStyles);
                    break;
                }
                case "arrowhead": {
                    ParserUtils.setEnum(arg_0 -> ((Line.LineBuilder)builder).arrowHead(arg_0), ArrowShape.class, value.toUpperCase());
                    break;
                }
                case "arrowtail": {
                    ParserUtils.setEnum(arg_0 -> ((Line.LineBuilder)builder).arrowTail(arg_0), ArrowShape.class, value.toUpperCase());
                    break;
                }
                case "arrowsize": {
                    ParserUtils.setDouble(arg_0 -> ((Line.LineBuilder)builder).arrowSize(arg_0), value);
                    break;
                }
                case "dir": {
                    ParserUtils.setEnum(arg_0 -> ((Line.LineBuilder)builder).dir(arg_0), Dir.class, value.toUpperCase());
                    break;
                }
                case "lhead": {
                    builder.lhead(value);
                    break;
                }
                case "ltail": {
                    builder.ltail(value);
                    break;
                }
                case "tailport": {
                    builder.tailPort(Port.valueOfCode((String)value.toLowerCase()));
                    break;
                }
                case "headport": {
                    builder.headPort(Port.valueOfCode((String)value.toLowerCase()));
                    break;
                }
                case "tailcell": {
                    builder.tailCell(value);
                    break;
                }
                case "headcell": {
                    builder.headCell(value);
                    break;
                }
                case "url": 
                case "href": {
                    builder.href(value);
                    break;
                }
                case "tooltip": {
                    builder.tooltip(value);
                    break;
                }
                case "penwidth": {
                    ParserUtils.setDouble(arg_0 -> ((Line.LineBuilder)builder).penWidth(arg_0), value);
                    break;
                }
            }
        });
        String taillabel = attrMap.get("taillabel");
        String headlabel = attrMap.get("headlabel");
        if (StringUtils.isEmpty((CharSequence)taillabel) && StringUtils.isEmpty((CharSequence)headlabel)) {
            return;
        }
        FloatLabel tailFloatLabel = null;
        FloatLabel headFloatLabel = null;
        if (StringUtils.isNotEmpty((CharSequence)taillabel)) {
            fb = FloatLabel.builder();
            ParserUtils.labelHandle(arg_0 -> ((FloatLabel.FloatLabelBuilder)fb).label(arg_0), arg_0 -> ((FloatLabel.FloatLabelBuilder)fb).table(arg_0), arg_0 -> ((FloatLabel.FloatLabelBuilder)fb).labelTag(arg_0), taillabel);
            tailFloatLabel = fb.tend(Tend.TAIL).build();
        }
        if (StringUtils.isNotEmpty((CharSequence)headlabel)) {
            fb = FloatLabel.builder();
            ParserUtils.labelHandle(arg_0 -> ((FloatLabel.FloatLabelBuilder)fb).label(arg_0), arg_0 -> ((FloatLabel.FloatLabelBuilder)fb).table(arg_0), arg_0 -> ((FloatLabel.FloatLabelBuilder)fb).labelTag(arg_0), headlabel);
            headFloatLabel = fb.tend(Tend.HEAD).build();
        }
        if (tailFloatLabel == null) {
            builder.floatLabels(new FloatLabel[]{headFloatLabel});
            return;
        }
        if (headFloatLabel == null) {
            builder.floatLabels(new FloatLabel[]{tailFloatLabel});
            return;
        }
        builder.floatLabels(new FloatLabel[]{tailFloatLabel, headFloatLabel});
    }

    public static void setLinePort(Line.LineBuilder lineBuilder, String p1, String p2, boolean isTail) {
        if (StringUtils.isEmpty((CharSequence)p1) && StringUtils.isEmpty((CharSequence)p2)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)p2)) {
            Port port = Port.valueOfCode((String)p1);
            if (isTail) {
                if (port == null) {
                    lineBuilder.tailCell(p1);
                } else {
                    lineBuilder.tailPort(port);
                }
            } else if (port == null) {
                lineBuilder.headCell(p1);
            } else {
                lineBuilder.headPort(port);
            }
            return;
        }
        if (isTail) {
            lineBuilder.tailCell(p1);
            lineBuilder.tailPort(Port.valueOfCode((String)p2));
        } else {
            lineBuilder.headCell(p1);
            lineBuilder.headPort(Port.valueOfCode((String)p2));
        }
    }

    public static void setTableAttributes(Html.Table table, String key, String value) {
        if (table == null || StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        ParserUtils.setCommonAttributes((Html.Attrs)table, key, value);
        switch (key.toLowerCase()) {
            case "cellborder": {
                ParserUtils.setInteger(arg_0 -> ((Html.Table)table).cellBorder(arg_0), value);
                break;
            }
            case "cellspacing": {
                ParserUtils.setInteger(arg_0 -> ((Html.Table)table).cellSpacing(arg_0), value);
                break;
            }
            case "border": {
                ParserUtils.setInteger(arg_0 -> ((Html.Table)table).border(arg_0), value);
                break;
            }
        }
    }

    public static void setTdAttributes(Html.Td td, String key, String value) {
        if (td == null || StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        ParserUtils.setCommonAttributes((Html.Attrs)td, key, value);
        switch (key.toLowerCase()) {
            case "border": {
                ParserUtils.setInteger(arg_0 -> ((Html.Td)td).border(arg_0), value);
                break;
            }
            case "rowspan": {
                ParserUtils.setInteger(arg_0 -> ((Html.Td)td).rowSpan(arg_0), value);
                break;
            }
            case "colspan": {
                ParserUtils.setInteger(arg_0 -> ((Html.Td)td).colSpan(arg_0), value);
                break;
            }
            case "fontcolor": {
                td.fontColor(ParserUtils.colorOf(value));
                break;
            }
            case "fontname": {
                td.fontName(value);
                break;
            }
            case "fontsize": {
                ParserUtils.setInteger(arg_0 -> ((Html.Td)td).fontSize(arg_0), value);
                break;
            }
            case "shape": {
                ParserUtils.setEnum(arg_0 -> ((Html.Td)td).shape(arg_0), NodeShapeEnum.class, value);
                break;
            }
        }
    }

    public static void setFontAttributes(Html.FontAttrs fontAttrs, String key, String value) {
        if (fontAttrs == null || StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        switch (key.toLowerCase()) {
            case "face": {
                fontAttrs.face(value);
                break;
            }
            case "point-size": {
                ParserUtils.setInteger(arg_0 -> ((Html.FontAttrs)fontAttrs).pointSize(arg_0), value);
                break;
            }
            case "color": {
                fontAttrs.color(ParserUtils.colorOf(value));
                break;
            }
        }
    }

    private static void setCommonAttributes(Html.Attrs attrs, String key, String value) {
        if (attrs == null || StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        switch (key.toLowerCase()) {
            case "id": {
                attrs.id(value);
                break;
            }
            case "align": {
                ParserUtils.setEnum(arg_0 -> ((Html.Attrs)attrs).align(arg_0), Labeljust.class, value);
                break;
            }
            case "valign": {
                ParserUtils.setEnum(arg_0 -> ((Html.Attrs)attrs).valign(arg_0), Labelloc.class, value);
                break;
            }
            case "fillcolor": 
            case "bgcolor": {
                attrs.bgColor(ParserUtils.colorOf(value));
                break;
            }
            case "cellpadding": {
                ParserUtils.setInteger(arg_0 -> ((Html.Attrs)attrs).cellPadding(arg_0), value);
                break;
            }
            case "color": {
                attrs.color(ParserUtils.colorOf(value));
                break;
            }
            case "fixedsize": {
                ParserUtils.setBoolean(arg_0 -> ((Html.Attrs)attrs).fixedSize(arg_0), value);
                break;
            }
            case "width": {
                ParserUtils.setDouble(arg_0 -> ((Html.Attrs)attrs).width(arg_0), value);
                break;
            }
            case "height": {
                ParserUtils.setDouble(arg_0 -> ((Html.Attrs)attrs).height(arg_0), value);
                break;
            }
            case "url": 
            case "href": {
                attrs.href(value);
                break;
            }
            case "tooltip": {
                attrs.tooltip(value);
                break;
            }
            case "style": {
                ParserUtils.setNodeStyle(arg_0 -> ((Html.Attrs)attrs).style(arg_0), value);
                break;
            }
        }
    }

    private static Color colorOf(String color) {
        switch (color.toLowerCase()) {
            case "black": {
                return Color.BLACK;
            }
            case "white": {
                return Color.WHITE;
            }
            case "red": {
                return Color.RED;
            }
            case "orange": {
                return Color.ORANGE;
            }
            case "yellow": {
                return Color.YELLOW;
            }
            case "green": {
                return Color.GREEN;
            }
            case "blue": {
                return Color.BLUE;
            }
            case "indigo": {
                return Color.INDIGO;
            }
            case "purple": {
                return Color.PURPLE;
            }
            case "gold": {
                return Color.GOLD;
            }
            case "grey": {
                return Color.GREY;
            }
            case "pink": {
                return Color.PINK;
            }
            case "bisque": {
                return Color.BISQUE;
            }
            case "lightgrey": {
                return Color.LIGHT_GREY;
            }
            case "lightblue": {
                return Color.LIGHT_BLUE;
            }
            case "chartreuse": {
                return Color.CHARTREUSE;
            }
        }
        try {
            return Color.ofRGB((String)color);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setDouble(DoubleConsumer doubleConsumer, String val) {
        try {
            doubleConsumer.accept(Double.parseDouble(val));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void setInteger(IntConsumer intConsumer, String val) {
        try {
            intConsumer.accept(Integer.parseInt(val));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void setBoolean(Consumer<Boolean> boolConsumer, String val) {
        try {
            boolConsumer.accept(Boolean.parseBoolean(val.toLowerCase()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static <T extends Enum<T>> void setEnum(Consumer<T> consumer, Class<T> enumClass, String name) {
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(name)) continue;
            consumer.accept(enumConstant);
        }
        if (enumClass == Labeljust.class) {
            switch (name.toLowerCase()) {
                case "l": {
                    consumer.accept((Enum)Labeljust.LEFT);
                    break;
                }
                case "c": {
                    consumer.accept((Enum)Labeljust.CENTER);
                    break;
                }
                case "r": {
                    consumer.accept((Enum)Labeljust.RIGHT);
                    break;
                }
            }
        }
        if (enumClass == Labelloc.class) {
            switch (name.toLowerCase()) {
                case "t": {
                    consumer.accept((Enum)Labelloc.TOP);
                    break;
                }
                case "c": {
                    consumer.accept((Enum)Labelloc.CENTER);
                    break;
                }
                case "b": {
                    consumer.accept((Enum)Labelloc.BOTTOM);
                    break;
                }
            }
        }
    }

    private static <T> T[] arrayConvert(String val, Function<String, T> eleMapFunc, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        try {
            return Stream.of(val.split(",")).map(eleMapFunc).toArray(size -> (Object[])Array.newInstance(clazz, size));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isLabel(String key) {
        return "label".equalsIgnoreCase(key = key.trim()) || "taillabel".equalsIgnoreCase(key) || "headlabel".equalsIgnoreCase(key);
    }

    private static void labelHandle(Consumer<String> labelConsumer, Consumer<Html.Table> tableConsumer, Consumer<Html.LabelTag> labelTagConsumer, String label) {
        HtmlListener htmlListener = HtmlParser.parse(label);
        if (htmlListener != null) {
            Html.Table table = htmlListener.getTable();
            if (table != null) {
                tableConsumer.accept(table);
                return;
            }
            Html.LabelTag labelTag = htmlListener.getLabelTag();
            if (labelTag != null) {
                labelTagConsumer.accept(labelTag);
                return;
            }
            label = StringUtils.isEmpty((CharSequence)htmlListener.getLabel()) ? label : htmlListener.getLabel();
            labelConsumer.accept(label);
        } else {
            if (label.startsWith("\"") && label.endsWith("\"") || label.startsWith("<") && label.endsWith(">")) {
                label = label.substring(1, label.length() - 1);
            }
            labelConsumer.accept(label);
        }
    }

    private static void setNodeStyle(Consumer<NodeStyle[]> styleConsumer, String style) {
        NodeStyle[] nodeStyles = ParserUtils.arrayConvert(style.toUpperCase(), NodeStyle::valueOf, NodeStyle.class);
        if (nodeStyles != null) {
            styleConsumer.accept(nodeStyles);
        }
    }
}

