/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.Iterator;
import org.graphstream.algorithm.SpanningTree;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpanningTree
implements SpanningTree {
    protected Graph graph = null;
    protected String flagAttribute;
    protected Object flagOn;
    protected Object flagOff;

    public AbstractSpanningTree() {
        this(null, null, null);
    }

    public AbstractSpanningTree(String flagAttribute) {
        this(flagAttribute, true, false);
    }

    public AbstractSpanningTree(String flagAttribute, Object flagOn, Object flagOff) {
        this.flagAttribute = flagAttribute;
        this.flagOn = flagOn;
        this.flagOff = flagOff;
    }

    @Override
    public String getFlagAttribute() {
        return this.flagAttribute;
    }

    @Override
    public void setFlagAttribute(String flagAttribute) {
        if (this.graph != null) {
            throw new IllegalStateException("Flag attribute can be set only before the algorithm is initialized");
        }
        this.flagAttribute = flagAttribute;
    }

    @Override
    public Object getFlagOn() {
        return this.flagOn;
    }

    @Override
    public void setFlagOn(Object flagOn) {
        if (this.graph != null) {
            throw new IllegalStateException("Flag values can be set only before the algorithm is initialized");
        }
        this.flagOn = flagOn;
    }

    @Override
    public Object getFlagOff() {
        return this.flagOff;
    }

    @Override
    public void setFlagOff(Object flagOff) {
        if (this.graph != null) {
            throw new IllegalStateException("Flag values can be set only before the algorithm is initialized");
        }
        this.flagOff = flagOff;
    }

    protected void edgeOn(Edge e) {
        if (this.flagAttribute != null) {
            if (this.flagOn != null) {
                e.changeAttribute(this.flagAttribute, new Object[]{this.flagOn});
            } else {
                e.removeAttribute(this.flagAttribute);
            }
        }
    }

    protected void edgeOff(Edge e) {
        if (this.flagAttribute != null) {
            if (this.flagOff != null) {
                e.changeAttribute(this.flagAttribute, new Object[]{this.flagOff});
            } else {
                e.removeAttribute(this.flagAttribute);
            }
        }
    }

    protected void resetFlags() {
        for (Edge edge : this.graph.getEachEdge()) {
            this.edgeOff(edge);
        }
    }

    protected abstract void makeTree();

    @Override
    public abstract <T extends Edge> Iterator<T> getTreeEdgesIterator();

    @Override
    public <T extends Edge> Iterable<T> getTreeEdges() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractSpanningTree.this.getTreeEdgesIterator();
            }
        };
    }

    @Override
    public void clear() {
        if (this.flagAttribute != null) {
            for (Edge edge : this.graph.getEachEdge()) {
                edge.removeAttribute(this.flagAttribute);
            }
        }
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        if (this.graph == null) {
            return;
        }
        this.resetFlags();
        this.makeTree();
    }
}

