/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.generator.DorogovtsevMendesGenerator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.Sink;

public class DStar
implements DynamicAlgorithm,
Sink {
    public static final String STATE_ATTRIBUTE = "d*.state";
    public static final String COST_ATTRIBUTE = "d*.cost";
    protected String edgeWeightAttribute = "weight";
    protected double defaultEdgeWeight = 1.0;
    protected State g = null;
    protected State position;
    protected LinkedList<State> openList;
    protected Graph env = null;
    protected final Comparator<State> stateComparator = new Comparator<State>(){

        @Override
        public int compare(State o1, State o2) {
            return (int)Math.signum(DStar.this.k(o1) - DStar.this.k(o2));
        }
    };

    public DStar() {
        this.openList = new LinkedList();
    }

    public void terminate() {
        this.env.removeSink((Sink)this);
    }

    public void compute() {
        while (this.processState() >= 0.0 && this.position.t != Tag.CLOSED) {
        }
    }

    public void init(Graph graph) {
        this.openList.clear();
        this.env = graph;
        this.env.addSink((Sink)this);
    }

    public void init(Node source, Node target, Graph graph) {
        this.init(graph);
        this.g = this.getState(target);
        this.g.h = 0.0;
        this.insert(this.g);
        this.position = this.getState(source);
    }

    protected State minState() {
        Collections.sort(this.openList, this.stateComparator);
        return this.openList.getFirst();
    }

    protected double getKMin() {
        double kmin = Double.MAX_VALUE;
        for (State x : this.openList) {
            kmin = Math.min(kmin, this.k(x));
        }
        return kmin;
    }

    protected double processState() {
        State x = this.minState();
        if (x == null) {
            return -1.0;
        }
        double kOld = this.getKMin();
        this.delete(x);
        for (State y : x) {
            if (y.t != Tag.CLOSED || !(y.h <= kOld) || !(x.h > y.h + this.c(y, x))) continue;
            x.b = y;
            x.h = y.h + this.c(y, x);
            assert (!Double.isNaN(x.h));
        }
        for (State y : x) {
            if (y.t == Tag.NEW) {
                y.b = x;
                y.p = y.h = x.h + this.c(x, y);
                assert (!Double.isNaN(y.h));
                this.insert(y);
                continue;
            }
            if (y.b == x && y.h != x.h + this.c(x, y)) {
                if (y.t == Tag.OPEN) {
                    if (y.h < y.p) {
                        y.p = y.h;
                    }
                    y.h = x.h + this.c(x, y);
                    assert (!Double.isNaN(y.h));
                } else {
                    y.p = y.h = x.h + this.c(x, y);
                    assert (!Double.isNaN(y.h));
                }
                this.insert(y);
                continue;
            }
            if (y.b != x && y.h > x.h + this.c(x, y)) {
                if (x.p >= x.h) {
                    y.b = x;
                    y.h = x.h + this.c(x, y);
                    if (y.t == Tag.CLOSED) {
                        y.p = y.h;
                    }
                    assert (!Double.isNaN(y.h));
                    this.insert(y);
                    continue;
                }
                x.p = x.h;
                this.insert(x);
                continue;
            }
            if (y.b == x || !(x.h > y.h + this.c(y, x)) || y.t != Tag.CLOSED || !(y.h > kOld)) continue;
            y.p = y.h;
            assert (!Double.isNaN(y.h));
            this.insert(y);
        }
        return this.getKMin();
    }

    protected void modifyCost(String edgeId, double cval) {
        Edge e = this.env.getEdge(edgeId);
        if (e.isDirected()) {
            this.modifyCost(this.getState(e.getSourceNode()), this.getState(e.getTargetNode()), cval);
        } else {
            this.modifyCost(this.getState(e.getNode0()), this.getState(e.getNode1()), cval);
            this.modifyCost(this.getState(e.getNode1()), this.getState(e.getNode0()), cval);
        }
    }

    protected void modifyCost(State x, State y, double cval) {
        Edge e = x.node.getEdgeBetween(y.node);
        if (e != null) {
            e.setAttribute(COST_ATTRIBUTE, new Object[]{cval});
        }
        if (x.b == y) {
            x.b = null;
        }
        if (x.t == Tag.CLOSED) {
            x.p = x.h;
            this.insert(x);
        }
    }

    public State getState(Node n) {
        State s = (State)n.getAttribute(STATE_ATTRIBUTE);
        if (s == null) {
            s = new State(n);
            n.addAttribute(STATE_ATTRIBUTE, new Object[]{s});
        }
        return s;
    }

    protected double c(State x, State y) {
        Edge e = x.node.getEdgeBetween(y.node);
        if (e != null) {
            if (e.hasNumber(COST_ATTRIBUTE)) {
                return e.getNumber(COST_ATTRIBUTE);
            }
            return this.defaultEdgeWeight;
        }
        return Double.NaN;
    }

    protected double k(State x) {
        if (x.t != Tag.OPEN) {
            return Double.NaN;
        }
        return Math.min(x.h, x.p);
    }

    protected void insert(State x) {
        this.openList.add(x);
        x.t = Tag.OPEN;
        x.p = x.h;
    }

    protected void delete(State x) {
        this.openList.remove(x);
        x.t = Tag.CLOSED;
    }

    protected boolean isMonotonic(State xn, int n) {
        State xi1 = xn;
        State xi = xi1.b;
        for (int i = n; i > 0; --i) {
            if (!(xi.t == Tag.CLOSED && xi.h < xi1.h || xi.t == Tag.OPEN && xi.p < xi1.h)) {
                return false;
            }
            xi1 = xi;
            xi = xi1.b;
        }
        return true;
    }

    public void markPath(String attribute, Object on, Object off) {
        for (Node n : this.env) {
            n.setAttribute(attribute, new Object[]{off});
        }
        for (Edge e : this.env.getEachEdge()) {
            e.setAttribute(attribute, new Object[]{off});
        }
        State s = this.position;
        do {
            s.node.setAttribute(attribute, new Object[]{on});
            s.node.getEdgeBetween(s.b.node).setAttribute(attribute, new Object[]{on});
        } while ((s = s.b) != this.g);
        this.g.node.setAttribute(attribute, new Object[]{on});
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (attribute.equals(this.edgeWeightAttribute) && value != null && value instanceof Number) {
            this.modifyCost(edgeId, ((Number)value).doubleValue());
        }
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (attribute.equals(this.edgeWeightAttribute) && newValue != null && newValue instanceof Number) {
            this.modifyCost(edgeId, ((Number)newValue).doubleValue());
        }
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.modifyCost(edgeId, this.defaultEdgeWeight);
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.modifyCost(edgeId, Double.NaN);
    }

    public void graphCleared(String sourceId, long timeId) {
        throw new RuntimeException();
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        Node n = this.env.getNode(nodeId);
        State s = this.getState(n);
        if (s == this.g || s == this.position) {
            throw new RuntimeException();
        }
        NeighborStateIterator it = new NeighborStateIterator(s);
        while (it.hasNext()) {
            State o = (State)it.next();
            this.modifyCost(s, o, Double.NaN);
            this.modifyCost(o, s, Double.NaN);
        }
    }

    public void stepBegins(String sourceId, long timeId, double step) {
    }

    public static void main(String ... args) {
        DorogovtsevMendesGenerator gen = new DorogovtsevMendesGenerator();
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        DStar dstar = new DStar();
        Random r = new Random();
        boolean alive = true;
        g.addAttribute("ui.stylesheet", new Object[]{"node.on { fill-color: red; } node.off { fill-color: black; } edge.on { fill-color: red; } edge.off { fill-color: black; }"});
        gen.addSink((Sink)g);
        g.display(true);
        gen.begin();
        for (int i = 0; i < 150; ++i) {
            gen.nextEvents();
        }
        dstar.init(Toolkit.randomNode((Graph)g), Toolkit.randomNode((Graph)g), (Graph)g);
        do {
            dstar.compute();
            dstar.markPath("ui.class", "on", "off");
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            State s = dstar.position;
            while (s.b != dstar.g && s.b != null && r.nextBoolean()) {
                s = s.b;
            }
            if (r.nextBoolean() && s != dstar.position && s.b != dstar.g) {
                g.removeNode(s.node);
            } else {
                g.removeEdge(s.node.getEdgeBetween(s.b.node));
            }
            gen.nextEvents();
        } while (alive);
        gen.end();
        dstar.terminate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NeighborStateIterator
    implements Iterator<State> {
        Node source;
        Iterator<Edge> it;

        public NeighborStateIterator(State x) {
            this.source = x.node;
            this.it = this.source.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public State next() {
            return DStar.this.getState(this.it.next().getOpposite(this.source));
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class State
    implements Iterable<State> {
        Node node;
        Tag t;
        State b;
        double p;
        double h;

        public State(Node node) {
            this.node = node;
            this.t = Tag.NEW;
            this.b = null;
            this.p = 0.0;
            this.h = 0.0;
        }

        @Override
        public Iterator<State> iterator() {
            return new NeighborStateIterator(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Tag {
        NEW,
        OPEN,
        CLOSED,
        LOWER,
        RAISE;

    }
}

