/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.ElementSink;

public class PageRank
implements DynamicAlgorithm,
ElementSink {
    public static final double DEFAULT_DAMPING_FACTOR = 0.85;
    public static final double DEFAULT_PRECISION = 1.0E-5;
    public static final String DEFAULT_RANK_ATTRIBUTE = "PageRank";
    protected double dampingFactor;
    protected double precision;
    protected String rankAttribute;
    protected Graph graph;
    protected boolean upToDate;
    protected double normDiff;
    protected List<Double> newRanks;
    protected int iterationCount;
    protected boolean verbose;

    public PageRank() {
        this(0.85, 1.0E-5, DEFAULT_RANK_ATTRIBUTE);
    }

    public PageRank(double dampingFactor, double precision, String rankAttribute) {
        this.setDampingFactor(dampingFactor);
        this.setPrecision(precision);
        this.setRankAttribute(rankAttribute);
        this.verbose = false;
    }

    public double getDampingFactor() {
        return this.dampingFactor;
    }

    public void setDampingFactor(double dampingFactor) throws IllegalArgumentException {
        if (dampingFactor < 0.01 || dampingFactor > 0.99) {
            throw new IllegalArgumentException("The damping factor must be between 0.01 and 0.99");
        }
        this.dampingFactor = dampingFactor;
        this.upToDate = false;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) throws IllegalArgumentException {
        if (precision < 1.0E-7) {
            throw new IllegalArgumentException("Precision is too small");
        }
        this.precision = precision;
        this.upToDate = false;
    }

    public String getRankAttribute() {
        return this.rankAttribute;
    }

    public void setRankAttribute(String rankAttribute) throws IllegalStateException {
        if (this.graph != null) {
            throw new IllegalStateException("this method can be called only before init");
        }
        this.rankAttribute = rankAttribute;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void init(Graph graph) {
        this.graph = graph;
        graph.addElementSink((ElementSink)this);
        double initialRank = 1.0 / (double)graph.getNodeCount();
        for (Node node : graph) {
            node.addAttribute(this.rankAttribute, new Object[]{initialRank});
        }
        this.newRanks = new ArrayList<Double>(graph.getNodeCount());
        this.upToDate = false;
        this.iterationCount = 0;
    }

    public void compute() {
        if (this.upToDate) {
            return;
        }
        do {
            this.iteration();
            if (!this.verbose) continue;
            System.err.printf("%6d%16.8f%n", this.iterationCount, this.normDiff);
        } while (this.normDiff > this.precision);
        this.upToDate = true;
    }

    public void terminate() {
        this.graph.removeElementSink((ElementSink)this);
        this.newRanks.clear();
        this.newRanks = null;
        this.graph = null;
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.graph.getNode(nodeId).addAttribute(this.rankAttribute, new Object[]{this.graph.getNodeCount() == 1 ? 1.0 : 0.0});
        this.upToDate = false;
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        double part = this.graph.getNode(nodeId).getNumber(this.rankAttribute) / (double)(this.graph.getNodeCount() - 1);
        for (Node node : this.graph) {
            if (node.getId().equals(nodeId)) continue;
            node.addAttribute(this.rankAttribute, new Object[]{node.getNumber(this.rankAttribute) + part});
        }
        this.upToDate = false;
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.upToDate = false;
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.upToDate = false;
    }

    public void graphCleared(String sourceId, long timeId) {
        this.upToDate = true;
    }

    public void stepBegins(String sourceId, long timeId, double step) {
    }

    protected void iteration() {
        Node node;
        int i;
        double dampingTerm = (1.0 - this.dampingFactor) / (double)this.graph.getNodeCount();
        this.newRanks.clear();
        double danglingRank = 0.0;
        for (i = 0; i < this.graph.getNodeCount(); ++i) {
            node = this.graph.getNode(i);
            double sum = 0.0;
            for (int j = 0; j < node.getInDegree(); ++j) {
                Node other = node.getEnteringEdge(j).getOpposite(node);
                sum += other.getNumber(this.rankAttribute) / (double)other.getOutDegree();
            }
            this.newRanks.add(dampingTerm + this.dampingFactor * sum);
            if (node.getOutDegree() != 0) continue;
            danglingRank += node.getNumber(this.rankAttribute);
        }
        danglingRank *= this.dampingFactor / (double)this.graph.getNodeCount();
        this.normDiff = 0.0;
        for (i = 0; i < this.graph.getNodeCount(); ++i) {
            node = this.graph.getNode(i);
            double currentRank = node.getNumber(this.rankAttribute);
            double newRank = this.newRanks.get(i) + danglingRank;
            this.normDiff += Math.abs(newRank - currentRank);
            node.addAttribute(this.rankAttribute, new Object[]{newRank});
        }
        ++this.iterationCount;
    }

    public double getRank(Node node) {
        this.compute();
        return node.getNumber(this.rankAttribute);
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

