/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import org.graphstream.algorithm.DefineParameter;
import org.graphstream.algorithm.InvalidParameterException;
import org.graphstream.algorithm.MissingParameterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    protected String key;
    protected Object value;

    public static final Parameter parameter(String key, Object value) {
        return new Parameter(key, value);
    }

    public static void processParameters(Object env, Parameter ... params) throws InvalidParameterException, MissingParameterException {
        if (params == null || params.length == 0) {
            return;
        }
        ParametersProcessor pp = new ParametersProcessor(env, params);
        pp.process();
    }

    public Parameter(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public static class ParametersProcessor {
        HashMap<Field, Object> fields = new HashMap();
        HashMap<String, Object> params = new HashMap();

        public ParametersProcessor(Object obj, Parameter ... parameters) {
            if (obj.getClass().isArray()) {
                Object[] objects;
                for (Object o : objects = (Object[])obj) {
                    this.buildFields(o);
                }
            } else {
                this.buildFields(obj);
            }
            this.buildParametersMap(parameters);
        }

        public void process() throws InvalidParameterException, MissingParameterException {
            this.checkNonOptionalParameters();
            LinkedList<String> remainingParameters = new LinkedList<String>(this.params.keySet());
            for (Field f : this.fields.keySet()) {
                DefineParameter dp = f.getAnnotation(DefineParameter.class);
                if (!this.params.containsKey(dp.name())) continue;
                try {
                    f.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object value = this.params.get(dp.name());
                this.setValue(dp, f, value);
                remainingParameters.remove(dp.name());
            }
            if (remainingParameters.size() > 0) {
                String uneatenParams = "";
                for (String s : remainingParameters) {
                    uneatenParams = uneatenParams + String.format("%s\"%s\"", uneatenParams.length() > 0 ? ", " : "", s);
                }
                throw new InvalidParameterException("some parameters does not exist : %s", uneatenParams);
            }
        }

        protected void buildFields(Object obj) {
            for (Class<?> cls = obj.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                Field[] clsFields = cls.getDeclaredFields();
                if (clsFields == null) continue;
                for (Field f : clsFields) {
                    if (f.getAnnotation(DefineParameter.class) == null) continue;
                    this.fields.put(f, obj);
                }
            }
        }

        protected void buildParametersMap(Parameter ... parameters) {
            for (Parameter p : parameters) {
                this.params.put(p.getKey(), p.getValue());
            }
        }

        protected void setValue(DefineParameter dp, Field f, Object value) throws InvalidParameterException {
            this.checkValue(dp, f, value);
            Object env = this.fields.get(f);
            this.callBeforeSetTrigger(dp, f, value);
            if (dp.setter().length() == 0) {
                try {
                    f.set(env, value);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidParameterException("invalid value type for %s, %s expected", dp.name(), f.getType().getName());
                }
                catch (IllegalAccessException e) {
                    throw new InvalidParameterException("parameter value can not be set. maybe a permission problem", new Object[0]);
                }
            } else {
                this.callSetter(dp, f, value);
            }
            this.callAfterSetTrigger(dp, f, value);
        }

        protected void checkValue(DefineParameter dp, Field f, Object value) throws InvalidParameterException {
            boolean isNumber = value instanceof Number;
            if (dp.type() != Object.class && !dp.type().isAssignableFrom(value.getClass())) {
                throw new InvalidParameterException("invalid parameter type, should be %s", dp.type().getName());
            }
            if (!Double.isNaN(dp.min()) || !Double.isNaN(dp.max())) {
                if (!isNumber) {
                    throw new InvalidParameterException("min or max defined but value is not a number for %s", dp.name());
                }
                Number n = (Number)value;
                if (dp.min() != Double.NaN && n.doubleValue() < dp.min()) {
                    throw new InvalidParameterException(String.format("bad value for \"%s\", %f < min", dp.name(), n.doubleValue()), new Object[0]);
                }
                if (dp.max() != Double.NaN && n.doubleValue() > dp.max()) {
                    throw new InvalidParameterException(String.format("bad value for \"%s\", %f > max", dp.name(), n.doubleValue()), new Object[0]);
                }
            }
            if (dp.strings().length > 0) {
                if (value.getClass() != String.class) {
                    throw new InvalidParameterException("value should be a String", new Object[0]);
                }
                String s = (String)value;
                boolean found = false;
                for (String alt : dp.strings()) {
                    if (!alt.equals(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new InvalidParameterException("\"%s\" is not in the allowed values for %s", value, dp.name());
                }
            }
        }

        protected void checkNonOptionalParameters() throws MissingParameterException {
            for (Field f : this.fields.keySet()) {
                DefineParameter dp = f.getAnnotation(DefineParameter.class);
                if (dp.optional() || this.params.containsKey(dp.name())) continue;
                throw new MissingParameterException("parameter \"%s\" is missing", dp.name());
            }
        }

        protected void callSetter(DefineParameter dp, Field f, Object value) throws InvalidParameterException {
            Object env = this.fields.get(f);
            Method setter = null;
            block8: for (Class<?> cls = env.getClass(); setter == null && cls != Object.class; cls = cls.getSuperclass()) {
                Method[] methods = cls.getDeclaredMethods();
                if (methods == null) continue;
                for (Method m : methods) {
                    if (!m.getName().equals(dp.setter())) continue;
                    setter = m;
                    continue block8;
                }
            }
            if (setter == null) {
                throw new InvalidParameterException("'setter' '%s()' can not be found for %s", dp.setter(), dp.name());
            }
            Object[] args = null;
            switch (setter.getParameterTypes().length) {
                case 1: {
                    args = new Object[]{value};
                    break;
                }
                case 2: {
                    args = new Object[]{dp.name(), value};
                    break;
                }
                default: {
                    throw new InvalidParameterException("bad argument count in 'setter' '%s()' for %s", dp.setter(), dp.name());
                }
            }
            try {
                setter.invoke(env, args);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidParameterException("bad arguments in 'setter' '%s()'for %s", dp.setter(), dp.name());
            }
            catch (IllegalAccessException e) {
                throw new InvalidParameterException("illegal access to 'setter' '%s()' for %s", dp.setter(), dp.name());
            }
            catch (InvocationTargetException e) {
                throw new InvalidParameterException("invocation error of 'setter' '%s()' for %s", dp.setter(), dp.name());
            }
        }

        protected void callBeforeSetTrigger(DefineParameter dp, Field f, Object value) throws InvalidParameterException {
            if (dp.beforeSet().length() > 0) {
                Object env = this.fields.get(f);
                Method beforeSet = null;
                block9: for (Class<?> cls = env.getClass(); beforeSet == null && cls != Object.class; cls = cls.getSuperclass()) {
                    Method[] methods = cls.getDeclaredMethods();
                    if (methods == null) continue;
                    for (Method m : methods) {
                        if (!m.getName().equals(dp.beforeSet())) continue;
                        beforeSet = m;
                        continue block9;
                    }
                }
                if (beforeSet == null) {
                    throw new InvalidParameterException("'beforeSet' trigger '%s()' can not be found for %s", dp.beforeSet(), dp.name());
                }
                Object[] args = null;
                switch (beforeSet.getParameterTypes().length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        args = new Object[]{value};
                        break;
                    }
                    case 2: {
                        args = new Object[]{dp.name(), value};
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("two much arguments in 'beforeSet' trigger '%s()' for %s", dp.beforeSet(), dp.name());
                    }
                }
                try {
                    beforeSet.invoke(env, args);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidParameterException("bad arguments in 'beforeSet' trigger '%s()'for %s", dp.beforeSet(), dp.name());
                }
                catch (IllegalAccessException e) {
                    throw new InvalidParameterException("illegal access to 'beforeSet' trigger '%s()' for %s", dp.beforeSet(), dp.name());
                }
                catch (InvocationTargetException e) {
                    throw new InvalidParameterException("invocation error of 'beforeSet' trigger '%s()' for %s", dp.beforeSet(), dp.name());
                }
            }
        }

        protected void callAfterSetTrigger(DefineParameter dp, Field f, Object value) throws InvalidParameterException {
            Object env = this.fields.get(f);
            if (dp.afterSet().length() > 0) {
                Method afterSet = null;
                block9: for (Class<?> cls = env.getClass(); afterSet == null && cls != Object.class; cls = cls.getSuperclass()) {
                    Method[] methods = cls.getDeclaredMethods();
                    if (methods == null) continue;
                    for (Method m : methods) {
                        if (!m.getName().equals(dp.afterSet())) continue;
                        afterSet = m;
                        continue block9;
                    }
                }
                if (afterSet == null) {
                    throw new InvalidParameterException("'afterSet' trigger '%s()' can not be found for %s", dp.afterSet(), dp.name());
                }
                Object[] args = null;
                switch (afterSet.getParameterTypes().length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        args = new Object[]{value};
                        break;
                    }
                    case 2: {
                        args = new Object[]{dp.name(), value};
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("two much arguments in 'afterSet' trigger '%s()' for %s", dp.afterSet(), dp.name());
                    }
                }
                try {
                    afterSet.invoke(env, args);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidParameterException("bad arguments in 'afterSet' trigger '%s()'for %s", dp.afterSet(), dp.name());
                }
                catch (IllegalAccessException e) {
                    throw new InvalidParameterException("illegal access to 'afterSet' trigger '%s()' for %s", dp.afterSet(), dp.name());
                }
                catch (InvocationTargetException e) {
                    throw new InvalidParameterException("invocation error of 'afterSet' trigger '%s()' for %s", dp.afterSet(), dp.name());
                }
            }
        }
    }
}

