/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.LinkedList;
import org.graphstream.algorithm.Kruskal;
import org.graphstream.algorithm.util.FibonacciHeap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

public class Prim
extends Kruskal {
    public Prim() {
    }

    public Prim(String weightAttribute, String flagAttribute) {
        super(weightAttribute, flagAttribute);
    }

    public Prim(String flagAttribute, Object flagOn, Object flagOff) {
        super(flagAttribute, flagOn, flagOff);
    }

    public Prim(String weightAttribute, String flagAttribute, Object flagOn, Object flagOff) {
        super(weightAttribute, flagAttribute, flagOn, flagOff);
    }

    protected void makeTree() {
        if (this.treeEdges == null) {
            this.treeEdges = new LinkedList();
        } else {
            this.treeEdges.clear();
        }
        int n = this.graph.getNodeCount();
        Data[] data = new Data[n];
        FibonacciHeap<Double, Node> heap = new FibonacciHeap<Double, Node>();
        for (int i = 0; i < n; ++i) {
            data[i] = new Data();
            data[i].edgeToTree = null;
            data[i].fn = heap.add(Double.POSITIVE_INFINITY, this.graph.getNode(i));
        }
        this.treeWeight = 0.0;
        while (!heap.isEmpty()) {
            Node u = (Node)heap.extractMin();
            Data dataU = data[u.getIndex()];
            data[u.getIndex()] = null;
            if (dataU.edgeToTree != null) {
                this.treeEdges.add(dataU.edgeToTree);
                this.edgeOn(dataU.edgeToTree);
                this.treeWeight += ((Double)dataU.fn.getKey()).doubleValue();
                dataU.edgeToTree = null;
            }
            dataU.fn = null;
            for (Edge e : u) {
                double w;
                Node v = e.getOpposite(u);
                Data dataV = data[v.getIndex()];
                if (dataV == null || !((w = this.getWeight(e)) < (Double)dataV.fn.getKey())) continue;
                heap.decreaseKey(dataV.fn, w);
                dataV.edgeToTree = e;
            }
        }
    }

    protected static class Data {
        Edge edgeToTree;
        FibonacciHeap.Node fn;

        protected Data() {
        }
    }
}

