/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.coloring;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class WelshPowell
implements Algorithm {
    protected String attrName = "WelshPowell.color";
    protected Graph g;
    protected int chromaticNumber;

    public WelshPowell(String attrName) {
        this.attrName = attrName;
    }

    public WelshPowell() {
    }

    public int getChromaticNumber() {
        return this.chromaticNumber;
    }

    public void setAttributeName(String attrName) {
        this.attrName = attrName;
    }

    public void init(Graph g) {
        this.g = g;
    }

    public void compute() {
        String attributeName = "WelshPowell.color";
        if (this.attrName != null) {
            attributeName = this.attrName;
        }
        Comparator<Node> degreeComparator = new Comparator<Node>(){

            @Override
            public int compare(Node ni, Node nj) {
                int returnValue = 0;
                int diff = ni.getDegree() - nj.getDegree();
                if (diff > 0) {
                    returnValue = -1;
                } else if (diff < 0) {
                    returnValue = 1;
                }
                return returnValue;
            }
        };
        PriorityQueue<Node> pq = new PriorityQueue<Node>(this.g.getNodeCount(), degreeComparator);
        Iterator nodes = this.g.getNodeIterator();
        while (nodes.hasNext()) {
            pq.add((Node)nodes.next());
        }
        ArrayList<Node> sortedNodes = new ArrayList<Node>();
        for (int i = 0; i < this.g.getNodeCount(); ++i) {
            sortedNodes.add(pq.poll());
        }
        ArrayList<Integer> allColors = new ArrayList<Integer>();
        int nbColors = 0;
        for (int i = 0; i < this.g.getNodeCount(); ++i) {
            Integer col = i;
            allColors.add(col);
        }
        Integer currentColor = (Integer)allColors.remove(0);
        ++nbColors;
        while (!sortedNodes.isEmpty()) {
            int index = 0;
            while (index < sortedNodes.size()) {
                Node n = (Node)sortedNodes.get(index);
                Iterator neighbors = n.getNeighborNodeIterator();
                boolean conflict = false;
                while (neighbors.hasNext() && !conflict) {
                    Node neighb = (Node)neighbors.next();
                    if (!neighb.hasAttribute(attributeName) || !neighb.getAttribute(attributeName).equals(currentColor)) continue;
                    conflict = true;
                }
                if (!conflict) {
                    n.addAttribute(attributeName, new Object[]{currentColor});
                    sortedNodes.remove(index);
                    continue;
                }
                ++index;
            }
            currentColor = (Integer)allColors.remove(0);
            ++nbColors;
        }
        this.chromaticNumber = nbColors - 1;
    }
}

