/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.flow;

import java.util.Arrays;
import java.util.LinkedList;
import org.graphstream.algorithm.flow.FordFulkersonAlgorithm;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdmondsKarpAlgorithm
extends FordFulkersonAlgorithm {
    @Override
    protected double findPath(LinkedList<Node> path, Node source, Node target) {
        LinkedList<Node> Q = new LinkedList<Node>();
        int[] P = new int[source.getGraph().getNodeCount()];
        double[] M = new double[source.getGraph().getNodeCount()];
        Arrays.fill(P, -1);
        P[source.getIndex()] = -2;
        M[source.getIndex()] = Double.MAX_VALUE;
        Q.add(source);
        while (Q.size() > 0) {
            Node u = (Node)Q.pop();
            for (int i = 0; i < u.getDegree(); ++i) {
                Edge e = u.getEdge(i);
                Node v = e.getOpposite(u);
                double r = this.getCapacity(u, v) - this.getFlow(u, v);
                if (!(r > 0.0) || P[v.getIndex()] != -1) continue;
                P[v.getIndex()] = u.getIndex();
                M[v.getIndex()] = Math.min(M[u.getIndex()], r);
                if (v != target) {
                    Q.push(v);
                    continue;
                }
                u = target;
                do {
                    path.addFirst(u);
                } while ((u = this.flowGraph.getNode(P[u.getIndex()])) != source);
                path.addFirst(u);
                return M[target.getIndex()];
            }
        }
        return 0.0;
    }
}

