/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.measure.ChartMeasure;
import org.graphstream.algorithm.measure.ChartSeries2DMeasure;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartMinMaxAverageSeriesMeasure
extends ChartSeries2DMeasure {
    protected String title;
    protected XYSeries min;
    protected XYSeries max;
    protected boolean separateMinMaxAxis;

    public ChartMinMaxAverageSeriesMeasure(String name) {
        super("avg");
        this.title = name;
        this.min = new XYSeries((Comparable)((Object)"min"));
        this.max = new XYSeries((Comparable)((Object)"max"));
        this.separateMinMaxAxis = true;
    }

    public void setSeparateMinMaxAxis(boolean on) {
        this.separateMinMaxAxis = on;
    }

    public boolean isSeparateMinMaxAxis() {
        return this.separateMinMaxAxis;
    }

    public void setWindowSize(int size) {
        super.setWindowSize(size);
        this.min.setMaximumItemCount(size);
        this.max.setMaximumItemCount(size);
    }

    public void addValue(double x, double min, double avg, double max) {
        this.addValue(x, avg);
        this.min.add(x, min);
        this.max.add(x, max);
    }

    public JFreeChart createChart(ChartMeasure.PlotParameters params) throws ChartMeasure.PlotException {
        XYSeriesCollection minMax = new XYSeriesCollection();
        XYSeriesCollection avgCol = new XYSeriesCollection();
        XYBarRenderer r = new XYBarRenderer();
        r.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        r.setMargin(0.35);
        minMax.addSeries(this.min);
        avgCol.addSeries(this.series);
        minMax.addSeries(this.max);
        JFreeChart chart = ChartFactory.createXYLineChart((String)params.title, (String)params.xAxisLabel, (String)params.yAxisLabel, (XYDataset)avgCol, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDataset(1, (XYDataset)minMax);
        plot.setRenderer(1, (XYItemRenderer)r);
        if (this.separateMinMaxAxis) {
            NumberAxis minMaxAxis = new NumberAxis("min/max");
            plot.setRangeAxis(1, (ValueAxis)minMaxAxis);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            plot.mapDatasetToRangeAxis(1, 1);
        }
        return chart;
    }

    public ChartMeasure.PlotParameters getDefaultPlotParameters() {
        ChartMeasure.PlotParameters params = new ChartMeasure.PlotParameters();
        params.title = this.title;
        params.xAxisLabel = "x";
        params.yAxisLabel = "average";
        return params;
    }
}

