/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.graphstream.algorithm.measure.ChartSeriesMeasure;

public class ChartSeries2DMeasure
extends ChartSeriesMeasure {
    protected DescriptiveStatistics xData = new DescriptiveStatistics();
    protected DescriptiveStatistics yData = new DescriptiveStatistics();

    public ChartSeries2DMeasure(String name) {
        super(name);
        this.xData.setWindowSize(100);
        this.yData.setWindowSize(100);
    }

    public void setWindowSize(int size) {
        super.setWindowSize(size);
        this.xData.setWindowSize(size);
        this.yData.setWindowSize(size);
    }

    public void addValue(double x, double y) {
        this.xData.addValue(x);
        this.yData.addValue(y);
        this.series.add(x, y);
    }

    public long getCount() {
        return this.xData.getN();
    }

    public double getXMean() {
        return this.xData.getMean();
    }

    public double getXMax() {
        return this.xData.getMax();
    }

    public double getXMin() {
        return this.xData.getMin();
    }

    public double getXVariance() {
        return this.xData.getVariance();
    }

    public double getYMean() {
        return this.yData.getMean();
    }

    public double getYMax() {
        return this.yData.getMax();
    }

    public double getYMin() {
        return this.yData.getMin();
    }

    public double getYVariance() {
        return this.yData.getVariance();
    }
}

