/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.HashSet;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.graphstream.algorithm.measure.CommunityMeasure;

public class CommunityDistribution
extends CommunityMeasure {
    protected Object biggestCommunity = null;
    protected Object smallestCommunity = null;
    protected float avgSize = 0.0f;
    protected float stdevSize = 0.0f;

    public CommunityDistribution(String marker) {
        super(marker);
    }

    public void compute() {
        if (this.graphChanged) {
            this.M = this.communities.size();
            int maxSize = 0;
            int minSize = Integer.MAX_VALUE;
            double[] distribution = new double[(int)this.M];
            int k = 0;
            Mean mean = new Mean();
            StandardDeviation stdev = new StandardDeviation();
            for (Object c : this.communities.keySet()) {
                distribution[k++] = ((HashSet)this.communities.get(c)).size();
                if (((HashSet)this.communities.get(c)).size() > maxSize) {
                    this.biggestCommunity = c;
                    maxSize = ((HashSet)this.communities.get(c)).size();
                }
                if (((HashSet)this.communities.get(c)).size() >= minSize) continue;
                this.smallestCommunity = c;
                minSize = ((HashSet)this.communities.get(c)).size();
            }
            this.avgSize = (float)mean.evaluate(distribution);
            this.stdevSize = (float)stdev.evaluate(distribution);
            this.graphChanged = false;
        }
    }

    public int number() {
        return (int)this.M;
    }

    public Object biggestCommunity() {
        return this.biggestCommunity;
    }

    public Object smallestCommunity() {
        return this.smallestCommunity;
    }

    public int maxCommunitySize() {
        if (this.communities.get(this.biggestCommunity) == null) {
            return 0;
        }
        return ((HashSet)this.communities.get(this.biggestCommunity)).size();
    }

    public int minCommunitySize() {
        if (this.communities.get(this.smallestCommunity) == null) {
            return 0;
        }
        return ((HashSet)this.communities.get(this.smallestCommunity)).size();
    }

    public float average() {
        return this.avgSize;
    }

    public float stdev() {
        return this.stdevSize;
    }

    public String toString() {
        this.compute();
        return (int)this.M + " " + this.avgSize + " " + this.stdevSize + " " + this.minCommunitySize() + " (" + this.smallestCommunity + ") " + this.maxCommunitySize() + " (" + this.biggestCommunity + ")";
    }
}

