/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.measure.ChartMinMaxAverageSeriesMeasure;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public class DegreeMeasure
extends ChartMinMaxAverageSeriesMeasure
implements DynamicAlgorithm {
    protected Graph g;
    private Sink trigger = new StepTrigger();

    public DegreeMeasure() {
        super("Degree");
    }

    public void terminate() {
        this.g.removeSink(this.trigger);
        this.g = null;
    }

    public void compute() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double avg = 0.0;
        for (Node n : this.g) {
            min = Math.min(min, (double)n.getDegree());
            max = Math.max(max, (double)n.getDegree());
            avg += (double)n.getDegree();
        }
        this.addValue(this.g.getStep(), min, avg /= (double)this.g.getNodeCount(), max);
    }

    public void init(Graph graph) {
        this.g = graph;
        this.g.addSink(this.trigger);
    }

    private class StepTrigger
    extends SinkAdapter {
        private StepTrigger() {
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            DegreeMeasure.this.compute();
        }
    }
}

