/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.HashSet;
import org.graphstream.algorithm.measure.CommunityRelativeMeasure;
import org.graphstream.graph.Node;

public class NormalizedMutualInformation
extends CommunityRelativeMeasure {
    public NormalizedMutualInformation(String marker) {
        super(marker);
    }

    public NormalizedMutualInformation(String marker, String referenceMarker) {
        super(marker, referenceMarker);
    }

    public void compute() {
        if (this.graphChanged) {
            int j;
            int i;
            int ttl;
            int[][] N2 = this.confusionMatrix();
            int[] N_A = new int[this.referenceCommunities.size()];
            int[] N_B = new int[this.communities.size()];
            for (int i2 = 0; i2 < N_A.length; ++i2) {
                ttl = 0;
                for (int j2 = 0; j2 < N_B.length; ++j2) {
                    ttl += N2[i2][j2];
                }
                N_A[i2] = ttl;
            }
            for (int j3 = 0; j3 < N_B.length; ++j3) {
                ttl = 0;
                for (i = 0; i < N_A.length; ++i) {
                    ttl += N2[i][j3];
                }
                N_B[j3] = ttl;
            }
            float n = this.graph.getNodeCount();
            float num = 0.0f;
            for (i = 0; i < N_A.length; ++i) {
                for (j = 0; j < N_B.length; ++j) {
                    if (N2[i][j] <= 0) continue;
                    num = (float)((double)num + -2.0 * (double)N2[i][j] * Math.log((float)N2[i][j] * n / (float)(N_A[i] * N_B[j])));
                }
            }
            float denom = 0.0f;
            for (int i3 = 0; i3 < N_A.length; ++i3) {
                denom = (float)((double)denom + (double)N_A[i3] * Math.log((float)N_A[i3] / n));
            }
            for (j = 0; j < N_B.length; ++j) {
                denom = (float)((double)denom + (double)N_B[j] * Math.log((float)N_B[j] / n));
            }
            this.M = num / denom;
            this.graphChanged = false;
        }
    }

    protected int[][] confusionMatrix() {
        int c_A = this.referenceCommunities.size();
        int c_B = this.communities.size();
        int[][] N2 = new int[c_A][];
        Object[] keys_A = new Object[c_A];
        Object[] keys_B = new Object[c_B];
        int k_A = 0;
        for (Object key : this.referenceCommunities.keySet()) {
            keys_A[k_A++] = key;
        }
        int k_B = 0;
        for (Object key : this.communities.keySet()) {
            keys_B[k_B++] = key;
        }
        for (int i = 0; i < c_A; ++i) {
            N2[i] = new int[c_B];
            for (int j = 0; j < c_B; ++j) {
                int commonNodes = 0;
                for (Node n : (HashSet)this.communities.get(keys_B[j])) {
                    if (!((HashSet)this.referenceCommunities.get(keys_A[i])).contains(n)) continue;
                    ++commonNodes;
                }
                N2[i][j] = commonNodes;
            }
        }
        return N2;
    }
}

