/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.networksimplex;

class BigMNumber {
    protected long small;
    protected long big;

    public BigMNumber() {
        this.set(0L, 0L);
    }

    public BigMNumber(long small) {
        this.set(small, 0L);
    }

    public void set(long small, long big) {
        this.small = small;
        this.big = big;
    }

    public void set(BigMNumber b) {
        this.set(b.small, b.big);
    }

    public void set(long small) {
        this.set(small, 0L);
    }

    public void plus(BigMNumber b) {
        this.small += b.small;
        this.big += b.big;
    }

    public void minus(BigMNumber b) {
        this.small -= b.small;
        this.big -= b.big;
    }

    public void minus() {
        this.small = -this.small;
        this.big = -this.big;
    }

    public void plusTimes(int multiplier, BigMNumber b) {
        this.small += (long)multiplier * b.small;
        this.big += (long)multiplier * b.big;
    }

    public boolean isNegative() {
        return this.big < 0L || this.big == 0L && this.small < 0L;
    }

    public boolean isInfinite() {
        return this.big != 0L;
    }

    public int compareTo(BigMNumber b) {
        if (this.big < b.big) {
            return -1;
        }
        if (this.big > b.big) {
            return 1;
        }
        if (this.small < b.small) {
            return -1;
        }
        if (this.small > b.small) {
            return 1;
        }
        return 0;
    }

    public long getSmall() {
        return this.small;
    }

    public String toString() {
        if (this.big == 0L) {
            return this.small + "";
        }
        String r = "";
        if (this.small != 0L) {
            r = r + this.small;
            if (this.big > 0L) {
                r = r + "+";
            }
        }
        if (this.big == -1L) {
            r = r + "-";
        } else if (this.big != 1L) {
            r = r + this.big;
        }
        r = r + "M";
        return r;
    }
}

