/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.PipeBase;
import org.graphstream.stream.Sink;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.layout.Layout;
import org.miv.pherd.geom.Vector3;

public class Eades84Layout
extends PipeBase
implements Layout {
    boolean is3D = false;
    double c1 = 2.0;
    double c2 = 1.0;
    double c3 = 2.0;
    double c4 = 0.5;
    double M = 100.0;
    HashMap<String, Spring> springs = new HashMap();
    HashMap<String, EadesParticle> particles = new HashMap();
    Random random = new Random();
    int nodeMoved = 0;
    double stabilization = 0.0;
    Point3 high = new Point3(1.0, 1.0, 1.0);
    Point3 low = new Point3(-1.0, -1.0, -1.0);

    public String getLayoutAlgorithmName() {
        return "Eades1984";
    }

    public int getNodeMovedCount() {
        return this.nodeMoved;
    }

    public double getStabilization() {
        return this.stabilization;
    }

    public double getStabilizationLimit() {
        return this.M;
    }

    public void setStabilizationLimit(double l) {
        this.M = l;
    }

    public Point3 getLowPoint() {
        return this.low;
    }

    public Point3 getHiPoint() {
        return this.high;
    }

    public int getSteps() {
        return 0;
    }

    public long getLastStepTime() {
        return 0L;
    }

    public double getQuality() {
        return 0.0;
    }

    public double getForce() {
        return 0.0;
    }

    public void clear() {
    }

    public void setForce(double value) {
    }

    public void setQuality(double qualityLevel) {
    }

    public void setSendNodeInfos(boolean send) {
    }

    public void shake() {
    }

    public void moveNode(String id, double x, double y, double z) {
    }

    public void freezeNode(String id, boolean frozen) {
    }

    public void compute() {
        this.nodeMoved = 0;
        for (Spring s : this.springs.values()) {
            s.computeForce();
        }
        for (EadesParticle p : this.particles.values()) {
            p.step();
        }
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        double maxx = Double.MIN_VALUE;
        for (EadesParticle p : this.particles.values()) {
            p.commit();
            if (p.getEnergy() > 0.0) {
                this.particleMoved(p.id, p.pos.x, p.pos.y, p.pos.z);
            }
            minx = Math.min(minx, p.pos.x);
            miny = Math.min(miny, p.pos.y);
            minz = Math.min(minz, p.pos.z);
            maxx = Math.max(minx, p.pos.x);
            maxy = Math.max(miny, p.pos.y);
            maxz = Math.max(minz, p.pos.z);
        }
        this.high.x = maxx;
        this.high.y = maxy;
        this.high.z = maxz;
        this.low.x = minx;
        this.low.y = miny;
        this.low.z = minz;
        this.stabilization += 1.0;
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.particles.put(nodeId, this.getNewParticle(nodeId));
        this.stabilization = 0.0;
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.particles.remove(nodeId);
        this.stabilization = 0.0;
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        EadesParticle p1 = this.particles.get(fromNodeId);
        EadesParticle p2 = this.particles.get(toNodeId);
        Spring spring = this.getNewSpring(p1, p2);
        this.springs.put(edgeId, spring);
        p1.springs.put(p2, spring);
        p2.springs.put(p1, spring);
        this.stabilization = 0.0;
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        Spring s = this.springs.remove(edgeId);
        if (s != null) {
            s.p1.springs.remove(s.p2);
            s.p2.springs.remove(s.p1);
            this.stabilization = 0.0;
        }
    }

    public void inputPos(String filename) throws IOException {
        throw new RuntimeException("unhandle feature");
    }

    public void outputPos(String filename) throws IOException {
        throw new RuntimeException("unhandle feature");
    }

    public void particleMoved(Object id, double x, double y, double z) {
        Object[] xyz = new Object[]{x, y, z};
        this.sendNodeAttributeChanged(this.getLayoutAlgorithmName(), (String)id, "xyz", xyz, xyz);
    }

    protected EadesParticle getNewParticle(String id) {
        return new EadesParticle(id);
    }

    protected Spring getNewSpring(EadesParticle p1, EadesParticle p2) {
        return new Spring(p1, p2);
    }

    public static void main(String ... args) {
        DefaultGraph g = new DefaultGraph("g");
        BarabasiAlbertGenerator gen = new BarabasiAlbertGenerator();
        Eades84Layout layout = new Eades84Layout();
        int size = 30;
        gen.addSink((Sink)g);
        g.addSink((Sink)layout);
        layout.addAttributeSink((AttributeSink)g);
        g.display(false);
        gen.begin();
        while (size-- > 0) {
            gen.nextEvents();
        }
        gen.end();
        while (true) {
            layout.compute();
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
            }
        }
    }

    protected class EadesParticle {
        HashMap<EadesParticle, Spring> springs;
        Vector3 dir;
        Vector3 sum;
        Point3 pos;
        String id;

        public EadesParticle(String id) {
            this.id = id;
            this.springs = new HashMap();
            this.dir = new Vector3();
            this.sum = new Vector3();
            this.pos = new Point3();
            this.pos.x = Eades84Layout.this.random.nextDouble() * (Eades84Layout.this.high.x - Eades84Layout.this.low.x) + Eades84Layout.this.low.x;
            this.pos.y = Eades84Layout.this.random.nextDouble() * (Eades84Layout.this.high.y - Eades84Layout.this.low.y) + Eades84Layout.this.low.y;
            if (Eades84Layout.this.is3D) {
                this.pos.z = Eades84Layout.this.random.nextDouble() * (Eades84Layout.this.high.z - Eades84Layout.this.low.z) + Eades84Layout.this.low.z;
            }
        }

        public void step() {
            Vector3 v = new Vector3();
            this.dir.fill(0.0);
            this.sum.fill(0.0);
            for (Spring s : this.springs.values()) {
                s.set(this, v);
                this.sum.add(v);
            }
            for (EadesParticle p : Eades84Layout.this.particles.values()) {
                if (this.springs.containsKey(p) || p == this) continue;
                double d = this.d(p);
                double f = Double.isNaN(d) ? Eades84Layout.this.c3 : Eades84Layout.this.c3 / Math.sqrt(d);
                v.set(Math.signum(this.getPosition().x - p.getPosition().x), Math.signum(this.getPosition().y - p.getPosition().y), Math.signum(this.getPosition().z - p.getPosition().z));
                v.scalarMult(f);
                this.sum.add(v);
            }
            this.dir.add(this.sum);
            this.dir.scalarMult(Eades84Layout.this.c4);
            assert (!Double.isNaN(this.dir.data[0]) && !Double.isNaN(this.dir.data[1]));
        }

        public double getEnergy() {
            return this.dir.length();
        }

        public void commit() {
            this.pos.x += this.dir.data[0];
            this.pos.y += this.dir.data[1];
            assert (!Double.isNaN(this.pos.x) && !Double.isNaN(this.pos.y));
            if (Eades84Layout.this.is3D) {
                this.pos.z += this.dir.data[2];
            }
            ++Eades84Layout.this.nodeMoved;
        }

        protected double d(EadesParticle p) {
            return this.getPosition().distance(p.getPosition());
        }

        public Point3 getPosition() {
            return this.pos;
        }
    }

    protected class Spring {
        EadesParticle p1;
        EadesParticle p2;
        double force;

        Spring(EadesParticle p1, EadesParticle p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        void computeForce() {
            double d = this.p1.d(this.p2);
            this.force = Eades84Layout.this.c1 * Math.log(d / Eades84Layout.this.c2);
        }

        void set(EadesParticle p, Vector3 v) {
            v.set(Math.signum(this.p2.getPosition().x - this.p1.getPosition().x), Math.signum(this.p2.getPosition().y - this.p1.getPosition().y), Math.signum(this.p2.getPosition().z - this.p1.getPosition().z));
            if (p == this.p2) {
                v.scalarMult(-1.0);
            }
            v.scalarMult(this.force);
        }
    }
}

