/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.PipeBase;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.swingViewer.Viewer;

public class HierarchicalLayout
extends PipeBase
implements Layout {
    final HashMap<String, Position> nodesPosition;
    final LinkedList<String> roots = new LinkedList();
    final Graph internalGraph;
    boolean structureChanged;
    Rendering renderingType;
    Point3 hi;
    Point3 lo;
    long lastStep;
    int nodeMoved;

    public HierarchicalLayout() {
        this.nodesPosition = new HashMap();
        this.internalGraph = new AdjacencyListGraph("hierarchical_layout-intern");
        this.hi = new Point3();
        this.lo = new Point3();
    }

    public void setRoots(String ... rootsId) {
        this.roots.clear();
        if (rootsId != null) {
            for (String id : rootsId) {
                this.roots.add(id);
            }
        }
    }

    public void clear() {
    }

    public void compute() {
        this.nodeMoved = 0;
        if (this.structureChanged) {
            this.computePositions();
        }
        this.publishPositions();
        this.lastStep = System.currentTimeMillis();
    }

    protected void computePositions() {
        LinkedList<String> currentLevel = new LinkedList<String>();
        LinkedList<String> nextLevel = new LinkedList<String>();
        HashSet<Node> visited = new HashSet<Node>();
        int level = 0;
        int order = 0;
        int[] levels = new int[]{};
        currentLevel.addAll(this.roots);
        while (currentLevel.size() > 0) {
            for (order = 0; order < currentLevel.size(); ++order) {
                Node n = this.internalGraph.getNode((String)currentLevel.get(order));
                Position p = this.nodesPosition.get(n.getId());
                visited.add(n);
                if (p.level != level || p.order != order) {
                    p.level = level;
                    p.order = order;
                    p.changed = true;
                }
                for (int i = 0; i < n.getOutDegree(); ++i) {
                    Edge e = n.getLeavingEdge(i);
                    Node o = e.getOpposite(n);
                    if (visited.contains(o) || currentLevel.contains(o.getId()) || nextLevel.contains(o)) continue;
                    Position op = this.nodesPosition.get(o.getId());
                    op.parent = n.getId();
                    nextLevel.add(o.getId());
                }
            }
            ++level;
        }
        for (Position p : this.nodesPosition.values()) {
            if (p.level > levels.length) {
                levels = Arrays.copyOf(levels, p.level);
            }
            levels[p.level] = Math.max(p.order, levels[p.level]);
        }
        this.hi.y = Double.MIN_VALUE;
        this.hi.x = Double.MIN_VALUE;
        this.lo.y = Double.MAX_VALUE;
        this.lo.x = Double.MAX_VALUE;
        for (Node n : this.internalGraph) {
            Position p = this.nodesPosition.get(n.getId());
            if (p == null) continue;
            if (p.changed) {
                p.changed = false;
                ++this.nodeMoved;
                double r = this.roots.size() > 1 ? (double)(p.level + 1) : (double)p.level;
                double d = (double)(p.order * 2) * Math.PI / (double)(levels[p.level] + 1);
                p.x = r * Math.cos(d);
                p.y = r * Math.sin(d);
            }
            this.hi.x = Math.max(this.hi.x, p.x);
            this.hi.y = Math.max(this.hi.y, p.y);
            this.lo.x = Math.min(this.lo.x, p.x);
            this.lo.y = Math.min(this.lo.y, p.y);
        }
    }

    protected void publishPositions() {
        for (Node n : this.internalGraph) {
            Position p = this.nodesPosition.get(n.getId());
            if (p == null || !p.changed) continue;
            p.changed = false;
            this.sendNodeAttributeChanged(this.sourceId, n.getId(), "xyz", null, new double[]{p.x, p.y, 0.0});
        }
    }

    public void freezeNode(String id, boolean frozen) {
    }

    public double getForce() {
        return 0.0;
    }

    public Point3 getHiPoint() {
        return this.hi;
    }

    public long getLastStepTime() {
        return this.lastStep;
    }

    public String getLayoutAlgorithmName() {
        return "Hierarchical";
    }

    public Point3 getLowPoint() {
        return this.lo;
    }

    public int getNodeMovedCount() {
        return this.nodeMoved;
    }

    public double getQuality() {
        return 0.0;
    }

    public double getStabilization() {
        return 1.0 - (double)this.nodeMoved / (double)this.internalGraph.getNodeCount();
    }

    public double getStabilizationLimit() {
        return 1.0;
    }

    public int getSteps() {
        return 0;
    }

    public void inputPos(String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void moveNode(String id, double x, double y, double z) {
    }

    public void outputPos(String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setForce(double value) {
    }

    public void setQuality(double qualityLevel) {
    }

    public void setSendNodeInfos(boolean send) {
    }

    public void setStabilizationLimit(double value) {
    }

    public void shake() {
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.internalGraph.addNode(nodeId);
        this.structureChanged = true;
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.internalGraph.removeNode(nodeId);
        this.structureChanged = true;
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromId, String toId, boolean directed) {
        this.internalGraph.addEdge(edgeId, fromId, toId, directed);
        this.structureChanged = true;
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.internalGraph.removeEdge(edgeId);
        this.structureChanged = true;
    }

    public void graphCleared(String sourceId, long timeId) {
        this.internalGraph.clear();
        this.structureChanged = true;
    }

    public static void main(String ... args) {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        g.addNode("root");
        g.addNode("0");
        g.addNode("1");
        g.addNode("2");
        g.addNode("0-0");
        g.addNode("0-1");
        g.addNode("1-0");
        g.addNode("1-1");
        g.addNode("1-2");
        g.addNode("2-0");
        Viewer v = g.display(false);
        v.enableAutoLayout((Layout)new HierarchicalLayout());
    }

    static class Position {
        int level;
        int order;
        String parent;
        boolean changed;
        double x;
        double y;

        Position(int level, int order) {
            this.level = level;
            this.order = order;
            this.changed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rendering {
        UP_TO_DOWN,
        DOWN_TO_UP,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        DISK;

    }
}

