/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.AlgorithmComputationTrigger;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.measure.ChartMeasure;
import org.graphstream.algorithm.measure.ChartSeries2DMeasure;
import org.graphstream.algorithm.measure.ConnectivityMeasure;
import org.graphstream.graph.Graph;
import org.graphstream.stream.Sink;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartConnectivityMeasure
extends ChartMeasure
implements DynamicAlgorithm {
    protected ChartVertexConnectivityMeasure vertexConnectivity;
    protected ChartEdgeConnectivityMeasure edgeConnectivity;

    public ChartConnectivityMeasure() {
        this(new ChartVertexConnectivityMeasure(), new ChartEdgeConnectivityMeasure());
    }

    public ChartConnectivityMeasure(ChartVertexConnectivityMeasure vertexConnectivity, ChartEdgeConnectivityMeasure edgeConnectivity) {
        super("connectivity");
        this.vertexConnectivity = vertexConnectivity;
        this.edgeConnectivity = edgeConnectivity;
    }

    public ChartVertexConnectivityMeasure getVertexConnectivityMeasure() {
        return this.vertexConnectivity;
    }

    public ChartEdgeConnectivityMeasure getEdgeConnectivityMeasure() {
        return this.edgeConnectivity;
    }

    @Override
    public void terminate() {
        this.vertexConnectivity.terminate();
        this.edgeConnectivity.terminate();
    }

    @Override
    public void compute() {
    }

    @Override
    public void init(Graph graph) {
        this.vertexConnectivity.init(graph);
        this.edgeConnectivity.init(graph);
    }

    @Override
    public JFreeChart createChart(ChartMeasure.PlotParameters params) throws ChartMeasure.PlotException {
        JFreeChart chart;
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(this.vertexConnectivity.getXYSeries());
        dataset.addSeries(this.edgeConnectivity.getXYSeries());
        switch (params.type) {
            case LINE: {
                chart = ChartFactory.createXYLineChart((String)params.title, (String)params.xAxisLabel, (String)params.yAxisLabel, (XYDataset)dataset, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)false, (boolean)false);
                break;
            }
            case BAR: {
                chart = ChartFactory.createXYBarChart((String)params.title, (String)params.xAxisLabel, (boolean)false, (String)params.yAxisLabel, (IntervalXYDataset)dataset, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)false, (boolean)false);
                break;
            }
            case SCATTER: {
                chart = ChartFactory.createScatterPlot((String)params.title, (String)params.xAxisLabel, (String)params.yAxisLabel, (XYDataset)dataset, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)false, (boolean)false);
                break;
            }
            default: {
                throw new ChartMeasure.PlotException("unsupported plot type");
            }
        }
        return chart;
    }

    @Override
    public void plot(ChartMeasure.PlotParameters params) throws ChartMeasure.PlotException {
        ChartConnectivityMeasure.outputPlot(params, this.createChart(params));
    }

    @Override
    public ChartMeasure.PlotParameters getDefaultPlotParameters() {
        ChartMeasure.PlotParameters params = new ChartMeasure.PlotParameters();
        params.title = this.name;
        params.type = ChartMeasure.PlotType.LINE;
        params.xAxisLabel = "steps";
        params.yAxisLabel = "connectivity";
        return params;
    }

    public static class ChartEdgeConnectivityMeasure
    extends ChartSeries2DMeasure
    implements DynamicAlgorithm {
        Graph g;
        Sink trigger = new AlgorithmComputationTrigger(AlgorithmComputationTrigger.Mode.BY_STEP, this);

        public ChartEdgeConnectivityMeasure() {
            super("edge-connectivity");
        }

        @Override
        public void terminate() {
            this.g.removeSink(this.trigger);
            this.g = null;
        }

        @Override
        public void compute() {
            this.addValue(this.g.getStep(), ConnectivityMeasure.getEdgeConnectivity(this.g));
        }

        @Override
        public void init(Graph graph) {
            this.g = graph;
            this.g.addSink(this.trigger);
        }
    }

    public static class ChartVertexConnectivityMeasure
    extends ChartSeries2DMeasure
    implements DynamicAlgorithm {
        Graph g;
        Sink trigger = new AlgorithmComputationTrigger(AlgorithmComputationTrigger.Mode.BY_STEP, this);

        public ChartVertexConnectivityMeasure() {
            super("vertex-connectivity");
        }

        @Override
        public void terminate() {
            this.g.removeSink(this.trigger);
            this.g = null;
        }

        @Override
        public void compute() {
            this.addValue(this.g.getStep(), ConnectivityMeasure.getVertexConnectivity(this.g));
        }

        @Override
        public void init(Graph graph) {
            this.g = graph;
            this.g.addSink(this.trigger);
        }
    }
}

