/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.networksimplex;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.networksimplex.BigMNumber;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public class NetworkSimplex
extends SinkAdapter
implements DynamicAlgorithm {
    public static final String PREFIX = "__NS_";
    protected static final int INFINITE_CAPACITY = -1;
    protected String supplyName;
    protected String capacityName;
    protected String costName;
    protected PricingStrategy pricingStrategy = PricingStrategy.MOST_NEGATIVE;
    protected Graph graph;
    protected Map<String, NSNode> nodes;
    protected Map<String, NSArc> arcs;
    protected Set<NSArc> nonBasicArcs;
    protected NSNode root;
    protected BigMNumber objectiveValue;
    protected SolutionStatus solutionStatus = SolutionStatus.UNDEFINED;
    protected NSArc enteringArc;
    protected NSNode join;
    protected NSNode first;
    protected NSNode second;
    protected NSNode oldSubtreeRoot;
    protected NSNode newSubtreeRoot;
    protected BigMNumber cycleFlowChange;
    protected NSArc leavingArc;
    protected BigMNumber work1;
    protected BigMNumber work2;
    protected long animationDelay = 0L;
    protected boolean fromSink = false;
    protected int logFreq = 0;
    protected PrintStream log = System.err;

    public NetworkSimplex(String supplyName, String capaciyName, String costName) {
        this.supplyName = supplyName;
        this.capacityName = capaciyName;
        this.costName = costName;
        this.objectiveValue = new BigMNumber();
        this.cycleFlowChange = new BigMNumber();
        this.work1 = new BigMNumber();
        this.work2 = new BigMNumber();
    }

    protected void cloneGraph() {
        this.nodes = new HashMap<String, NSNode>(4 * this.graph.getNodeCount() / 3 + 2);
        for (Node node : this.graph) {
            NSNode copy = new NSNode(node);
            this.nodes.put(copy.id, copy);
        }
        int arcCount = this.graph.getEdgeCount();
        for (Edge edge : this.graph.getEachEdge()) {
            if (edge.isDirected()) continue;
            ++arcCount;
        }
        this.arcs = new HashMap<String, NSArc>(4 * arcCount / 3 + 1);
        for (Edge edge : this.graph.getEachEdge()) {
            NSArc copy = new NSArc(edge, true);
            this.arcs.put(copy.id, copy);
            if (edge.isDirected()) continue;
            copy = new NSArc(edge, false);
            this.arcs.put(copy.id, copy);
        }
    }

    protected void createInitialBFS() {
        this.nonBasicArcs = new HashSet<NSArc>(4 * this.arcs.size() / 3 + 1);
        for (NSArc arc : this.arcs.values()) {
            arc.flow = 0;
            arc.status = ArcStatus.NONBASIC_LOWER;
            this.nonBasicArcs.add(arc);
            if (this.animationDelay <= 0L) continue;
            arc.setUIClass();
        }
        this.root = new NSNode();
        this.root.id = "__NS_ROOT";
        this.root.potential.set(0L);
        this.root.parent = this.root;
        this.root.thread = this.root;
        this.root.depth = 0;
        this.root.supply = 0;
        this.root.artificialArc = null;
        this.objectiveValue.set(0L);
        for (NSNode node : this.nodes.values()) {
            node.createArtificialArc();
        }
        this.solutionStatus = SolutionStatus.UNDEFINED;
    }

    protected void selectEnteringArcFirstNegative() {
        this.enteringArc = null;
        BigMNumber reducedCost = this.work1;
        for (NSArc arc : this.nonBasicArcs) {
            arc.computeReducedCost(reducedCost);
            if (!reducedCost.isNegative()) continue;
            this.enteringArc = arc;
            return;
        }
        if (!this.objectiveValue.isInfinite()) {
            return;
        }
        for (NSNode node : this.nodes.values()) {
            NSArc arc = node.artificialArc;
            if (arc.status != ArcStatus.NONBASIC_LOWER) continue;
            arc.computeReducedCost(reducedCost);
            if (!reducedCost.isNegative()) continue;
            this.enteringArc = arc;
            return;
        }
    }

    protected void selectEnteringArcMostNegative() {
        this.enteringArc = null;
        BigMNumber reducedCost = this.work1;
        BigMNumber bestReducedCost = this.work2;
        bestReducedCost.set(0L);
        for (NSArc arc : this.nonBasicArcs) {
            arc.computeReducedCost(reducedCost);
            if (reducedCost.compareTo(bestReducedCost) >= 0) continue;
            bestReducedCost.set(reducedCost);
            this.enteringArc = arc;
        }
        if (this.enteringArc != null) {
            return;
        }
        if (!this.objectiveValue.isInfinite()) {
            return;
        }
        for (NSNode node : this.nodes.values()) {
            NSArc arc = node.artificialArc;
            if (arc.status != ArcStatus.NONBASIC_LOWER) continue;
            arc.computeReducedCost(reducedCost);
            if (reducedCost.compareTo(bestReducedCost) >= 0) continue;
            bestReducedCost = reducedCost;
            this.enteringArc = arc;
        }
    }

    protected void selectEnteringArc() {
        switch (this.pricingStrategy) {
            case FIRST_NEGATIVE: {
                this.selectEnteringArcFirstNegative();
                break;
            }
            case MOST_NEGATIVE: {
                this.selectEnteringArcMostNegative();
            }
        }
    }

    protected void findJoinNode() {
        NSNode i = this.enteringArc.source;
        NSNode j = this.enteringArc.target;
        while (i.depth > j.depth) {
            i = i.parent;
        }
        while (j.depth > i.depth) {
            j = j.parent;
        }
        while (i != j) {
            i = i.parent;
            j = j.parent;
        }
        this.join = i;
    }

    protected void selectLeavingArc() {
        NSArc arc;
        this.findJoinNode();
        if (this.enteringArc.status == ArcStatus.NONBASIC_LOWER) {
            this.first = this.enteringArc.source;
            this.second = this.enteringArc.target;
        } else {
            this.first = this.enteringArc.target;
            this.second = this.enteringArc.source;
        }
        this.enteringArc.computeAllowedFlowChange(this.first, this.cycleFlowChange);
        this.leavingArc = this.enteringArc;
        BigMNumber arcFlowChange = this.work1;
        NSNode node = this.second;
        while (node != this.join) {
            arc = node.arcToParent;
            arc.computeAllowedFlowChange(node, arcFlowChange);
            if (arcFlowChange.compareTo(this.cycleFlowChange) <= 0) {
                this.cycleFlowChange.set(arcFlowChange);
                this.oldSubtreeRoot = node;
                this.newSubtreeRoot = this.second;
                this.leavingArc = arc;
            }
            node = node.parent;
        }
        node = this.first;
        while (node != this.join) {
            arc = node.arcToParent;
            arc.computeAllowedFlowChange(node.parent, arcFlowChange);
            if (arcFlowChange.compareTo(this.cycleFlowChange) < 0) {
                this.cycleFlowChange.set(arcFlowChange);
                this.oldSubtreeRoot = node;
                this.newSubtreeRoot = this.first;
                this.leavingArc = arc;
            }
            node = node.parent;
        }
    }

    protected void changeFlows() {
        int delta = (int)this.cycleFlowChange.getSmall();
        if (delta == 0) {
            return;
        }
        this.enteringArc.computeReducedCost(this.work1);
        this.objectiveValue.plusTimes(delta, this.work1);
        this.enteringArc.changeFlow(delta, this.first);
        NSNode node = this.second;
        while (node != this.join) {
            node.arcToParent.changeFlow(delta, node);
            node = node.parent;
        }
        node = this.first;
        while (node != this.join) {
            node.arcToParent.changeFlow(delta, node.parent);
            node = node.parent;
        }
    }

    protected void updateBFS() {
        NSNode stopNode = this.oldSubtreeRoot.parent;
        NSNode currentNode = this.newSubtreeRoot;
        NSNode oldParent = currentNode.parent;
        NSNode newParent = this.enteringArc.getOpposite(currentNode);
        NSArc oldArc = currentNode.arcToParent;
        NSArc newArc = this.enteringArc;
        while (currentNode != stopNode) {
            currentNode.changeParent(newParent, newArc);
            newParent = currentNode;
            currentNode = oldParent;
            oldParent = currentNode.parent;
            newArc = oldArc;
            oldArc = currentNode.arcToParent;
        }
    }

    protected void pivot() {
        if (this.animationDelay > 0L && !this.fromSink) {
            try {
                Thread.sleep(this.animationDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.changeFlows();
        if (this.enteringArc == this.leavingArc) {
            this.enteringArc.status = this.enteringArc.status == ArcStatus.NONBASIC_LOWER ? ArcStatus.NONBASIC_UPPER : ArcStatus.NONBASIC_LOWER;
        } else {
            this.enteringArc.status = ArcStatus.BASIC;
            this.nonBasicArcs.remove(this.enteringArc);
            this.leavingArc.status = this.newSubtreeRoot == this.first && this.oldSubtreeRoot == this.leavingArc.target || this.newSubtreeRoot == this.second && this.oldSubtreeRoot == this.leavingArc.source ? ArcStatus.NONBASIC_UPPER : ArcStatus.NONBASIC_LOWER;
            if (!this.leavingArc.isArtificial()) {
                this.nonBasicArcs.add(this.leavingArc);
            }
            this.updateBFS();
        }
        if (this.animationDelay > 0L) {
            this.enteringArc.setUIClass();
            this.leavingArc.setUIClass();
        }
    }

    protected void simplex() {
        int pivots = 0;
        if (this.logFreq > 0) {
            this.log.println("Starting simplex...");
            this.log.printf("%10s%30s%30s%10s%10s%10s%n", "pivot", "entering", "leaving", "delta", "cost", "infeas.");
        }
        while (true) {
            this.selectEnteringArc();
            if (this.enteringArc == null) {
                if (this.objectiveValue.isInfinite()) {
                    this.solutionStatus = SolutionStatus.INFEASIBLE;
                    break;
                }
                this.solutionStatus = SolutionStatus.OPTIMAL;
                break;
            }
            this.selectLeavingArc();
            if (this.cycleFlowChange.isInfinite()) {
                this.solutionStatus = SolutionStatus.UNBOUNDED;
                break;
            }
            this.pivot();
            if (this.logFreq <= 0 || ++pivots % this.logFreq != 0) continue;
            this.log.printf("%10d%30s%30s%10d%10d%10d%n", pivots, this.enteringArc.id, this.leavingArc.id, this.cycleFlowChange.small, this.objectiveValue.small, this.objectiveValue.big);
        }
        if (this.logFreq > 0) {
            this.log.printf("Simplex finished (%d pivots). Cost: %d. Status: %s%n%n", new Object[]{pivots, this.objectiveValue.small, this.solutionStatus});
        }
    }

    public String getSupplyName() {
        return this.supplyName;
    }

    public String getCapacityName() {
        return this.capacityName;
    }

    public String getCostName() {
        return this.costName;
    }

    public PricingStrategy getPricingStrategy() {
        return this.pricingStrategy;
    }

    public void setPricingStrategy(PricingStrategy pricingStrategy) {
        this.pricingStrategy = pricingStrategy;
    }

    public void setAnimationDelay(long millis) {
        this.animationDelay = millis;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setLogFrequency(int pivots) {
        this.logFreq = pivots;
    }

    public void setLogStream(PrintStream log) {
        this.log = log;
    }

    public int getNetworkBalance() {
        return -this.root.supply;
    }

    public SolutionStatus getSolutionStatus() {
        return this.solutionStatus;
    }

    public long getSolutionCost() {
        return this.objectiveValue.getSmall();
    }

    public long getSolutionInfeasibility() {
        return this.objectiveValue.big;
    }

    public int getInfeasibility(Node node) {
        NSArc artificial = this.nodes.get((Object)node.getId()).artificialArc;
        return artificial.target == this.root ? artificial.flow : -artificial.flow;
    }

    public <T extends Edge> T getEdgeFromParent(Node node) {
        NSArc arc = this.nodes.get((Object)node.getId()).arcToParent;
        if (arc.isArtificial()) {
            return null;
        }
        return (T)this.graph.getEdge(arc.getOriginalId());
    }

    public <T extends Node> T getParent(Node node) {
        NSNode nsNode = this.nodes.get(node.getId());
        if (nsNode == this.root) {
            return null;
        }
        return (T)this.graph.getNode(nsNode.parent.id);
    }

    public int getFlow(Edge edge, boolean sameDirection) {
        if (edge.isDirected()) {
            return sameDirection ? this.arcs.get((Object)edge.getId()).flow : 0;
        }
        return this.arcs.get((Object)new StringBuilder().append((String)(sameDirection ? "" : "__NS_REVERSE_")).append((String)edge.getId()).toString()).flow;
    }

    public int getFlow(Edge edge) {
        return this.getFlow(edge, true);
    }

    public ArcStatus getStatus(Edge edge, boolean sameDirection) {
        if (edge.isDirected()) {
            return sameDirection ? this.arcs.get((Object)edge.getId()).status : null;
        }
        return this.arcs.get((Object)new StringBuilder().append((String)(sameDirection ? "" : "__NS_REVERSE_")).append((String)edge.getId()).toString()).status;
    }

    public ArcStatus getStatus(Edge edge) {
        return this.getStatus(edge, true);
    }

    public void setUIClasses() {
        for (Node node : this.graph) {
            this.nodes.get((Object)node.getId()).artificialArc.setUIClass();
        }
        for (Edge edge : this.graph.getEachEdge()) {
            NSArc arc = this.arcs.get(edge.getId());
            if (!edge.isDirected() && arc.status != ArcStatus.BASIC) {
                arc = this.arcs.get("__NS_REVERSE_" + edge.getId());
            }
            arc.setUIClass();
        }
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
        this.cloneGraph();
        this.createInitialBFS();
        graph.addSink((Sink)this);
    }

    @Override
    public void compute() {
        this.fromSink = false;
        if (this.solutionStatus == SolutionStatus.UNDEFINED) {
            this.simplex();
        }
    }

    @Override
    public void terminate() {
        this.graph.removeSink((Sink)this);
        this.solutionStatus = SolutionStatus.UNDEFINED;
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (attribute.equals(this.costName)) {
            double v = NetworkSimplex.objectToDouble(value);
            if (Double.isNaN(v)) {
                v = 1.0;
            }
            NSArc arc = this.arcs.get(edgeId);
            this.work1.set((int)v);
            this.changeCost(arc, this.work1);
            arc = this.arcs.get("__NS_REVERSE_" + edgeId);
            if (arc != null) {
                this.work1.set((int)v);
                this.changeCost(arc, this.work1);
            }
        } else if (attribute.equals(this.capacityName)) {
            double v = NetworkSimplex.objectToDouble(value);
            if (Double.isNaN(v) || v < 0.0) {
                v = -1.0;
            }
            NSArc arc = this.arcs.get(edgeId);
            this.changeCapacity(arc, (int)v);
            arc = this.arcs.get("__NS_REVERSE_" + edgeId);
            if (arc != null) {
                this.changeCapacity(arc, (int)v);
            }
        }
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, newValue);
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, null);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        if (attribute.equals(this.supplyName)) {
            double v = NetworkSimplex.objectToDouble(value);
            if (Double.isNaN(v)) {
                v = 0.0;
            }
            NSNode node = this.nodes.get(nodeId);
            this.changeSupply(node, (int)v);
        }
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, newValue);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, null);
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        NSArc arc = new NSArc(this.graph.getEdge(edgeId), true);
        this.addArc(arc);
        if (!directed) {
            arc = new NSArc(this.graph.getEdge(edgeId), false);
            this.addArc(arc);
        }
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        NSArc arc = this.arcs.get(edgeId);
        this.removeArc(arc);
        arc = this.arcs.get("__NS_REVERSE_" + edgeId);
        if (arc != null) {
            this.removeArc(arc);
        }
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.addNode(new NSNode(this.graph.getNode(nodeId)));
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.removeNode(this.nodes.get(nodeId));
    }

    public void graphCleared(String sourceId, long timeId) {
        this.clearGraph();
    }

    protected static double objectToDouble(Object o) {
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (o instanceof String) {
                try {
                    return Double.parseDouble((String)o);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return Double.NaN;
    }

    protected void changeCost(NSArc arc, BigMNumber newCost) {
        if (arc.cost.compareTo(newCost) == 0) {
            return;
        }
        this.objectiveValue.plusTimes(-arc.flow, arc.cost);
        arc.cost.set(newCost);
        this.objectiveValue.plusTimes(arc.flow, arc.cost);
        if (arc.status == ArcStatus.BASIC) {
            NSNode subtreeRoot = arc.source.arcToParent == arc ? arc.source : arc.target;
            subtreeRoot.computePotential();
            NSNode node = subtreeRoot.thread;
            while (node.depth > subtreeRoot.depth) {
                node.computePotential();
                node = node.thread;
            }
            this.solutionStatus = SolutionStatus.UNDEFINED;
        } else {
            arc.computeReducedCost(this.work1);
            if (this.work1.isNegative()) {
                this.solutionStatus = SolutionStatus.UNDEFINED;
            }
        }
    }

    protected void changeSupply(NSNode node, int newSupply) {
        if (node.supply == newSupply) {
            return;
        }
        NSArc artificial = node.artificialArc;
        if (artificial.status == ArcStatus.NONBASIC_LOWER) {
            this.enteringArc = artificial;
            this.selectLeavingArc();
            if (this.cycleFlowChange.isInfinite()) {
                artificial.switchDirection();
                this.selectLeavingArc();
            }
            this.fromSink = true;
            this.pivot();
        }
        this.objectiveValue.plusTimes(-artificial.flow, artificial.cost);
        int delta = newSupply - node.supply;
        node.supply = newSupply;
        this.root.supply -= delta;
        artificial.flow = node == artificial.source ? (artificial.flow += delta) : (artificial.flow -= delta);
        if (artificial.flow < 0) {
            artificial.switchDirection();
        }
        this.objectiveValue.plusTimes(artificial.flow, artificial.cost);
        this.solutionStatus = SolutionStatus.UNDEFINED;
        if (this.animationDelay > 0L) {
            artificial.setUIClass();
        }
    }

    protected void changeCapacity(NSArc arc, int newCapacity) {
        if (arc.capacity == newCapacity) {
            return;
        }
        if (arc.status == ArcStatus.NONBASIC_LOWER) {
            arc.capacity = newCapacity;
            return;
        }
        if (arc.status == ArcStatus.NONBASIC_UPPER) {
            this.enteringArc = arc;
            this.selectLeavingArc();
            this.fromSink = true;
            this.pivot();
            this.solutionStatus = SolutionStatus.UNDEFINED;
        }
        if (newCapacity == -1 || arc.flow <= newCapacity) {
            arc.capacity = newCapacity;
            return;
        }
        int delta = arc.flow - newCapacity;
        arc.flow = arc.capacity = newCapacity;
        this.objectiveValue.plusTimes(-delta, arc.cost);
        arc.source.supply -= delta;
        arc.target.supply += delta;
        if (this.animationDelay > 0L) {
            arc.setUIClass();
        }
        this.changeSupply(arc.source, arc.source.supply + delta);
        this.changeSupply(arc.target, arc.target.supply - delta);
    }

    protected void addArc(NSArc arc) {
        arc.flow = 0;
        arc.status = ArcStatus.NONBASIC_LOWER;
        this.arcs.put(arc.id, arc);
        this.nonBasicArcs.add(arc);
        arc.computeReducedCost(this.work1);
        if (this.work1.isNegative()) {
            this.solutionStatus = SolutionStatus.UNDEFINED;
        }
        if (this.animationDelay > 0L) {
            arc.setUIClass();
        }
    }

    protected void removeArc(NSArc arc) {
        this.changeCapacity(arc, 0);
        if (arc.status == ArcStatus.BASIC) {
            NSNode node = arc.source.arcToParent == arc ? arc.source : arc.target;
            this.enteringArc = node.artificialArc;
            if (this.enteringArc.source == this.root) {
                this.enteringArc.switchDirection();
            }
            this.selectLeavingArc();
            this.fromSink = true;
            this.pivot();
            this.solutionStatus = SolutionStatus.UNDEFINED;
        }
        this.arcs.remove(arc.id);
        this.nonBasicArcs.remove(arc);
    }

    protected void addNode(NSNode node) {
        this.nodes.put(node.id, node);
        node.createArtificialArc();
        this.solutionStatus = SolutionStatus.UNDEFINED;
    }

    protected void removeNode(NSNode node) {
        node.previousInThread().thread = node.thread;
        NSArc artificial = node.arcToParent;
        this.objectiveValue.plusTimes(-artificial.flow, artificial.cost);
        this.root.supply += node.supply;
        this.nodes.remove(node.id);
        this.solutionStatus = SolutionStatus.UNDEFINED;
    }

    protected void clearGraph() {
        this.nodes.clear();
        this.arcs.clear();
        this.nonBasicArcs.clear();
        this.root.thread = this.root;
        this.root.supply = 0;
        this.objectiveValue.set(0L);
        this.solutionStatus = SolutionStatus.OPTIMAL;
    }

    public void printBFS(PrintStream ps) {
        ps.println("=== Nodes ===");
        ps.printf("%20s%10s%10s%20s%20s%10s%n", "id", "supply", "potential", "parent", "thread", "depth");
        ps.printf("%20s%10d%10s%20s%20s%10d%n", this.root.id, this.root.supply, this.root.potential, "-", this.root.thread.id, this.root.depth);
        for (NSNode node : this.nodes.values()) {
            ps.printf("%20s%10d%10s%20s%20s%10d%n", node.id, node.supply, node.potential, node.parent.id, node.thread.id, node.depth);
        }
        ps.println();
        ps.println("=== Arcs ===");
        ps.printf("%20s%10s%10s%10s%10s%20s%n", "id", "capacity", "cost", "flow", "r. cost", "status");
        for (NSArc a : this.arcs.values()) {
            a.computeReducedCost(this.work1);
            ps.printf("%20s%10s%10s%10s%10s%20s%n", new Object[]{a.id, a.capacity == -1 ? "Inf" : Integer.valueOf(a.capacity), a.cost, a.flow, this.work1, a.status});
        }
        for (NSNode node : this.nodes.values()) {
            NSArc a = node.artificialArc;
            a.computeReducedCost(this.work1);
            ps.printf("%20s%10s%10s%10s%10s%20s%n", new Object[]{a.id, a.capacity == -1 ? "Inf" : Integer.valueOf(a.capacity), a.cost, a.flow, this.work1, a.status});
        }
        ps.println();
        ps.printf("=== Objective value %s. Solution status %s ===%n%n", new Object[]{this.objectiveValue, this.solutionStatus});
    }

    protected class NSArc {
        String id;
        int capacity;
        BigMNumber cost;
        NSNode source;
        NSNode target;
        int flow;
        ArcStatus status;

        NSArc(Edge edge, boolean sameDirection) {
            if (edge.getId().startsWith(NetworkSimplex.PREFIX)) {
                throw new IllegalArgumentException("Edge ids must not start with __NS_");
            }
            this.id = (sameDirection ? "" : "__NS_REVERSE_") + edge.getId();
            double v = edge.getNumber(NetworkSimplex.this.capacityName);
            if (Double.isNaN(v) || v < 0.0) {
                v = -1.0;
            }
            this.capacity = (int)v;
            v = edge.getNumber(NetworkSimplex.this.costName);
            if (Double.isNaN(v)) {
                v = 1.0;
            }
            this.cost = new BigMNumber((int)v);
            String sourceId = edge.getSourceNode().getId();
            String targetId = edge.getTargetNode().getId();
            this.source = NetworkSimplex.this.nodes.get(sameDirection ? sourceId : targetId);
            this.target = NetworkSimplex.this.nodes.get(sameDirection ? targetId : sourceId);
        }

        NSArc() {
            this.cost = new BigMNumber();
        }

        void computeReducedCost(BigMNumber reducedCost) {
            reducedCost.set(this.cost);
            reducedCost.minus(this.source.potential);
            reducedCost.plus(this.target.potential);
            if (this.status == ArcStatus.NONBASIC_UPPER) {
                reducedCost.minus();
            }
        }

        void computeAllowedFlowChange(NSNode first, BigMNumber flowChange) {
            if (first == this.source) {
                if (this.capacity == -1) {
                    flowChange.set(0L, 1L);
                } else {
                    flowChange.set(this.capacity - this.flow);
                }
            } else {
                flowChange.set(this.flow);
            }
        }

        void changeFlow(int delta, NSNode first) {
            this.flow = first == this.source ? (this.flow += delta) : (this.flow -= delta);
            if (NetworkSimplex.this.animationDelay > 0L) {
                this.setUIClass();
            }
        }

        NSNode getOpposite(NSNode node) {
            if (node == this.source) {
                return this.target;
            }
            if (node == this.target) {
                return this.source;
            }
            return null;
        }

        public boolean isArtificial() {
            return this.source == NetworkSimplex.this.root || this.target == NetworkSimplex.this.root;
        }

        String getOriginalId() {
            if (this.isArtificial()) {
                return null;
            }
            if (this.id.startsWith("__NS_REVERSE_")) {
                return this.id.substring(NetworkSimplex.PREFIX.length() + "REVERSE_".length());
            }
            return this.id;
        }

        void setUIClass() {
            if (this.isArtificial()) {
                NSNode node = this.getOpposite(NetworkSimplex.this.root);
                String uiClass = "trans";
                if (node.supply > 0) {
                    uiClass = "supply";
                } else if (node.supply < 0) {
                    uiClass = "demand";
                }
                uiClass = uiClass + (this.flow == 0 ? "_balanced" : "_unbalanced");
                Node x = NetworkSimplex.this.graph.getNode(node.id);
                x.addAttribute("label", new Object[]{this.target == NetworkSimplex.this.root ? this.flow : -this.flow});
                x.addAttribute("ui.class", new Object[]{uiClass});
            } else {
                String uiClass = "basic";
                if (this.status == ArcStatus.NONBASIC_LOWER) {
                    uiClass = "nonbasic_lower";
                } else if (this.status == ArcStatus.NONBASIC_UPPER) {
                    uiClass = "nonbasic_upper";
                }
                Edge e = NetworkSimplex.this.graph.getEdge(this.getOriginalId());
                e.addAttribute("label", new Object[]{this.flow});
                e.addAttribute("ui.class", new Object[]{uiClass});
            }
        }

        void switchDirection() {
            NSNode tmp = this.source;
            this.source = this.target;
            this.target = tmp;
            this.flow = -this.flow;
            NSNode subtreeRoot = this.getOpposite(NetworkSimplex.this.root);
            subtreeRoot.computePotential();
            NSNode node = subtreeRoot.thread;
            while (node.depth > subtreeRoot.depth) {
                node.computePotential();
                node = node.thread;
            }
        }
    }

    public static enum ArcStatus {
        BASIC,
        NONBASIC_LOWER,
        NONBASIC_UPPER;

    }

    protected class NSNode {
        String id;
        int supply;
        BigMNumber potential;
        NSNode parent;
        NSNode thread;
        int depth;
        NSArc arcToParent;
        NSArc artificialArc;

        NSNode(Node node) {
            this.id = node.getId();
            double v = node.getNumber(NetworkSimplex.this.supplyName);
            if (Double.isNaN(v)) {
                v = 0.0;
            }
            this.supply = (int)v;
            this.potential = new BigMNumber();
        }

        NSNode() {
            this.potential = new BigMNumber();
        }

        void createArtificialArc() {
            this.artificialArc = new NSArc();
            this.artificialArc.id = this.id;
            this.artificialArc.capacity = -1;
            this.artificialArc.cost.set(0L, 1L);
            this.artificialArc.status = ArcStatus.BASIC;
            if (this.supply > 0) {
                this.artificialArc.source = this;
                this.artificialArc.target = NetworkSimplex.this.root;
                this.artificialArc.flow = this.supply;
            } else {
                this.artificialArc.source = NetworkSimplex.this.root;
                this.artificialArc.target = this;
                this.artificialArc.flow = -this.supply;
            }
            this.parent = NetworkSimplex.this.root;
            this.thread = NetworkSimplex.this.root.thread;
            NetworkSimplex.this.root.thread = this;
            this.depth = 1;
            this.arcToParent = this.artificialArc;
            this.computePotential();
            NetworkSimplex.this.root.supply -= this.supply;
            NetworkSimplex.this.objectiveValue.plusTimes(this.artificialArc.flow, this.artificialArc.cost);
            if (NetworkSimplex.this.animationDelay > 0L) {
                this.artificialArc.setUIClass();
            }
        }

        NSNode previousInThread() {
            NSNode node = this.parent;
            while (node.thread != this) {
                node = node.thread;
            }
            return node;
        }

        NSNode lastSuccessor() {
            NSNode node = this;
            while (node.thread.depth > this.depth) {
                node = node.thread;
            }
            return node;
        }

        void computePotential() {
            this.potential.set(this.parent.potential);
            if (this.arcToParent.source == this) {
                this.potential.plus(this.arcToParent.cost);
            } else {
                this.potential.minus(this.arcToParent.cost);
            }
        }

        void changeParent(NSNode newParent, NSArc newArcToParent) {
            NSNode pred = this.previousInThread();
            NSNode succ = this.lastSuccessor();
            pred.thread = succ.thread;
            succ.thread = newParent.thread;
            newParent.thread = this;
            this.parent = newParent;
            this.arcToParent = newArcToParent;
            NSNode node = this;
            while (node != succ.thread) {
                node.depth = node.parent.depth + 1;
                node.computePotential();
                node = node.thread;
            }
        }
    }

    public static enum SolutionStatus {
        UNDEFINED,
        OPTIMAL,
        INFEASIBLE,
        UNBOUNDED;

    }

    public static enum PricingStrategy {
        FIRST_NEGATIVE,
        MOST_NEGATIVE;

    }
}

