/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.randomWalk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.randomWalk.Entity;
import org.graphstream.algorithm.randomWalk.TabuEntity;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.SinkAdapter;

public class RandomWalk
extends SinkAdapter
implements DynamicAlgorithm {
    protected Context context = new Context();
    protected String entityClass = TabuEntity.class.getName();
    protected ArrayList<Entity> entities = new ArrayList();
    protected long randomSeed;
    protected int entityCount = 100;
    protected double evaporation = 1.0;
    protected boolean doNodes = true;
    protected boolean doEdges = true;

    public RandomWalk() {
        this(System.currentTimeMillis());
    }

    public RandomWalk(long randomSeed) {
        this.randomSeed = randomSeed;
        this.context.random = new Random(randomSeed);
    }

    public String getPassesAttribute() {
        return this.context.passesAttribute;
    }

    public void setEntityClass(String name) {
        this.entityClass = name == null ? TabuEntity.class.getName() : name;
    }

    public void setEntityMemory(int size) {
        if (size < 0) {
            size = 0;
        }
        this.context.entityMemory = size;
    }

    public void setEvaporation(double evaporation) {
        if (evaporation >= 0.0 && evaporation < 1.0) {
            this.evaporation = evaporation;
        }
    }

    public double getEvaporation() {
        return this.evaporation;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public int getJumpCount() {
        return this.context.jumpCount;
    }

    public int getWaitCount() {
        return this.context.waitCount;
    }

    public int getGoCount() {
        return this.context.goCount;
    }

    public double getJumpRatio() {
        return (double)this.context.jumpCount / (double)this.entities.size();
    }

    public void setWeightAttribute(String name) {
        this.context.weightAttribute = name;
    }

    public void setPassesAttribute(String name) {
        if (this.context.graph != null) {
            for (Edge e : this.context.graph.getEachEdge()) {
                e.addAttribute(name, new Object[]{e.getNumber(this.context.passesAttribute)});
                e.removeAttribute(this.context.passesAttribute);
            }
            for (Node n : this.context.graph) {
                n.addAttribute(name, new Object[]{n.getNumber(this.context.passesAttribute)});
                n.removeAttribute(this.context.passesAttribute);
            }
        }
        this.context.passesAttribute = name;
    }

    public double getPasses(Edge edge) {
        return edge.getNumber(this.context.passesAttribute);
    }

    public double getPasses(Node node) {
        return node.getNumber(this.context.passesAttribute);
    }

    public void setEntityCount(int entityCount) {
        this.entityCount = entityCount;
    }

    public void computeEdgesPasses(boolean on) {
        this.doEdges = on;
    }

    public void computeNodePasses(boolean on) {
        this.doNodes = on;
    }

    public Entity createEntity() {
        try {
            Object o = Class.forName(this.entityClass).newInstance();
            if (o instanceof Entity) {
                Entity e = (Entity)o;
                e.init(this.context, Toolkit.randomNode(this.context.graph, this.context.random));
                return e;
            }
            System.err.printf("Object %s  pointed at by class name '%s' does not implement Entity.%n", o.getClass().getName(), this.entityClass);
        }
        catch (Exception e) {
            System.err.printf("Error: %s%n", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void init(Graph graph) {
        if (this.context.graph != null) {
            throw new RuntimeException("cannot begin a random walk if the previous one was not finished, use end().");
        }
        this.context.graph = graph;
        this.entities.clear();
        for (int i = 0; i < this.entityCount; ++i) {
            this.entities.add(this.createEntity());
        }
        this.equipGraph();
        graph.addElementSink((ElementSink)this);
    }

    @Override
    public void compute() {
        this.context.jumpCount = 0;
        this.context.goCount = 0;
        this.context.waitCount = 0;
        for (Entity entity : this.entities) {
            entity.step();
        }
        if (this.evaporation < 1.0) {
            this.evaporate();
        }
    }

    protected void evaporate() {
        for (Edge edge : this.context.graph.getEachEdge()) {
            edge.setAttribute(this.context.passesAttribute, new Object[]{edge.getNumber(this.context.passesAttribute) * this.evaporation});
        }
        for (Node node : this.context.graph) {
            node.setAttribute(this.context.passesAttribute, new Object[]{node.getNumber(this.context.passesAttribute) * this.evaporation});
        }
    }

    @Override
    public void terminate() {
        this.entities.clear();
        this.context.graph.removeElementSink((ElementSink)this);
        this.context.graph = null;
    }

    protected void equipGraph() {
        for (Edge e : this.context.graph.getEachEdge()) {
            e.addAttribute(this.context.passesAttribute, new Object[]{0.0});
        }
        for (Node n : this.context.graph) {
            n.addAttribute(this.context.passesAttribute, new Object[]{0.0});
        }
    }

    public ArrayList<Edge> findTheMostUsedEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>(this.context.graph.getEdgeCount());
        Iterator i = this.context.graph.getEdgeIterator();
        while (i.hasNext()) {
            edges.add((Edge)i.next());
        }
        Collections.sort(edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                int n1 = (int)e1.getNumber(RandomWalk.this.context.passesAttribute);
                int n2 = (int)e2.getNumber(RandomWalk.this.context.passesAttribute);
                return n1 - n2;
            }
        });
        return edges;
    }

    public ArrayList<Node> findTheMostUsedNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.context.graph.getNodeCount());
        Iterator i = this.context.graph.getNodeIterator();
        while (i.hasNext()) {
            nodes.add((Node)i.next());
        }
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node e1, Node e2) {
                int n1 = (int)e1.getNumber(RandomWalk.this.context.passesAttribute);
                int n2 = (int)e2.getNumber(RandomWalk.this.context.passesAttribute);
                return n1 - n2;
            }
        });
        return nodes;
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        Edge edge = this.context.graph.getEdge(edgeId);
        if (edge != null) {
            edge.addAttribute(this.context.passesAttribute, new Object[]{0.0});
        }
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        Node node = this.context.graph.getNode(nodeId);
        node.addAttribute(this.context.passesAttribute, new Object[]{0.0});
    }

    public class Context {
        protected Graph graph;
        protected String passesAttribute = "passes";
        protected String weightAttribute = null;
        protected Random random;
        protected int entityMemory = 0;
        protected int jumpCount = 0;
        protected int goCount = 0;
        protected int waitCount = 0;

        public String getPassesAttribute() {
            return this.passesAttribute;
        }

        public String getWeightAttribute() {
            return this.weightAttribute;
        }

        public Random getRandom() {
            return this.random;
        }

        public int getEntityMemory() {
            return this.entityMemory;
        }
    }
}

