/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.util.Selection;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001b\t\t2+\u001a7fGRLwN\u001c*f]\u0012,'/\u001a:\u000b\u0005\r!\u0011\u0001\u0003:f]\u0012,'/\u001a:\u000b\u0005\u00151\u0011!\u000363IZLWm^3s\u0015\t9\u0001\"\u0001\u0002vS*\u0011\u0011BC\u0001\fOJ\f\u0007\u000f[:ue\u0016\fWNC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005I1/\u001a7fGRLwN\\\u000b\u0002/A\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\u0005kRLG.\u0003\u0002\u001d3\tI1+\u001a7fGRLwN\u001c\u0005\t=\u0001\u0011\t\u0011)A\u0005/\u0005Q1/\u001a7fGRLwN\u001c\u0011\t\u0011\u0001\u0002!Q1A\u0005\u0002\u0005\nQa\u001a:ba\",\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K\u0019\tAb\u001a:ba\"L7m\u0012:ba\"L!a\n\u0013\u0003\u0019\u001d\u0013\u0018\r\u001d5jG\u001e\u0013\u0018\r\u001d5\t\u0011%\u0002!\u0011!Q\u0001\n\t\naa\u001a:ba\"\u0004\u0003\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0002._A\u0002\"A\f\u0001\u000e\u0003\tAQ!\u0006\u0016A\u0002]AQ\u0001\t\u0016A\u0002\tBqA\r\u0001C\u0002\u0013E1'A\u0003tQ\u0006\u0004X-F\u00015!\t)tH\u0004\u00027{5\tqG\u0003\u00029s\u0005!q-Z8n\u0015\tQ4(A\u0002boRT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?o\u0005Y!+Z2uC:<G.\u001a\u001aE\u0013\t\u0001\u0015I\u0001\u0004E_V\u0014G.\u001a\u0006\u0003}]Baa\u0011\u0001!\u0002\u0013!\u0014AB:iCB,\u0007\u0005C\u0004F\u0001\t\u0007I\u0011\u0003$\u0002\u00151Lg.Z:D_2|'/F\u0001H!\tA\u0015*D\u0001:\u0013\tQ\u0015HA\u0003D_2|'\u000f\u0003\u0004M\u0001\u0001\u0006IaR\u0001\fY&tWm]\"pY>\u0014\b\u0005C\u0004O\u0001\t\u0007I\u0011\u0003$\u0002\u00171Lg.Z:D_2|'/\u0015\u0005\u0007!\u0002\u0001\u000b\u0011B$\u0002\u00191Lg.Z:D_2|'/\u0015\u0011\t\u000fI\u0003!\u0019!C\t\r\u0006Ia-\u001b7m\u0007>dwN\u001d\u0005\u0007)\u0002\u0001\u000b\u0011B$\u0002\u0015\u0019LG\u000e\\\"pY>\u0014\b\u0005C\u0004W\u0001\t\u0007I\u0011\u0003$\u0002\u0019M$(o\\6f\u0007>dwN])\t\ra\u0003\u0001\u0015!\u0003H\u00035\u0019HO]8lK\u000e{Gn\u001c:RA!9!\f\u0001b\u0001\n#1\u0015aC:ue>\\WmQ8m_JDa\u0001\u0018\u0001!\u0002\u00139\u0015\u0001D:ue>\\WmQ8m_J\u0004\u0003\"\u00020\u0001\t\u0003y\u0016A\u0002:f]\u0012,'\u000fF\u0003aG&t7\u000f\u0005\u0002\u0010C&\u0011!\r\u0005\u0002\u0005+:LG\u000fC\u0003e;\u0002\u0007Q-A\u0002cG.\u0004\"AZ4\u000e\u0003\u0011I!\u0001\u001b\u0003\u0003\u000f\t\u000b7m[3oI\")!.\u0018a\u0001W\u000611-Y7fe\u0006\u0004\"A\u001a7\n\u00055$!AB\"b[\u0016\u0014\u0018\rC\u0003p;\u0002\u0007\u0001/\u0001\u0006qC:,GnV5ei\"\u0004\"aD9\n\u0005I\u0004\"aA%oi\")A/\u0018a\u0001a\u0006Y\u0001/\u00198fY\"+\u0017n\u001a5u\u0001")
public class SelectionRenderer {
    private final Selection selection;
    private final GraphicGraph graph;
    private final Rectangle2D.Double shape;
    private final Color linesColor;
    private final Color linesColorQ;
    private final Color fillColor;
    private final Color strokeColorQ;
    private final Color strokeColor;

    public Selection selection() {
        return this.selection;
    }

    public GraphicGraph graph() {
        return this.graph;
    }

    public Rectangle2D.Double shape() {
        return this.shape;
    }

    public Color linesColor() {
        return this.linesColor;
    }

    public Color linesColorQ() {
        return this.linesColorQ;
    }

    public Color fillColor() {
        return this.fillColor;
    }

    public Color strokeColorQ() {
        return this.strokeColorQ;
    }

    public Color strokeColor() {
        return this.strokeColor;
    }

    public void render(Backend bck, Camera camera, int panelWidth, int panelHeight) {
        if (this.selection().active() && this.selection().x1() != this.selection().x2() && this.selection().y1() != this.selection().y2()) {
            Graphics2D g = bck.graphics2D();
            boolean quality = this.graph().hasAttribute("ui.quality") || this.graph().hasAttribute("ui.antialias");
            double x1 = this.selection().x1();
            double y1 = this.selection().y1();
            double x2 = this.selection().x2();
            double y2 = this.selection().y2();
            double t = 0.0;
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            if (quality) {
                g.setColor(this.linesColorQ());
            } else {
                g.setColor(this.linesColor());
            }
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(0, (int)y1, panelWidth, (int)y1);
            g.drawLine(0, (int)y2, panelWidth, (int)y2);
            g.drawLine((int)x1, 0, (int)x1, panelHeight);
            g.drawLine((int)x2, 0, (int)x2, panelHeight);
            this.shape().setFrame(x1, y1, x2 - x1, y2 - y1);
            if (quality) {
                g.setColor(this.fillColor());
                g.fill(this.shape());
                g.setColor(this.strokeColorQ());
            } else {
                g.setColor(this.strokeColor());
            }
            g.draw(this.shape());
        }
    }

    public SelectionRenderer(Selection selection, GraphicGraph graph) {
        this.selection = selection;
        this.graph = graph;
        this.shape = new Rectangle2D.Double();
        this.linesColor = new Color(240, 240, 240);
        this.linesColorQ = new Color(0, 0, 0, 64);
        this.fillColor = new Color(50, 50, 200, 32);
        this.strokeColorQ = new Color(50, 50, 200, 64);
        this.strokeColor = new Color(128, 128, 128);
    }
}

