/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeAreaPaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeColorPaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint$;
import scala.runtime.BoxedUnit;

public abstract class Fillable$class {
    public static void fill(Fillable $this, Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        if ($this.plainFast()) {
            g.setColor($this.theFillColor());
            g.fill(shape);
        } else {
            ShapePaint shapePaint = $this.fillPaint();
            if (shapePaint instanceof ShapeAreaPaint) {
                ShapeAreaPaint shapeAreaPaint = (ShapeAreaPaint)shapePaint;
                g.setPaint(shapeAreaPaint.paint(shape, camera.metrics().ratioPx2Gu));
                g.fill(shape);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (shapePaint instanceof ShapeColorPaint) {
                ShapeColorPaint shapeColorPaint = (ShapeColorPaint)shapePaint;
                g.setPaint(shapeColorPaint.paint(dynColor, optColor));
                g.fill(shape);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static void fill(Fillable $this, Graphics2D g, Shape shape, Camera camera) {
        $this.fill(g, $this.theFillPercent(), $this.theFillColor(), shape, camera);
    }

    public static void configureFillableForGroup(Fillable $this, Backend bck, Style style, Camera camera) {
        $this.fillPaint_$eq(ShapePaint$.MODULE$.apply(style));
        if ($this.fillPaint() instanceof ShapePaint.ShapePlainColorPaint) {
            ShapePaint.ShapePlainColorPaint paint = (ShapePaint.ShapePlainColorPaint)$this.fillPaint();
            $this.plainFast_$eq(true);
            $this.theFillColor_$eq(paint.color());
            bck.graphics2D().setColor($this.theFillColor());
        } else {
            $this.plainFast_$eq(false);
        }
    }

    public static void configureFillableForElement(Fillable $this, Style style, Camera camera, GraphicElement element) {
        StyleConstants.FillMode fillMode = style.getFillMode();
        StyleConstants.FillMode fillMode2 = StyleConstants.FillMode.DYN_PLAIN;
        if (!(fillMode != null ? !fillMode.equals(fillMode2) : fillMode2 != null) && element != null) {
            Object object = element.getAttribute("ui.color");
            if (object instanceof Number) {
                Number number = (Number)object;
                $this.theFillPercent_$eq(number.floatValue());
                $this.theFillColor_$eq(null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Color) {
                Color color = (Color)object;
                $this.theFillColor_$eq(color);
                $this.theFillPercent_$eq(0.0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.theFillPercent_$eq(0.0);
                $this.theFillColor_$eq(null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            $this.theFillPercent_$eq(0.0);
        }
    }

    public static void $init$(Fillable $this) {
        $this.fillPaint_$eq(null);
        $this.theFillPercent_$eq(0.0);
        $this.theFillColor_$eq(null);
        $this.plainFast_$eq(false);
    }
}

