/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Area$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Decorable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.HasSkel$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Orientable;
import org.graphstream.ui.j2dviewer.renderer.shape.Orientable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.IconAndText;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.RectangularAreaShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.RectangularAreaShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\u0001\u0003\u0003\u0003\t\"AH(sS\u0016tG/\u00192mKJ+7\r^1oOVd\u0017M]!sK\u0006\u001c\u0006.\u00199f\u0015\t\u0019A!A\u0003to&twM\u0003\u0002\u0006\r\u0005)1\u000f[1qK*\u0011q\u0001C\u0001\te\u0016tG-\u001a:fe*\u0011\u0011BC\u0001\nUJ\"g/[3xKJT!a\u0003\u0007\u0002\u0005UL'BA\u0007\u000f\u0003-9'/\u00199igR\u0014X-Y7\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u00199A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003)I+7\r^1oOVd\u0017M]!sK\u0006\u001c\u0006.\u00199f!\tib$D\u0001\u0005\u0013\tyBA\u0001\u0006Pe&,g\u000e^1cY\u0016DQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtD#A\u0012\u0011\u0005e\u0001\u0001bB\u0013\u0001\u0001\u0004%\tAJ\u0001\u0002aV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\u0015\u0005!q-Z8n\u0013\ta\u0013F\u0001\u0004Q_&tGo\r\u0005\b]\u0001\u0001\r\u0011\"\u00010\u0003\u0015\u0001x\fJ3r)\t\u00014\u0007\u0005\u0002\u0014c%\u0011!\u0007\u0006\u0002\u0005+:LG\u000fC\u00045[\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013\u0007\u0003\u00047\u0001\u0001\u0006KaJ\u0001\u0003a\u0002Bq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011(A\u0003b]\u001edW-F\u0001;!\t\u00192(\u0003\u0002=)\t1Ai\\;cY\u0016DqA\u0010\u0001A\u0002\u0013\u0005q(A\u0005b]\u001edWm\u0018\u0013fcR\u0011\u0001\u0007\u0011\u0005\biu\n\t\u00111\u0001;\u0011\u0019\u0011\u0005\u0001)Q\u0005u\u00051\u0011M\\4mK\u0002Bq\u0001\u0012\u0001A\u0002\u0013\u0005\u0011(A\u0001x\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bQa^0%KF$\"\u0001\r%\t\u000fQ*\u0015\u0011!a\u0001u!1!\n\u0001Q!\ni\n!a\u001e\u0011\t\u000f1\u0003\u0001\u0019!C\u0001s\u0005\t\u0001\u000eC\u0004O\u0001\u0001\u0007I\u0011A(\u0002\u000b!|F%Z9\u0015\u0005A\u0002\u0006b\u0002\u001bN\u0003\u0003\u0005\rA\u000f\u0005\u0007%\u0002\u0001\u000b\u0015\u0002\u001e\u0002\u0005!\u0004\u0003b\u0002+\u0001\u0001\u0004%\t!V\u0001\t_JLWM\u001c;fIV\ta\u000b\u0005\u0002\u0014/&\u0011\u0001\f\u0006\u0002\b\u0005>|G.Z1o\u0011\u001dQ\u0006\u00011A\u0005\u0002m\u000bAb\u001c:jK:$X\rZ0%KF$\"\u0001\r/\t\u000fQJ\u0016\u0011!a\u0001-\"1a\f\u0001Q!\nY\u000b\u0011b\u001c:jK:$X\r\u001a\u0011\t\u000b\u0001\u0004A\u0011I1\u0002#\r|gNZ5hkJ,gi\u001c:He>,\b\u000f\u0006\u00031E\"\u0014\b\"B2`\u0001\u0004!\u0017a\u00012dWB\u0011QMZ\u0007\u0002\u0011%\u0011q\r\u0003\u0002\b\u0005\u0006\u001c7.\u001a8e\u0011\u0015Iw\f1\u0001k\u0003\u0015\u0019H/\u001f7f!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0006tifdWm\u001d5fKRT!a\u001c\u0006\u0002\u0019\u001d\u0014\u0018\r\u001d5jG\u001e\u0013\u0018\r\u001d5\n\u0005Ed'!B*us2,\u0007\"B:`\u0001\u0004!\u0018AB2b[\u0016\u0014\u0018\r\u0005\u0002fk&\u0011a\u000f\u0003\u0002\u0007\u0007\u0006lWM]1\t\u000ba\u0004A\u0011I=\u0002'\r|gNZ5hkJ,gi\u001c:FY\u0016lWM\u001c;\u0015\u000fAR80a\u0001\u0002\u0010!)1m\u001ea\u0001I\")Ap\u001ea\u0001{\u00069Q\r\\3nK:$\bC\u0001@\u0000\u001b\u0005q\u0017bAA\u0001]\nqqI]1qQ&\u001cW\t\\3nK:$\bbBA\u0003o\u0002\u0007\u0011qA\u0001\u0005g.,G\u000e\u0005\u0003\u0002\n\u0005-Q\"\u0001\u0004\n\u0007\u00055aA\u0001\u0005TW\u0016dW\r^8o\u0011\u0015\u0019x\u000f1\u0001u\u0011\u001d\t\u0019\u0002\u0001C)\u0003+\tA!\\1lKR)\u0001'a\u0006\u0002\u001a!11-!\u0005A\u0002\u0011Daa]A\t\u0001\u0004!\bbBA\u000f\u0001\u0011E\u0013qD\u0001\u000b[\u0006\\Wm\u00155bI><H#\u0002\u0019\u0002\"\u0005\r\u0002BB2\u0002\u001c\u0001\u0007A\r\u0003\u0004t\u00037\u0001\r\u0001\u001e\u0005\b\u0003'\u0001A\u0011CA\u0014)\u001d\u0001\u0014\u0011FA\u0016\u0003_AaaYA\u0013\u0001\u0004!\u0007bBA\u0017\u0003K\u0001\rAV\u0001\nM>\u00148\u000b[1e_^Daa]A\u0013\u0001\u0004!\bbBA\u001a\u0001\u0011\u0005\u0013QG\u0001\re\u0016tG-\u001a:TQ\u0006$wn\u001e\u000b\na\u0005]\u0012\u0011HA\u001e\u0003{AaaYA\u0019\u0001\u0004!\u0007BB:\u00022\u0001\u0007A\u000f\u0003\u0004}\u0003c\u0001\r! \u0005\t\u0003\u000b\t\t\u00041\u0001\u0002\b!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0013A\u0002:f]\u0012,'\u000fF\u00051\u0003\u000b\n9%!\u0013\u0002L!11-a\u0010A\u0002\u0011Daa]A \u0001\u0004!\bB\u0002?\u0002@\u0001\u0007Q\u0010\u0003\u0005\u0002\u0006\u0005}\u0002\u0019AA\u0004\u0001")
public abstract class OrientableRectangularAreaShape
implements RectangularAreaShape,
Orientable {
    private Point3 p;
    private double angle;
    private double w;
    private double h;
    private boolean oriented;
    private StyleConstants.SpriteOrientation orientation;
    private Point3 target;
    private String text;
    private ShapeDecor theDecor;
    private ConnectorSkeleton skel;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private final Point2 theCenter;
    private final Point2 theSize;
    private boolean fit;

    @Override
    public StyleConstants.SpriteOrientation orientation() {
        return this.orientation;
    }

    @Override
    @TraitSetter
    public void orientation_$eq(StyleConstants.SpriteOrientation x$1) {
        this.orientation = x$1;
    }

    @Override
    public Point3 target() {
        return this.target;
    }

    @Override
    @TraitSetter
    public void target_$eq(Point3 x$1) {
        this.target = x$1;
    }

    @Override
    public void configureOrientableForGroup(Style style, Camera camera) {
        Orientable$class.configureOrientableForGroup(this, style, camera);
    }

    @Override
    public void configureOrientableForElement(Camera camera, GraphicSprite sprite) {
        Orientable$class.configureOrientableForElement(this, camera, sprite);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @TraitSetter
    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    @Override
    public ShapeDecor theDecor() {
        return this.theDecor;
    }

    @Override
    @TraitSetter
    public void theDecor_$eq(ShapeDecor x$1) {
        this.theDecor = x$1;
    }

    @Override
    public void decorArea(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorArea(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void decorConnector(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorConnector(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void configureDecorableForGroup(Style style, Camera camera) {
        Decorable$class.configureDecorableForGroup(this, style, camera);
    }

    @Override
    public void configureDecorableForElement(Backend backend, Camera camera, GraphicElement element, Skeleton skel) {
        Decorable$class.configureDecorableForElement(this, backend, camera, element, skel);
    }

    @Override
    public ConnectorSkeleton skel() {
        return this.skel;
    }

    @Override
    @TraitSetter
    public void skel_$eq(ConnectorSkeleton x$1) {
        this.skel = x$1;
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public Point2 theCenter() {
        return this.theCenter;
    }

    @Override
    public Point2 theSize() {
        return this.theSize;
    }

    @Override
    public boolean fit() {
        return this.fit;
    }

    @Override
    @TraitSetter
    public void fit_$eq(boolean x$1) {
        this.fit = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theCenter_$eq(Point2 x$1) {
        this.theCenter = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theSize_$eq(Point2 x$1) {
        this.theSize = x$1;
    }

    @Override
    public void configureAreaForGroup(Style style, Camera camera) {
        Area$class.configureAreaForGroup(this, style, camera);
    }

    @Override
    public void configureAreaForElement(Backend backend, Camera camera, AreaSkeleton skel, GraphicElement element, ShapeDecor decor) {
        Area$class.configureAreaForElement(this, backend, camera, skel, element, decor);
    }

    public Point3 p() {
        return this.p;
    }

    public void p_$eq(Point3 x$1) {
        this.p = x$1;
    }

    public double angle() {
        return this.angle;
    }

    public void angle_$eq(double x$1) {
        this.angle = x$1;
    }

    public double w() {
        return this.w;
    }

    public void w_$eq(double x$1) {
        this.w = x$1;
    }

    public double h() {
        return this.h;
    }

    public void h_$eq(double x$1) {
        this.h = x$1;
    }

    public boolean oriented() {
        return this.oriented;
    }

    public void oriented_$eq(boolean x$1) {
        this.oriented = x$1;
    }

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaShape$class.configureForGroup(this, bck, style, camera);
        this.configureOrientableForGroup(style, camera);
        StyleConstants.SpriteOrientation spriteOrientation = style.getSpriteOrientation();
        StyleConstants.SpriteOrientation spriteOrientation2 = StyleConstants.SpriteOrientation.NONE;
        this.oriented_$eq(spriteOrientation != null ? !spriteOrientation.equals(spriteOrientation2) : spriteOrientation2 != null);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaShape$class.configureForElement(this, bck, element, skel, camera);
        this.configureOrientableForElement(camera, (GraphicSprite)element);
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(bck, false, camera);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.make(bck, true, camera);
    }

    public void make(Backend bck, boolean forShadow, Camera camera) {
        if (this.oriented()) {
            Vector2 theDirection = new Vector2(this.target().x - this.theCenter().x, this.target().y - this.theCenter().y);
            theDirection.normalize();
            double x = this.theCenter().x;
            double y = this.theCenter().y;
            if (forShadow) {
                x += this.theShadowOff().x;
                y += this.theShadowOff().y;
            }
            this.p_$eq(camera.transformGuToPx(x, y, 0.0));
            this.angle_$eq(package$.MODULE$.acos(theDirection.dotProduct(1.0, 0.0)));
            if (theDirection.y() > 0.0) {
                this.angle_$eq(package$.MODULE$.Pi() - this.angle());
            }
            this.w_$eq(camera.metrics().lengthToPx(this.theSize().x, StyleConstants.Units.GU));
            this.h_$eq(camera.metrics().lengthToPx(this.theSize().y, StyleConstants.Units.GU));
            this.theShape().setFrame(0.0, 0.0, this.w(), this.h());
        } else if (forShadow) {
            RectangularAreaShape$class.makeShadow(this, bck, camera);
        } else {
            RectangularAreaShape$class.make(this, bck, camera);
        }
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.make(bck, true, camera);
        Graphics2D g = bck.graphics2D();
        if (this.oriented()) {
            AffineTransform Tx = g.getTransform();
            AffineTransform Tr = new AffineTransform();
            Tr.translate(this.p().x, this.p().y);
            Tr.rotate(this.angle());
            Tr.translate(-this.w() / (double)2, -this.h() / (double)2);
            g.setTransform(Tr);
            this.cast(g, this.theShape());
            g.setTransform(Tx);
        } else {
            RectangularAreaShape$class.renderShadow(this, bck, camera, element, skel);
        }
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.make(bck, false, camera);
        Graphics2D g = bck.graphics2D();
        if (this.oriented()) {
            AffineTransform Tx = g.getTransform();
            AffineTransform Tr = new AffineTransform();
            Tr.translate(this.p().x, this.p().y);
            Tr.rotate(this.angle());
            Tr.translate(-this.w() / (double)2, -this.h() / (double)2);
            g.setTransform(Tr);
            this.stroke(g, this.theShape());
            this.fill(g, this.theShape(), camera);
            g.setTransform(Tx);
            this.theShape().setFrame(this.theCenter().x - this.w() / (double)2, this.theCenter().y - this.h() / (double)2, this.w(), this.h());
            this.decorArea(bck, camera, skel.iconAndText(), element, this.theShape());
        } else {
            RectangularAreaShape$class.render(this, bck, camera, element, skel);
        }
    }

    public OrientableRectangularAreaShape() {
        Area$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        HasSkel$class.$init$(this);
        Decorable$class.$init$(this);
        AreaShape$class.$init$(this);
        RectangularAreaShape$class.$init$(this);
        Orientable$class.$init$(this);
        this.p = null;
        this.angle = 0.0;
        this.w = 0.0;
        this.h = 0.0;
        this.oriented = false;
    }
}

