/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.util.logging.Logger;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Area;
import org.graphstream.ui.j2dviewer.renderer.shape.Area$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Decorable;
import org.graphstream.ui.j2dviewer.renderer.shape.Decorable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.HasSkel$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Shape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.FillableMulticolored;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.FillableMulticolored$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.IconAndText;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.PieChartShape$;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import org.graphstream.ui.util.AttributeUtils;
import org.graphstream.ui.util.AttributeUtils$class;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001du!B\u0001\u0003\u0011\u0003\t\u0012!\u0004)jK\u000eC\u0017M\u001d;TQ\u0006\u0004XM\u0003\u0002\u0004\t\u0005)1o^5oO*\u0011QAB\u0001\u0006g\"\f\u0007/\u001a\u0006\u0003\u000f!\t\u0001B]3oI\u0016\u0014XM\u001d\u0006\u0003\u0013)\t\u0011B\u001b\u001aem&,w/\u001a:\u000b\u0005-a\u0011AA;j\u0015\tia\"A\u0006he\u0006\u0004\bn\u001d;sK\u0006l'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005I\u0019R\"\u0001\u0002\u0007\u000bQ\u0011\u0001\u0012A\u000b\u0003\u001bAKWm\u00115beR\u001c\u0006.\u00199f'\t\u0019b\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\u0005\u0006;M!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003EAq\u0001I\nC\u0002\u0013\u0005\u0011%\u0001\u0004d_2|'o]\u000b\u0002EA\u0019qcI\u0013\n\u0005\u0011B\"!B!se\u0006L\bC\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\r\tw\u000f\u001e\u0006\u0002U\u0005!!.\u0019<b\u0013\tasEA\u0003D_2|'\u000f\u0003\u0004/'\u0001\u0006IAI\u0001\bG>dwN]:!\r\u0011!\"\u0001\u0001\u0019\u0014\u0013=2\u0012'\u000e\u001d<}\u0005#\u0005C\u0001\u001a4\u001b\u0005!\u0011B\u0001\u001b\u0005\u0005\u0015\u0019\u0006.\u00199f!\t\u0011d'\u0003\u00028\t\t!\u0011I]3b!\t\u0011\u0012(\u0003\u0002;\u0005\t!b)\u001b7mC\ndW-T;mi&\u001cw\u000e\\8sK\u0012\u0004\"A\u0005\u001f\n\u0005u\u0012!!C*ue>\\\u0017M\u00197f!\t\u0011r(\u0003\u0002A\u0005\tQ1\u000b[1e_^\f'\r\\3\u0011\u0005I\u0012\u0015BA\"\u0005\u0005%!UmY8sC\ndW\r\u0005\u0002F\u00116\taI\u0003\u0002H\u0015\u0005!Q\u000f^5m\u0013\tIeI\u0001\bBiR\u0014\u0018NY;uKV#\u0018\u000e\\:\t\u000buyC\u0011A&\u0015\u00031\u0003\"AE\u0018\t\u000f9{#\u0019!C\u0001\u001f\u0006AA\u000f[3TQ\u0006\u0004X-F\u0001Q!\t\tvK\u0004\u0002S+6\t1K\u0003\u0002UO\u0005!q-Z8n\u0013\t16+A\u0005FY2L\u0007o]33\t&\u0011\u0001,\u0017\u0002\u0007\t>,(\r\\3\u000b\u0005Y\u001b\u0006BB.0A\u0003%\u0001+A\u0005uQ\u0016\u001c\u0006.\u00199fA!9Ql\fa\u0001\n\u0003q\u0016!\u0003;iKZ\u000bG.^3t+\u0005y\u0006cA\f$AB\u0011q#Y\u0005\u00031bAqaY\u0018A\u0002\u0013\u0005A-A\u0007uQ\u00164\u0016\r\\;fg~#S-\u001d\u000b\u0003K\"\u0004\"a\u00064\n\u0005\u001dD\"\u0001B+oSRDq!\u001b2\u0002\u0002\u0003\u0007q,A\u0002yIEBaa[\u0018!B\u0013y\u0016A\u0003;iKZ\u000bG.^3tA!9Qn\fa\u0001\n\u0003q\u0017!\u0003<bYV,7OU3g+\u00051\u0002b\u000290\u0001\u0004%\t!]\u0001\u000em\u0006dW/Z:SK\u001a|F%Z9\u0015\u0005\u0015\u0014\bbB5p\u0003\u0003\u0005\rA\u0006\u0005\u0007i>\u0002\u000b\u0015\u0002\f\u0002\u0015Y\fG.^3t%\u00164\u0007\u0005C\u0003w_\u0011\u0005q/A\td_:4\u0017nZ;sK\u001a{'o\u0012:pkB$R!\u001a=\u007f\u0003#AQ!_;A\u0002i\f1AY2l!\tYH0D\u0001\t\u0013\ti\bBA\u0004CC\u000e\\WM\u001c3\t\r},\b\u0019AA\u0001\u0003\u0015\u0019H/\u001f7f!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t!b\u001d;zY\u0016\u001c\b.Z3u\u0015\r\tYAC\u0001\rOJ\f\u0007\u000f[5d\u000fJ\f\u0007\u000f[\u0005\u0005\u0003\u001f\t)AA\u0003TifdW\rC\u0004\u0002\u0014U\u0004\r!!\u0006\u0002\r\r\fW.\u001a:b!\rY\u0018qC\u0005\u0004\u00033A!AB\"b[\u0016\u0014\u0018\rC\u0004\u0002\u001e=\"\t!a\b\u0002'\r|gNZ5hkJ,gi\u001c:FY\u0016lWM\u001c;\u0015\u0013\u0015\f\t#a\t\u00020\u0005m\u0002BB=\u0002\u001c\u0001\u0007!\u0010\u0003\u0005\u0002&\u0005m\u0001\u0019AA\u0014\u0003\u001d)G.Z7f]R\u0004B!!\u000b\u0002,5\u0011\u0011\u0011B\u0005\u0005\u0003[\tIA\u0001\bHe\u0006\u0004\b.[2FY\u0016lWM\u001c;\t\u0011\u0005E\u00121\u0004a\u0001\u0003g\tAa]6fYB!\u0011QGA\u001c\u001b\u00051\u0011bAA\u001d\r\tA1k[3mKR|g\u000e\u0003\u0005\u0002\u0014\u0005m\u0001\u0019AA\u000b\u0011\u001d\tyd\fC!\u0003\u0003\nA!\\1lKR)Q-a\u0011\u0002F!1\u00110!\u0010A\u0002iD\u0001\"a\u0005\u0002>\u0001\u0007\u0011Q\u0003\u0005\b\u0003\u0013zC\u0011IA&\u0003)i\u0017m[3TQ\u0006$wn\u001e\u000b\u0006K\u00065\u0013q\n\u0005\u0007s\u0006\u001d\u0003\u0019\u0001>\t\u0011\u0005M\u0011q\ta\u0001\u0003+Aq!a\u00150\t\u0003\n)&\u0001\u0007sK:$WM]*iC\u0012|w\u000fF\u0005f\u0003/\nI&a\u0017\u0002^!1\u00110!\u0015A\u0002iD\u0001\"a\u0005\u0002R\u0001\u0007\u0011Q\u0003\u0005\t\u0003K\t\t\u00061\u0001\u0002(!A\u0011\u0011GA)\u0001\u0004\t\u0019\u0004C\u0004\u0002b=\"\t%a\u0019\u0002\rI,g\u000eZ3s)%)\u0017QMA4\u0003S\nY\u0007\u0003\u0004z\u0003?\u0002\rA\u001f\u0005\t\u0003'\ty\u00061\u0001\u0002\u0016!A\u0011QEA0\u0001\u0004\t9\u0003\u0003\u0005\u00022\u0005}\u0003\u0019AA\u001a\u0011\u001d\tyg\fC\t\u0003c\n1b\u00195fG.4\u0016\r\\;fgR\u0019Q-a\u001d\t\u0011\u0005\u0015\u0012Q\u000ea\u0001\u0003OAq!a\u001e0\t#\tI(\u0001\u0005gS2d\u0007+[3t)\u0015)\u00171PAC\u0011!\ti(!\u001eA\u0002\u0005}\u0014!A4\u0011\u0007\u0019\n\t)C\u0002\u0002\u0004\u001e\u0012!b\u0012:ba\"L7m\u001d\u001aE\u0011!\t)#!\u001eA\u0002\u0005\u001d\u0002")
public class PieChartShape
implements Shape,
Area,
FillableMulticolored,
Strokable,
Shadowable,
Decorable,
AttributeUtils {
    private final Ellipse2D.Double theShape;
    private double[] theValues;
    private Object valuesRef;
    private String text;
    private ShapeDecor theDecor;
    private ConnectorSkeleton skel;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private Color[] fillColors;
    private final Point2 theCenter;
    private final Point2 theSize;
    private boolean fit;

    public static Color[] colors() {
        return PieChartShape$.MODULE$.colors();
    }

    @Override
    public Point3[] getPoints(Object values) {
        return AttributeUtils$class.getPoints(this, values);
    }

    @Override
    public double[] getDoubles(Object values) {
        return AttributeUtils$class.getDoubles(this, values);
    }

    @Override
    public Tuple2<Point3, Point3> boundingBoxOfPoints(Point3[] points) {
        return AttributeUtils$class.boundingBoxOfPoints(this, points);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @TraitSetter
    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    @Override
    public ShapeDecor theDecor() {
        return this.theDecor;
    }

    @Override
    @TraitSetter
    public void theDecor_$eq(ShapeDecor x$1) {
        this.theDecor = x$1;
    }

    @Override
    public void decorArea(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, java.awt.Shape shape) {
        Decorable$class.decorArea(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void decorConnector(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, java.awt.Shape shape) {
        Decorable$class.decorConnector(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void configureDecorableForGroup(Style style, Camera camera) {
        Decorable$class.configureDecorableForGroup(this, style, camera);
    }

    @Override
    public void configureDecorableForElement(Backend backend, Camera camera, GraphicElement element, Skeleton skel) {
        Decorable$class.configureDecorableForElement(this, backend, camera, element, skel);
    }

    @Override
    public ConnectorSkeleton skel() {
        return this.skel;
    }

    @Override
    @TraitSetter
    public void skel_$eq(ConnectorSkeleton x$1) {
        this.skel = x$1;
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, java.awt.Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, java.awt.Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public Color[] fillColors() {
        return this.fillColors;
    }

    @Override
    public void fillColors_$eq(Color[] x$1) {
        this.fillColors = x$1;
    }

    @Override
    public void configureFillableMultiColoredForGroup(Style style, Camera camera) {
        FillableMulticolored$class.configureFillableMultiColoredForGroup(this, style, camera);
    }

    @Override
    public Point2 theCenter() {
        return this.theCenter;
    }

    @Override
    public Point2 theSize() {
        return this.theSize;
    }

    @Override
    public boolean fit() {
        return this.fit;
    }

    @Override
    @TraitSetter
    public void fit_$eq(boolean x$1) {
        this.fit = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theCenter_$eq(Point2 x$1) {
        this.theCenter = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theSize_$eq(Point2 x$1) {
        this.theSize = x$1;
    }

    @Override
    public void configureAreaForGroup(Style style, Camera camera) {
        Area$class.configureAreaForGroup(this, style, camera);
    }

    @Override
    public void configureAreaForElement(Backend backend, Camera camera, AreaSkeleton skel, GraphicElement element, ShapeDecor decor) {
        Area$class.configureAreaForElement(this, backend, camera, skel, element, decor);
    }

    public Ellipse2D.Double theShape() {
        return this.theShape;
    }

    public double[] theValues() {
        return this.theValues;
    }

    public void theValues_$eq(double[] x$1) {
        this.theValues = x$1;
    }

    public Object valuesRef() {
        return this.valuesRef;
    }

    public void valuesRef_$eq(Object x$1) {
        this.valuesRef = x$1;
    }

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        this.configureAreaForGroup(style, camera);
        this.configureFillableMultiColoredForGroup(style, camera);
        this.configureStrokableForGroup(style, camera);
        this.configureShadowableForGroup(style, camera);
        this.configureDecorableForGroup(style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        Graphics2D g = bck.graphics2D();
        this.configureDecorableForElement(bck, camera, element, skel);
        this.configureAreaForElement(bck, camera, (AreaSkeleton)skel, element, this.theDecor());
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.theShape().setFrameFromCenter(this.theCenter().x, this.theCenter().y, this.theCenter().x + this.theSize().x / (double)2, this.theCenter().y + this.theSize().y / (double)2);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.theShape().setFrameFromCenter(this.theCenter().x + this.theShadowOff().x, this.theCenter().y + this.theShadowOff().y, this.theCenter().x + (this.theSize().x + this.theShadowWidth().x) / (double)2, this.theCenter().y + (this.theSize().y + this.theShadowWidth().y) / (double)2);
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.makeShadow(bck, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(bck, camera);
        this.checkValues(element);
        this.fillPies(g, element);
        this.stroke(g, this.theShape());
        this.decorArea(bck, camera, skel.iconAndText(), element, this.theShape());
    }

    public void checkValues(GraphicElement element) {
        Object pieValues = element.getAttribute("ui.pie-values");
        if (pieValues != null) {
            Object oldRef = this.valuesRef();
            this.valuesRef_$eq(pieValues);
            this.theValues_$eq(this.getDoubles(this.valuesRef()));
        }
    }

    public void fillPies(Graphics2D g, GraphicElement element) {
        if (this.theValues() != null) {
            Arc2D.Double arc = new Arc2D.Double();
            DoubleRef beg = new DoubleRef(0.0);
            DoubleRef end = new DoubleRef(0.0);
            IntRef col = new IntRef(0);
            DoubleRef sum = new DoubleRef(0.0);
            Predef$.MODULE$.doubleArrayOps(this.theValues()).foreach((Function1)new Serializable(this, g, arc, beg, end, col, sum){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PieChartShape $outer;
                private final Graphics2D g$1;
                private final Arc2D.Double arc$1;
                private final DoubleRef beg$1;
                private final DoubleRef end$1;
                private final IntRef col$1;
                private final DoubleRef sum$1;

                public final void apply(double value) {
                    this.apply$mcVD$sp(value);
                }

                public void apply$mcVD$sp(double value) {
                    this.end$1.elem = this.beg$1.elem + value;
                    this.arc$1.setArcByCenter(this.$outer.theCenter().x, this.$outer.theCenter().y, this.$outer.theSize().x / (double)2, this.beg$1.elem * (double)360, value * (double)360, 2);
                    this.g$1.setColor(this.$outer.fillColors()[this.col$1.elem % this.$outer.fillColors().length]);
                    this.g$1.fill(this.arc$1);
                    this.beg$1.elem = this.end$1.elem;
                    this.sum$1.elem += value;
                    ++this.col$1.elem;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.g$1 = g$1;
                    this.arc$1 = arc$1;
                    this.beg$1 = beg$1;
                    this.end$1 = end$1;
                    this.col$1 = col$1;
                    this.sum$1 = sum$1;
                }
            });
            if (sum.elem > (double)1.01f) {
                Logger.getLogger(this.getClass().getSimpleName()).warning(new StringOps(Predef$.MODULE$.augmentString("[Sprite %s] The sum of values for ui.pie-value should eval to 1 at max (actually %f).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.getId(), BoxesRunTime.boxToDouble((double)sum.elem)})));
            }
        } else {
            g.setColor(Color.red);
            g.draw(this.theShape());
        }
    }

    public PieChartShape() {
        Area$class.$init$(this);
        FillableMulticolored$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        HasSkel$class.$init$(this);
        Decorable$class.$init$(this);
        AttributeUtils$class.$init$(this);
        this.theShape = new Ellipse2D.Double();
        this.theValues = null;
        this.valuesRef = null;
    }
}

