/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ConverterFactory;
import com.github.joschi.jadconfig.DefaultConverterFactory;
import com.github.joschi.jadconfig.LazyValidationException;
import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.ReflectionUtils;
import com.github.joschi.jadconfig.Repository;
import com.github.joschi.jadconfig.RepositoryException;
import com.github.joschi.jadconfig.Strings;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.NoConverter;
import com.github.joschi.jadconfig.converters.StringConverter;
import com.github.joschi.jadconfig.response.ProcessingOutcome;
import com.github.joschi.jadconfig.response.ProcessingResponse;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JadConfig.class);
    private final LinkedList<ConverterFactory> converterFactories = new LinkedList();
    private List<Object> configurationBeans;
    private List<Repository> repositories;

    public JadConfig() {
        this(Collections.emptyList(), new Object[0]);
    }

    public JadConfig(Repository repository, Object ... configurationBeans) {
        this(Collections.singletonList(repository), configurationBeans);
    }

    public JadConfig(Collection<Repository> repositories, Object ... configurationBeans) {
        this.configurationBeans = new ArrayList<Object>(Arrays.asList(configurationBeans));
        this.repositories = new ArrayList<Repository>(repositories);
        this.converterFactories.add(new DefaultConverterFactory());
    }

    public void process() throws RepositoryException, ValidationException {
        for (Repository repository : this.repositories) {
            LOG.debug("Opening repository {}", (Object)repository);
            repository.open();
        }
        for (Object configurationBean : this.configurationBeans) {
            LOG.debug("Processing configuration bean {}", configurationBean);
            this.processClassFields(configurationBean, ReflectionUtils.getAllFields(configurationBean.getClass()));
            this.invokeValidatorMethods(configurationBean, ReflectionUtils.getAllMethods(configurationBean.getClass()));
        }
    }

    public void processFailingLazily() throws RepositoryException, LazyValidationException {
        ProcessingResponse result = this.doProcessFailingLazily();
        if (!result.isSuccess()) {
            throw new LazyValidationException(result);
        }
    }

    ProcessingResponse doProcessFailingLazily() throws RepositoryException {
        for (Repository repository : this.repositories) {
            LOG.debug("Opening repository {}", (Object)repository);
            repository.open();
        }
        return this.configurationBeans.stream().peek(bean -> LOG.debug("Processing configuration bean {}", bean)).map(this::processBean).collect(Collectors.collectingAndThen(Collectors.toList(), ProcessingResponse::new));
    }

    private ProcessingOutcome processBean(Object bean) {
        Map<String, Exception> fieldProcessingProblems = this.processClassFieldsFailingLazily(bean, ReflectionUtils.getAllFields(bean.getClass()));
        Map<String, Exception> validationMethodsProblems = this.invokeValidatorMethodsFailingLazily(bean, ReflectionUtils.getAllMethods(bean.getClass()));
        return new ProcessingOutcome(bean, fieldProcessingProblems, validationMethodsProblems);
    }

    private void processClassFields(Object configurationBean, Field[] fields) throws ValidationException {
        for (Field field : fields) {
            this.processClassField(configurationBean, field);
        }
    }

    private Map<String, Exception> processClassFieldsFailingLazily(Object configurationBean, Field[] fields) {
        HashMap<String, Exception> fieldProcessingProblems = new HashMap<String, Exception>();
        for (Field field : fields) {
            try {
                this.processClassField(configurationBean, field);
            }
            catch (Exception ex) {
                fieldProcessingProblems.put(field.getAnnotation(Parameter.class).value(), ex);
            }
        }
        return fieldProcessingProblems;
    }

    private void processClassField(Object configurationBean, Field field) throws ValidationException {
        Parameter parameter = field.getAnnotation(Parameter.class);
        if (parameter != null) {
            LOG.debug("Processing field {}", (Object)parameter);
            Object fieldValue = this.getFieldValue(field, configurationBean);
            String parameterName = parameter.value();
            String parameterValue = this.lookupParameter(parameterName).orElseGet(() -> this.lookupFallbackParameter(parameter));
            if (parameterValue == null && fieldValue == null && parameter.required()) {
                throw new ParameterException("Required parameter \"" + parameterName + "\" not found.");
            }
            if (parameterValue != null) {
                if (parameter.trim()) {
                    LOG.debug("Trimmed parameter value {}", (Object)parameterName);
                    parameterValue = Strings.trim(parameterValue);
                }
                LOG.debug("Converting parameter value {}", (Object)parameterName);
                try {
                    fieldValue = this.convertStringValue(field.getType(), parameter.converter(), parameterValue);
                }
                catch (ParameterException e) {
                    throw new ParameterException("Couldn't convert value for parameter \"" + parameterName + "\"", e);
                }
                LOG.debug("Validating parameter {}", (Object)parameterName);
                ArrayList validators = new ArrayList(Collections.singleton(parameter.validator()));
                validators.addAll(Arrays.asList(parameter.validators()));
                this.validateParameter(validators, parameterName, fieldValue);
            }
            LOG.debug("Setting parameter {} to {}", (Object)parameterName, fieldValue);
            try {
                field.set(configurationBean, fieldValue);
            }
            catch (Exception e) {
                throw new ParameterException("Couldn't set field " + field.getName(), e);
            }
        }
    }

    private String lookupFallbackParameter(Parameter parameter) {
        Optional fallbackValue = Optional.ofNullable(parameter.fallbackPropertyName()).filter(fallbackName -> !fallbackName.trim().isEmpty()).flatMap(this::lookupParameter);
        fallbackValue.ifPresent(value -> LOG.warn("Primary parameter {} not found, using the fallback value of {}. Please correct your configuration if possible.", (Object)parameter.value(), (Object)parameter.fallbackPropertyName()));
        return fallbackValue.orElse(null);
    }

    private Optional<String> lookupParameter(String parameterName) {
        return this.repositories.stream().peek(repository -> LOG.debug("Looking up parameter {} in repository {}", (Object)parameterName, repository)).map(repository -> repository.read(parameterName)).filter(Objects::nonNull).findFirst();
    }

    private Object convertStringValue(Class<?> fieldType, Class<? extends Converter<?>> converterClass, String stringValue) {
        Converter converter = this.getConverter(fieldType, converterClass);
        LOG.debug("Loaded converter class for type {}: {}", fieldType, (Object)converter);
        return converter.convertFrom(stringValue);
    }

    private Object getFieldValue(Field field, Object bean) {
        try {
            return ReflectionUtils.getFieldValue(bean, field);
        }
        catch (IllegalAccessException e) {
            throw new ParameterException("Couldn't obtain value of field " + field.getName(), e);
        }
    }

    private Converter getConverter(Class<?> fieldType, Class<? extends Converter<?>> converterClass) {
        LOG.debug("Trying to find converter class {} for type {}", converterClass, fieldType);
        Class<Converter<Object>> clazz = converterClass;
        if (clazz == null || clazz == NoConverter.class) {
            clazz = this.findConverter(fieldType);
        }
        if (clazz == null) {
            clazz = StringConverter.class;
            LOG.debug("Using fallback converter: {}", clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ParameterException("Couldn't initialize converter class " + clazz.getCanonicalName(), e);
        }
    }

    private void validateParameter(Collection<Class<? extends Validator<?>>> validatorClasses, String name, Object value) throws ValidationException {
        LOG.debug("Validating parameter {} with value {}", (Object)name, value);
        for (Class<Validator<?>> validatorClass : validatorClasses) {
            Validator<?> validator;
            try {
                validator = validatorClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Couldn't initialize validator " + validatorClass.getCanonicalName(), e);
            }
            validator.validate(name, value);
        }
    }

    private void invokeValidatorMethods(Object configurationBean, Method[] methods) throws ValidationException {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(configurationBean, ValidatorMethod.class, methods);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ValidationException) {
                throw (ValidationException)e.getTargetException();
            }
            throw new ValidationException("Couldn't run validator method", e);
        }
        catch (Exception e) {
            throw new ValidationException("Couldn't run validator method", e);
        }
    }

    private Map<String, Exception> invokeValidatorMethodsFailingLazily(Object configurationBean, Method[] methods) {
        HashMap<String, Exception> problems = new HashMap<String, Exception>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(ValidatorMethod.class)) continue;
            try {
                method.invoke(configurationBean, new Object[0]);
            }
            catch (InvocationTargetException invEx) {
                if (invEx.getTargetException() instanceof ValidationException) {
                    problems.put(method.getName(), (ValidationException)invEx.getTargetException());
                    continue;
                }
                problems.put(method.getName(), invEx);
            }
            catch (Exception ex) {
                problems.put(method.getName(), ex);
            }
        }
        return problems;
    }

    private <T> Class<? extends Converter<T>> findConverter(Class<T> clazz) {
        for (ConverterFactory factory : this.converterFactories) {
            Class<Converter<T>> result = factory.getConverter(clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public JadConfig addConverterFactory(ConverterFactory converterFactory) {
        this.converterFactories.addFirst(converterFactory);
        LOG.info("Added converter factory {}", (Object)converterFactory);
        return this;
    }

    public JadConfig addConfigurationBean(Object configurationBean) {
        this.configurationBeans.add(configurationBean);
        LOG.info("Added configuration bean {}", configurationBean);
        return this;
    }

    public Map<String, String> dump() {
        HashMap<String, String> configurationDump = new HashMap<String, String>();
        for (Object configurationBean : this.configurationBeans) {
            for (Field field : ReflectionUtils.getAllFields(configurationBean.getClass())) {
                Parameter parameter = field.getAnnotation(Parameter.class);
                if (parameter == null) continue;
                Object fieldValue = this.getFieldValue(field, configurationBean);
                configurationDump.put(parameter.value(), this.convertFieldValue(field.getType(), parameter.converter(), fieldValue));
            }
        }
        return configurationDump;
    }

    private String convertFieldValue(Class<?> fieldType, Class<? extends Converter<?>> converterClass, Object fieldValue) {
        if (null != fieldValue) {
            Converter converter = this.getConverter(fieldType, converterClass);
            LOG.debug("Converting {} to type {} using converter {}", new Object[]{fieldValue, fieldType, converter});
            return converter.convertTo(fieldValue);
        }
        return "null";
    }

    public JadConfig setRepository(Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("The repository must not be null.");
        }
        this.repositories = Collections.singletonList(repository);
        return this;
    }

    public JadConfig setRepositories(Collection<Repository> repositories) {
        if (repositories == null || repositories.isEmpty()) {
            throw new IllegalArgumentException("At least 1 repository is required.");
        }
        this.repositories = new ArrayList<Repository>(repositories);
        return this;
    }

    public JadConfig setRepositories(Repository ... repositories) {
        if (repositories == null || repositories.length < 1) {
            throw new IllegalArgumentException("At least 1 repository is required.");
        }
        this.repositories = new ArrayList<Repository>(Arrays.asList(repositories));
        return this;
    }

    public List<ConverterFactory> getConverterFactories() {
        return Collections.unmodifiableList(this.converterFactories);
    }

    public List<Object> getConfigurationBeans() {
        return Collections.unmodifiableList(this.configurationBeans);
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }
}

